// MM2DOCV.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm2docv.h"	// config.h is here -> we get ENABLE-macros here...

#ifdef ENABLE_GRAPHICS
#include "mm2rbn.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include "mm1mdl.h"

#include <fstream>
#include <strstream>
using namespace std;

/*################################################################################################*/

mm2_cm_state mm2_docv::cm_state = mm2_cm_state();
mm2_cm_residue mm2_docv::cm_residue = mm2_cm_residue();
mm2_cm_sasa mm2_docv::cm_sasa = mm2_cm_sasa();

mm2_docv::mm2_docv(ostream * p1, graphics_class_factory & p2, mm2_eng_param * p3) :
	docview(p1, p2), mm2_mdl(p1, p2, p3), model_simple(p1, p2)
{
#define SIZE 3.0
#define THICKNESS 1.75

#define ALPHA 0.75

//	static fGL color[4] = { 0.0, 0.2, 1.0, ALPHA };
	
	static fGL point1[4][3];
	static fGL point2[4][3];
	
//	tpd_quad_4c * tmp4;
//	transparent_primitive * tmp5;
//	void * owner = NULL;
	
	point1[0][0] = +SIZE; point1[0][1] = +SIZE; point1[0][2] = +THICKNESS;
	point1[1][0] = -SIZE; point1[1][1] = +SIZE; point1[1][2] = +THICKNESS;
	point1[2][0] = -SIZE; point1[2][1] = -SIZE; point1[2][2] = +THICKNESS;
	point1[3][0] = +SIZE; point1[3][1] = -SIZE; point1[3][2] = +THICKNESS;
//	tmp4 = new tpd_quad_4c(color, point1[0], color, point1[1], color, point1[2], color, point1[3]);
//	tmp5 = new transparent_primitive(owner, * tmp4);
//	AddTP(owner, (* tmp5)); delete tmp5;
	
	point2[0][0] = +SIZE; point2[0][1] = +SIZE; point2[0][2] = -THICKNESS;
	point2[1][0] = -SIZE; point2[1][1] = +SIZE; point2[1][2] = -THICKNESS;
	point2[2][0] = -SIZE; point2[2][1] = -SIZE; point2[2][2] = -THICKNESS;
	point2[3][0] = +SIZE; point2[3][1] = -SIZE; point2[3][2] = -THICKNESS;
//	tmp4 = new tpd_quad_4c(color, point2[0], color, point2[1], color, point2[2], color, point2[3]);
//	tmp5 = new transparent_primitive(owner, * tmp4);
//	AddTP(owner, (* tmp5)); delete tmp5;
}

mm2_docv::~mm2_docv(void)
{
}

fGL mm2_docv::GetDefaultFocus(void)
{
	return 5.0;
}

const char * mm2_docv::GetType(void)
{
	return "MM, simplified protein model";
}

color_mode * mm2_docv::GetDefaultColorMode(void)
{
	return & mm2_docv::cm_state;
}

void mm2_docv::SelectAll(void)
{
	if (selected_object != NULL)
	{
		selected_object = NULL;
		event_SelectedObjectChanged();
	}
	
	for (i32u n1 = 0;n1 < chn_vector.size();n1++)
	{
		for (i32u n2 = 0;n2 < chn_vector[n1].res_vector.size();n2++)
		{
			chn_vector[n1].res_vector[n2].sel = true;
		}
	}
	
	UpdateAllGraphicsViews();
}

void mm2_docv::InvertSelection(void)
{
	if (selected_object != NULL)
	{
		selected_object = NULL;
		event_SelectedObjectChanged();
	}
	
	for (i32u n1 = 0;n1 < chn_vector.size();n1++)
	{
		for (i32u n2 = 0;n2 < chn_vector[n1].res_vector.size();n2++)
		{
			bool old = chn_vector[n1].res_vector[n2].sel;
			chn_vector[n1].res_vector[n2].sel = !old;
		}
	}
	
	UpdateAllGraphicsViews();
}

//void mm2_docv::SelectNone(void)
//{
//	for (i32u n1 = 0;n1 < chn_vector.size();n1++)
//	{
//		for (i32u n2 = 0;n2 < chn_vector[n1].res_vector.size();n2++)
//		{
//			chn_vector[n1].res_vector[n2].sel = false;
//		}
//	}
//	
//	UpdateAllGraphicsViews();
//}

bool mm2_docv::TestAtom(i32s c1, i32s r1, rmode rm)
{
	// what about the "visible"-flag???
	
	if (rm == Transform1 && chn_vector[c1].res_vector[r1].sel) return false;
	if (rm == Transform2 && !chn_vector[c1].res_vector[r1].sel) return false;
	
	return true;
}

bool mm2_docv::TestBond(i32s c1, i32s r1, i32s c2, i32s r2, rmode rm)
{
	// what about the "visible"-flag???
	
	if (rm == Transform1 && chn_vector[c1].res_vector[r1].sel) return false;
	if (rm == Transform2 && !chn_vector[c1].res_vector[r1].sel) return false;
	
	bool test = (chn_vector[c1].res_vector[r1].sel != chn_vector[c2].res_vector[r2].sel);
	if (rm != Normal && test) return false;
	
	return true;
}


void mm2_docv::DrawCylinder1(graphics_view * gv, i32s ** idata, i32s cset)
{
	fGL r1 = chn_vector[idata[0][0]].res_vector[idata[0][1]].vdwr[idata[0][2]];
	fGL r2 = chn_vector[idata[1][0]].res_vector[idata[1][1]].vdwr[idata[1][2]];
	fGL rsum = r1 + r2;
	
	for (i32s n1 = 0;n1 < 2;n1++)
	{
		fGL * crd1 = chn_vector[idata[n1][0]].res_vector[idata[n1][1]].crd_vector[idata[n1][2]][cset].data;
		fGL * crd2 = chn_vector[idata[!n1][0]].res_vector[idata[!n1][1]].crd_vector[idata[!n1][2]][cset].data;
		v3d<fGL> crt = v3d<fGL>(crd1, crd2);
		
		fGL pol[3]; crt2pol(crt.data, pol);
		
		if (chn_vector[idata[n1][0]].res_vector[idata[n1][1]].sel) glColor3f(1.0, 0.0, 1.0);	// select_color
		else
		{
			fGL_a4 color;
			mm2_cdata cdata; cdata.docv = this;
			cdata.index[0] = idata[n1][0]; cdata.index[1] = idata[n1][1]; cdata.index[2] = idata[n1][2];
			gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color);
		}
		
		const float radius = model_prefs->Double("MM2Graphics/CylinderSize", 0.1);
		const int resolution = model_prefs->Value("MM2Graphics/CylinderResolution", 10);
		
		GLUquadricObj * qo = gluNewQuadric();
		gluQuadricDrawStyle(qo, (GLenum) GLU_FILL); glPushMatrix();
		
		glTranslated(crd1[0], crd1[1], crd1[2]);
		
		glRotated(180.0 * pol[1] / M_PI, 0.0, 1.0, 0.0);
		glRotated(180.0 * pol[2] / M_PI, sin(-pol[1]), 0.0, cos(-pol[1]));
		
		fGL length = crt.len() * chn_vector[idata[n1][0]].res_vector[idata[n1][1]].vdwr[idata[n1][2]] / rsum;
		gluCylinder(qo, radius, radius, length, resolution, resolution / 2);
		
		glPopMatrix(); gluDeleteQuadric(qo);
	}
}

void mm2_docv::Render(graphics_view * gv, rmode rm)
{
	if (gv->enable_fog) glEnable(GL_FOG);
	
	const fGL default_sel_color[3] = { 1.0, 0.0, 1.0 };
	fGL *select_color = model_prefs->ColorRGB("Graphics/SelectColor", default_sel_color);
	
bool accum = gv->accumulate; if (rm != Normal) accum = false;
//if (accum) { glClear(GL_ACCUM_BUFFER_BIT); UpdateAccumValues(); }
//else if (rm != Transform2) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
////////////////////////////////////////////////// debug!!!
////////////////////////////////////////////////// debug!!!
//	glBegin(GL_POINTS);
//	for (i32u n1 = 0;n1 < debug_vector.size();n1++)
//	{
//		glColor3dv(debug_vector[n1].color);
//		glVertex3dv(debug_vector[n1].crd);
//	} glEnd();
////////////////////////////////////////////////// debug!!!
////////////////////////////////////////////////// debug!!!

	for (i32u n1 = 0;n1 < cs_vector.size();n1++)
	{
		if (!GetCRDSetVisible(n1)) continue;
		
		if (accum)
		{
glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// FIXME!!!
			gv->cam->RenderObjects(gv);
		}
		
		// disulphide bridges!!!
		// disulphide bridges!!!
		// disulphide bridges!!!
		
		//glColor3f(1.0, 1.0, 1.0);
		glLineWidth(1.0);
		for (i32u n2 = 0;n2 < dsb_vector.size();n2++)
		{
			if (!TestBond(dsb_vector[n2].chn[0], dsb_vector[n2].res[0], dsb_vector[n2].chn[1], dsb_vector[n2].res[1], rm)) continue;
			
			glBegin(GL_LINES);
			if (chn_vector[dsb_vector[n2].chn[0]].res_vector[dsb_vector[n2].res[0]].sel) glColor3fv(select_color); else glColor3f(1.0, 1.0, 1.0);
			glVertex3fv(chn_vector[dsb_vector[n2].chn[0]].res_vector[dsb_vector[n2].res[0]].crd_vector[1][n1].data);
			if (chn_vector[dsb_vector[n2].chn[1]].res_vector[dsb_vector[n2].res[1]].sel) glColor3fv(select_color); else glColor3f(1.0, 1.0, 1.0);
			glVertex3fv(chn_vector[dsb_vector[n2].chn[1]].res_vector[dsb_vector[n2].res[1]].crd_vector[1][n1].data);
			glEnd();
		}
		
		if (gv->render == RENDER_WIREFRAME)
		{
			glPointSize(3.0); glLineWidth(1.0);
			for (i32u n2 = 0;n2 < chn_vector.size();n2++)
			{
				for (i32s n3 = 0;n3 < ((i32s) chn_vector[n2].res_vector.size()) - 1;n3++)
				{
					if (!TestBond(n2, n3 + 0, n2, n3 + 1, rm)) continue;
					glBegin(GL_LINES);
					
					fGL_a4 color;
					mm2_cdata cdata; cdata.docv = this;
					
					cdata.index[0] = n2; cdata.index[1] = n3 + 0; cdata.index[2] = 0;
					if (chn_vector[n2].res_vector[n3 + 0].sel) glColor3fv(select_color);
					else { gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color); }
					glVertex3fv(chn_vector[n2].res_vector[n3 + 0].crd_vector[0][n1].data);
					
					cdata.index[0] = n2; cdata.index[1] = n3 + 1; cdata.index[2] = 0;
					if (chn_vector[n2].res_vector[n3 + 1].sel) glColor3fv(select_color);
					else { gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color); }
					glVertex3fv(chn_vector[n2].res_vector[n3 + 1].crd_vector[0][n1].data);
					
					glEnd();
				}
				
				for (i32u n3 = 0;n3 < chn_vector[n2].res_vector.size();n3++)
				{
					for (i32u n4 = 0;n4 < chn_vector[n2].res_vector[n3].natm;n4++)
					{
						if (!TestAtom(n2, n3, rm)) continue;
						glBegin(GL_POINTS);
						
						fGL_a4 color;
						mm2_cdata cdata; cdata.docv = this;
						
						cdata.index[0] = n2; cdata.index[1] = n3; cdata.index[2] = n4;
						if (chn_vector[n2].res_vector[n3].sel) glColor3fv(select_color);
						else { gv->colormode->GetColor(& cdata,  color, model_prefs); glColor3fv(color); }
						glVertex3fv(chn_vector[n2].res_vector[n3].crd_vector[n4][n1].data);
						
						glEnd();
					}
					
////////////////////////////////////////////////// allowed side-chain cones!!!
////////////////////////////////////////////////// allowed side-chain cones!!!
/*

bool test = false;
if (chn_vector[n2].res_vector[n3].natm > 1) test = true;

if (test && n3 && n3 != chn_vector[n2].res_vector.size() - 1)
{
	fGL length = 0.25;
	fGL angle = M_PI * 52.0 / 180.0;
	
	fGL * curr = chn_vector[n2].res_vector[n3].crd_vector[0][n1].data;
	
	fGL * prev = chn_vector[n2].res_vector[n3 - 1].crd_vector[0][n1].data;
	fGL * next = chn_vector[n2].res_vector[n3 + 1].crd_vector[0][n1].data;
	
	v3d<fGL> v1 = v3d<fGL>(curr, prev); v1 = v1 / v1.len();
	v3d<fGL> v2 = v3d<fGL>(curr, next); v2 = v2 / v2.len();
	
	v3d<fGL> v3 = v1.vpr(v2); v3 = v3 * (cos(angle) / v3.len());
	v3d<fGL> v4 = v1 + v2; v4 = v4 * (sin(angle) / v4.len());
	v3d<fGL> v5 = v3 - v4;
	
	v5 = v5 * (length / v5.len());
	v3d<fGL> v6 = v3d<fGL>(curr); v6 = v6 + v5;
	
////////////////////////////////////////
//	glBegin(GL_LINES);
//	glColor3f(1.0, 1.0, 1.0); glVertex3fv(v6.comp);
//	glVertex3fv(chn_vector[n2].res_vector[n3].crd[0][n1]);
//	glEnd();
////////////////////////////////////////

	v3d<fGL> crt = v3d<fGL>(curr, v6.data);
	fGL pol[3]; crt2pol(crt.data, pol);
	glColor3f(0.0, 1.0, 1.0);
	
	GLUquadricObj * qo;
	fGL t1 = chn_vector[n2].res_vector[n3].crd_vector[0][n1][0];
	fGL t2 = chn_vector[n2].res_vector[n3].crd_vector[0][n1][1];
	fGL t3 = chn_vector[n2].res_vector[n3].crd_vector[0][n1][2];
	glEnable(GL_LIGHTING);
	
	qo = gluNewQuadric();
	glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, true);
	gluQuadricDrawStyle(qo, (GLenum) GLU_FILL);
	
	glPushMatrix(); glTranslatef(t1, t2, t3);
	
	glRotated(180.0 * pol[1] / M_PI, 0.0, 1.0, 0.0);
	glRotated(180.0 * pol[2] / M_PI, sin(-pol[1]), 0.0, cos(-pol[1]));
	
	gluCylinder(qo, 0.0, length * tan(angle), length, 12, 1);
	glPopMatrix(); gluDeleteQuadric(qo);
	
	glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, false);
	glDisable(GL_LIGHTING);
}

*/
////////////////////////////////////////////////// allowed side-chain cones!!!
////////////////////////////////////////////////// allowed side-chain cones!!!

					for (i32s n4 = 0;n4 < ((i32s) chn_vector[n2].res_vector[n3].natm) - 1;n4++)
					{
						if (!TestBond(n2, n3, n2, n3, rm)) continue;
						glBegin(GL_LINES);
						
						fGL_a4 color;
						mm2_cdata cdata; cdata.docv = this;
						
						cdata.index[0] = n2; cdata.index[1] = n3; cdata.index[2] = n4 + 0;
						if (chn_vector[n2].res_vector[n3].sel) glColor3fv(select_color);
						else { gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color); }
						glVertex3fv(chn_vector[n2].res_vector[n3].crd_vector[n4 + 0][n1].data);
						
						cdata.index[0] = n2; cdata.index[1] = n3; cdata.index[2] = n4 + 1;
						if (chn_vector[n2].res_vector[n3].sel) glColor3fv(select_color);
						else { gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color); }
						glVertex3fv(chn_vector[n2].res_vector[n3].crd_vector[n4 + 1][n1].data);
						
						glEnd();
					}
				}
			}
			
			// the peptide units!!!
			// the peptide units!!!
			// the peptide units!!!
			
			glEnable(GL_LIGHTING);
			glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, true);
			
			glBegin(GL_QUADS);      
			for (i32u n2 = 0;n2 < chn_vector.size();n2++)
			{
				for (i32s n3 = 1;n3 < ((i32s) chn_vector[n2].res_vector.size()) - 2;n3++)
				{
					char symbol2 = chn_vector[n2].res_vector[n3 + 1].symbol;
					if (symbol2 == 'P') continue;	// skip all X-pro cases !!!

					if (!TestBond(n2, n3 + 0, n2, n3 + 1, rm)) continue;
					
					fGL * curr = chn_vector[n2].res_vector[n3].crd_vector[0][n1].data;
					fGL * prev = chn_vector[n2].res_vector[n3 - 1].crd_vector[0][n1].data;
					fGL * next = chn_vector[n2].res_vector[n3 + 1].crd_vector[0][n1].data;
					
					v3d<fGL> v1(prev, curr); v3d<fGL> v2(curr, next);
					
					v3d<fGL> v3 = v1.vpr(v2); v3 = v3 * (0.075 / v3.len());
					v3d<fGL> v4 = v3.vpr(v2); v4 = v4 * (0.075 / v4.len());
					
					fGL peptide = chn_vector[n2].res_vector[n3].peptide_vector[n1];
					v3d<fGL> v5 = (v3 * sin(peptide)) + (v4 * cos(peptide));
					
					fGL peptnorm = peptide - M_PI / 2.0;
					v3d<fGL> normal = (v3 * sin(peptnorm)) + (v4 * cos(peptnorm));
					normal = normal / normal.len(); glNormal3fv(normal.data);
					
					v3d<fGL> pvc(curr);
					v3d<fGL> pv1 = pvc + (v2 * 0.5) + v5; v3d<fGL> pv2 = pvc + (v2 * 0.90);
					v3d<fGL> pv3 = pvc + (v2 * 0.5) - v5; v3d<fGL> pv4 = pvc + (v2 * 0.10);
					
					glColor3f(1.0, 0.0, 0.0); glVertex3fv(pv1.data);
					glColor3f(0.0, 1.0, 0.0); glVertex3fv(pv2.data);
					glColor3f(0.0, 0.0, 1.0); glVertex3fv(pv3.data);
					glColor3f(0.0, 1.0, 0.0); glVertex3fv(pv4.data);
				}
			}
			
			glEnd();	// GL_QUADS
			
			glDisable(GL_LIGHTING);
			glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, false);
		}
		
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

		if (gv->render != RENDER_WIREFRAME && gv->render != RENDER_NOTHING)
		{
//			glEnable(GL_FOG);
			glEnable(GL_LIGHTING);
			
			for (i32u n2 = 0;n2 < chn_vector.size();n2++)
			{
				for (i32u n3 = 0;n3 < chn_vector[n2].res_vector.size();n3++)
				{
					if (!TestAtom(n2, n3, rm)) continue;
					
					glPushName(GLNAME_MD_TYPE1);
					glPushName((i32u) ((n2 << 16) + n3));
					
					for (i32u n4 = 0;n4 < chn_vector[n2].res_vector[n3].natm;n4++)
					{
						fGL_a4 color;
						mm2_cdata cdata; cdata.docv = this;
						
						cdata.index[0] = n2; cdata.index[1] = n3; cdata.index[2] = n4;
						gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color);
						
						if (chn_vector[n2].res_vector[n3].sel) glColor3f(1.0, 0.0, 1.0);
						
						float rad = 0.0; int res = 0;
						switch (gv->render)
						{
							case RENDER_BALL_AND_STICK:
					rad = model_prefs->Double("MM2Graphics/BallSize", 0.5) * chn_vector[n2].res_vector[n3].vdwr[n4];
					res = model_prefs->Value("MM2Graphics/BallResolution", 12);
							break;
							
							case RENDER_VAN_DER_WAALS:
							case RENDER_ACCESSIBLE:
					rad = chn_vector[n2].res_vector[n3].vdwr[n4];
					res = model_prefs->Value("MM2Graphics/BallResolution", 12);
					if (gv->render == RENDER_ACCESSIBLE) rad += 0.15;
							break;
							
							case RENDER_CYLINDERS:
					rad = model_prefs->Double("MM2Graphics/CylinderSize", 0.1);
					res = model_prefs->Value("MM2Graphics/CylinderResolution", 12);
							break;
						}
						
						GLUquadricObj * qo = gluNewQuadric();
						gluQuadricDrawStyle(qo, (GLenum) GLU_FILL); glPushMatrix();
						fGL t1 = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][0];
						fGL t2 = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][1];
						fGL t3 = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][2];
						glTranslatef(t1, t2, t3); gluSphere(qo, rad, res, res / 2);
						glPopMatrix(); gluDeleteQuadric(qo);
						
if (fabs(chn_vector[n2].res_vector[n3].charge[n4]) < LAYER_LIMIT)
{
/*	rad = chn_vector[n2].res_vector[n3].vdwr[n4] + 0.15;
	
	if (chn_vector[n2].res_vector[n3].type[n4] == TYPE_CPOS) glColor3f(1.0, 0.0, 0.0);
	if (chn_vector[n2].res_vector[n3].type[n4] == TYPE_CNEG) glColor3f(0.0, 0.0, 1.0);
	
	qo = gluNewQuadric();
	gluQuadricDrawStyle(qo, (GLenum) GLU_LINE); glPushMatrix();
	glTranslatef(t1, t2, t3); gluSphere(qo, rad + 0.15, res, res / 2);
	glPopMatrix(); gluDeleteQuadric(qo);
	
	qo = gluNewQuadric();
	gluQuadricDrawStyle(qo, (GLenum) GLU_LINE); glPushMatrix();
	glTranslatef(t1, t2, t3); gluSphere(qo, rad + 0.30, res, res / 2);
	glPopMatrix(); gluDeleteQuadric(qo);	*/
}
					}
					
					glPopName();
					glPopName();
				}
			}
			
//			glDisable(GL_FOG);
			glDisable(GL_LIGHTING);
		}
		
		if (gv->render == RENDER_BALL_AND_STICK || gv->render == RENDER_CYLINDERS)
		{
//			glEnable(GL_FOG);
			glEnable(GL_LIGHTING);
			
			for (i32u n2 = 0;n2 < chn_vector.size();n2++)
			{
				for (i32s n3 = 0;n3 < ((i32s) chn_vector[n2].res_vector.size()) - 1;n3++)
				{
					if (!TestBond(n2, n3 + 0, n2, n3 + 1, rm)) continue;
					
					i32s idata1[3] = { n2, n3 + 0, 0 };
					i32s idata2[3] = { n2, n3 + 1, 0 };
					i32s * ii[2] = { idata1, idata2 };
					
					DrawCylinder1(gv, ii, n1);
				}
				
				for (i32u n3 = 0;n3 < chn_vector[n2].res_vector.size();n3++)
				{
					for (i32s n4 = 0;n4 < ((i32s) chn_vector[n2].res_vector[n3].natm) - 1;n4++)
					{
						if (!TestBond(n2, n3, n2, n3, rm)) continue;
						
						i32s idata1[3] = { n2, n3, n4 + 0 };
						i32s idata2[3] = { n2, n3, n4 + 1 };
						i32s * ii[2] = { idata1, idata2 };
						
						DrawCylinder1(gv, ii, n1);
					}
				}
			}
			
//			glDisable(GL_FOG);
			glDisable(GL_LIGHTING);
		}
		
////////////////////////////////////////////////// labels!!!
////////////////////////////////////////////////// labels!!!

		if (gv->label != LABEL_NOTHING)		// not used anywhere?!?!?
		{
			glColor3f(0.0, 1.0, 1.0); char string[256];
			for (i32u n2 = 0;n2 < chn_vector.size();n2++)
			{
				for (i32s n3 = 0;n3 < ((i32s) chn_vector[n2].res_vector.size()) - 1;n3++)
				{
					for (i32u n4 = 0;n4 < chn_vector[n2].res_vector[n3].natm;n4++)
					{
						ostrstream str(string, sizeof(string));
						
						switch (gv->label)
						{
							case LABEL_RESIDUE:
							if (n4 != 0) continue;
							str << (n3 + 1) << ends;
							break;
							
							default:
							str << chn_vector[n2].res_vector[n3].label[n4] << ends;
						}
						
						fGL x = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][0];
						fGL y = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][1];
						fGL z = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][2];
						
						gv->WriteGlutString3D(string, x, y, z, gv->cam->GetLocData(), GLUT_BITMAP_9_BY_15);
					}
				}
			}
		}
		
////////////////////////////////////////////////// labels!!!
////////////////////////////////////////////////// labels!!!

		if (accum)
		{
			gv->cam->RenderObjects(gv);
			glAccum(GL_ACCUM, cs_vector[n1]->accum_value);
		}
	}
	
	if (accum) glAccum(GL_RETURN, 1.0);
	else if (rm != Transform2) gv->cam->RenderObjects(gv);
	
	if (gv->enable_fog) glDisable(GL_FOG);
	
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	
	RenderAllTPs(gv, rm);
	
	delete[] select_color;
}

void mm2_docv::Center(transformer *)
{
}

void mm2_docv::Transform(transformer * p1)
{
	fGL matrix[16]; p1->GetMatrix(matrix);
	
	for (i32u n2 = 0;n2 < chn_vector.size();n2++)
	{
		for (i32u n3 = 0;n3 < chn_vector[n2].res_vector.size();n3++)
		{
			if (!chn_vector[n2].res_vector[n3].sel) continue;	// selection is by residue...
			
			for (i32u n4 = 0;n4 < chn_vector[n2].res_vector[n3].natm;n4++)
			{
				
			//	for (i32u n1 = 0;n1 < cs_vector.size();n1++)
				i32u n1 = 0;	// transform only 1st set...
				{
					v3d<fGL> posv = v3d<fGL>(chn_vector[n2].res_vector[n3].crd_vector[n4][n1].data);
					TransformVector(posv, matrix);
					
					chn_vector[n2].res_vector[n3].crd_vector[n4][n1].data[0] = posv[0];
					chn_vector[n2].res_vector[n3].crd_vector[n4][n1].data[1] = posv[1];
					chn_vector[n2].res_vector[n3].crd_vector[n4][n1].data[2] = posv[2];
				}
			}
		}
	}
}

void mm2_docv::DrawEvent(graphics_view *, vector<iGLu> &)
{
}

void mm2_docv::EraseEvent(graphics_view *, vector<iGLu> &)
{
}

void mm2_docv::SelectEvent(graphics_view *, vector<iGLu> & names)
{
	if (names[0] == GLNAME_MD_TYPE1)
	{
		i32s chn = (names[1] >> 16);
		i32s res = (names[1] & 0xFFFF);
		
		chn_vector[chn].res_vector[res].sel = !chn_vector[chn].res_vector[res].sel;
		UpdateAllGraphicsViews();
		
		cout << "chn = " << chn << " res = " << res << " ";
		cout << "symbol = " << chn_vector[chn].res_vector[res].symbol << endl;
	}
}

void mm2_docv::MeasureEvent(graphics_view *, vector<iGLu> &)
{
}

void mm2_docv::ProcessCommandString(graphics_view * gv, const char * command)
{
	char mbuff1[512];
	ostrstream str1(mbuff1, sizeof(mbuff1));
	str1 << "Processing Command : " << command << endl << ends;
	PrintToLog(mbuff1);
	
	bool retval = ProcessCommonCommands(gv, command);
	if (retval == true) return;
	
	istrstream istr(command);
	char kw1[32]; istr >> kw1;
	
	// is it "help"??? if is, then append...
	if (!strcmp("help", kw1))
	{
		PrintToLog("> add plane <vf> <cf> <cscale> <dim> <res> <tp> <alpha> -- add a plane object.\n");
		PrintToLog(">   where: <vf> = value function : esp vdws dist unity\n");
		PrintToLog(">          <cf> = colour function : red green blue rb1 rb2\n");
		PrintToLog(">          <cscale> = scaling value for calculating the colours\n");
		PrintToLog(">          <dim> = dimension of the plane object (in nm units)\n");
		PrintToLog(">          <res> = resolution of the plane object\n");
		PrintToLog(">          <tp> = 0 or 1 telling if the object is transparent\n");
		PrintToLog(">          <alpha> = transparency alpha value\n");
		
		PrintToLog("> add volrend <vf> <cf> <cscale> <dim> <res> <alpha> -- add a volume-rendering object.\n");
		PrintToLog(">   where: <vf> = value function : esp vdws dist unity\n");
		PrintToLog(">          <cf> = colour function : red green blue rb1 rb2\n");
		PrintToLog(">          <cscale> = scaling value for calculating the colours\n");
		PrintToLog(">          <dim> = dimension of the plane object (in nm units)\n");
		PrintToLog(">          <res> = resolution of the plane object\n");
		PrintToLog(">          <alpha> = transparency alpha value\n");
		
		PrintToLog("> add surf1 <vf1> <vf2> <cf> <sscale> <cscale> <dim> <res> <solid> <tp> <alpha> -- add a single surface object.\n");
		PrintToLog(">   where: <vf1> = value function for calculating the surface : esp vdws dist unity\n");
		PrintToLog(">          <vf2> = value function for calculating the colours : esp vdws dist unity\n");
		PrintToLog(">          <cf> = colour function : red green blue rb1 rb2\n");
		PrintToLog(">          <sscale> = scaling value for calculating the surface\n");
		PrintToLog(">          <cscale> = scaling value for calculating the colours\n");
		PrintToLog(">          <dim> = dimension of the plane object (in nm units)\n");
		PrintToLog(">          <res> = resolution of the plane object\n");
		PrintToLog(">          <solid> = 0 or 1 telling if the object is solid\n");
		PrintToLog(">          <tp> = 0 or 1 telling if the object is transparent\n");
		PrintToLog(">          <alpha> = transparency alpha value\n");
		
		PrintToLog("> add surf2 <vf1> <vf2> <cf1> <cf2> <sscale1> <sscale2> <cscale> <dim> <res> <solid> <tp> <alpha> -- add a pair of surface objects.\n");
		PrintToLog(">   where: <vf1> = value function for calculating the surface : esp vdws dist unity\n");
		PrintToLog(">          <vf2> = value function for calculating the colours : esp vdws dist unity\n");
		PrintToLog(">          <cf1> = colour function for 1st surface : red green blue rb1 rb2\n");
		PrintToLog(">          <cf2> = colour function for 2nd surface : red green blue rb1 rb2\n");
		PrintToLog(">          <sscale1> = scaling value for calculating the surface for 1st surface\n");
		PrintToLog(">          <sscale2> = scaling value for calculating the surface for 2nd surface\n");
		PrintToLog(">          <cscale> = scaling value for calculating the colours\n");
		PrintToLog(">          <dim> = dimension of the plane object (in nm units)\n");
		PrintToLog(">          <res> = resolution of the plane object\n");
		PrintToLog(">          <solid> = 0 or 1 telling if the object is solid\n");
		PrintToLog(">          <tp> = 0 or 1 telling if the object is transparent\n");
		PrintToLog(">          <alpha> = transparency alpha value\n");
		
		return;
	}
	
	// process other commands.
	// process other commands.
	// process other commands.
	
	if (!strcmp("add", kw1))
	{
		char kw2[32]; istr >> kw2;	// the 2nd keyword; type of the object to add.
		char object_name[128];
		
		if (!strcmp("plane", kw2))
		{
			char kw3[32]; istr >> kw3;	// vf
			char kw4[32]; istr >> kw4;	// cf
			char kw5[32]; istr >> kw5;	// cscale
			char kw6[32]; istr >> kw6;	// dim
			char kw7[32]; istr >> kw7;	// res
			char kw8[32]; istr >> kw8;	// tp
			char kw9[32]; istr >> kw9;	// alpha
			char ** endptr = NULL;
			
			cp_param cpp;
			cpp.docv = this; cpp.ref = (mm1_docv *) this;
			
			if (!strcmp(kw3, "esp")) cpp.vf = (ValueFunction *) mm2_GetESPValue;
			else if (!strcmp(kw3, "vdws")) cpp.vf = (ValueFunction *) mm2_GetSASValue;
			else if (!strcmp(kw3, "dist")) cpp.vf = (ValueFunction *) GetDistance;
			else if (!strcmp(kw3, "unity")) cpp.vf = (ValueFunction *) GetUnity;
			else { PrintToLog("ERROR : add plane : unknown value function.\n"); return; }
			
			if (!strcmp(kw4, "red")) cpp.cf = (ColorFunction *) GetRedColor;
			else if (!strcmp(kw4, "green")) cpp.cf = (ColorFunction *) GetGreenColor;
			else if (!strcmp(kw4, "blue")) cpp.cf = (ColorFunction *) GetBlueColor;
			else if (!strcmp(kw4, "rb1")) cpp.cf = (ColorFunction *) GetRBRange1;
			else if (!strcmp(kw4, "rb2")) cpp.cf = (ColorFunction *) GetRBRange2;
			else { PrintToLog("ERROR : add plane : unknown colour function.\n"); return; }
			
			f64 cscale = strtod(kw5, endptr);
			
			f64 dim = strtod(kw6, endptr);
			
			i32s res = strtol(kw7, endptr, 10);
			if (res < 2) res = 2;
			
			i32s tp = strtol(kw8, endptr, 10);
			if (tp < 0) tp = 0; if (tp > 1) tp = 1;
			
			f64 alpha = strtod(kw9, endptr);
			
			cpp.value = cscale; cpp.dim = dim; cpp.np = res;
			cpp.transparent = tp; cpp.alpha = alpha;
			
			ostrstream strN(object_name, sizeof(object_name));
			strN << kw3 << "-" << ends;
			
			AddObject(new color_plane_object(ol_static(), cpp, object_name));
			UpdateAllGraphicsViews();
			
			ostrstream strR(mbuff1, sizeof(mbuff1));
			strR << "Added a new object : plane (" << kw3 << " " << kw4 << ")." << endl << ends;
			PrintToLog(mbuff1);
			return;
		}
		
		if (!strcmp("volrend", kw2))
		{
			char kw3[32]; istr >> kw3;	// vf
			char kw4[32]; istr >> kw4;	// cf
			char kw5[32]; istr >> kw5;	// cscale
			char kw6[32]; istr >> kw6;	// dim
			char kw7[32]; istr >> kw7;	// res
			char kw8[32]; istr >> kw8;	// alpha
			char ** endptr = NULL;
			
			cp_param cpp;
			cpp.docv = this; cpp.ref = (mm1_docv *) this;
			
			if (!strcmp(kw3, "esp")) cpp.vf = (ValueFunction *) mm2_GetESPValue;
			else if (!strcmp(kw3, "vdws")) cpp.vf = (ValueFunction *) mm2_GetSASValue;
			else if (!strcmp(kw3, "dist")) cpp.vf = (ValueFunction *) GetDistance;
			else if (!strcmp(kw3, "unity")) cpp.vf = (ValueFunction *) GetUnity;
			else { PrintToLog("ERROR : add volrend : unknown value function.\n"); return; }
			
			if (!strcmp(kw4, "red")) cpp.cf = (ColorFunction *) GetRedColor;
			else if (!strcmp(kw4, "green")) cpp.cf = (ColorFunction *) GetGreenColor;
			else if (!strcmp(kw4, "blue")) cpp.cf = (ColorFunction *) GetBlueColor;
			else if (!strcmp(kw4, "rb1")) cpp.cf = (ColorFunction *) GetRBRange1;
			else if (!strcmp(kw4, "rb2")) cpp.cf = (ColorFunction *) GetRBRange2;
			else { PrintToLog("ERROR : add volrend : unknown colour function.\n"); return; }
			
			f64 cscale = strtod(kw5, endptr);
			
			f64 dim = strtod(kw6, endptr);
			
			i32s res = strtol(kw7, endptr, 10);
			if (res < 4) res = 4;
			
			f64 alpha = strtod(kw8, endptr);
			
			cpp.value = cscale; cpp.dim = dim; cpp.np = res;
			cpp.transparent = true; cpp.alpha = alpha;
			
			ostrstream strN(object_name, sizeof(object_name));
			strN << kw3 << "-" << ends;
			
			AddObject(new volume_rendering_object(ol_static(), cpp, res / 2, dim / 2.0, (* gv->cam), object_name));
			UpdateAllGraphicsViews();
			
			ostrstream strR(mbuff1, sizeof(mbuff1));
			strR << "Added a new object : volrend (" << kw3 << " " << kw4 << ")." << endl << ends;
			PrintToLog(mbuff1);
			return;
		}
		
		if (!strcmp("surf1", kw2))
		{
			char kw3[32]; istr >> kw3;	// vf1
			char kw4[32]; istr >> kw4;	// vf2
			char kw5[32]; istr >> kw5;	// cf
			char kw6[32]; istr >> kw6;	// sscale
			char kw7[32]; istr >> kw7;	// cscale
			char kw8[32]; istr >> kw8;	// dim
			char kw9[32]; istr >> kw9;	// res
			char kwA[32]; istr >> kwA;	// solid
			char kwB[32]; istr >> kwB;	// tp
			char kwC[32]; istr >> kwC;	// alpha
			char ** endptr = NULL;
			
			cs_param csp1; csp1.docv = this; csp1.ref = (mm1_docv *) this; csp1.next = NULL;
			
			if (!strcmp(kw3, "esp")) csp1.vf1 = (ValueFunction *) mm2_GetESPValue;
			else if (!strcmp(kw3, "vdws")) csp1.vf1 = (ValueFunction *) mm2_GetSASValue;
			else if (!strcmp(kw3, "dist")) csp1.vf1 = (ValueFunction *) GetDistance;
			else if (!strcmp(kw3, "unity")) csp1.vf1 = (ValueFunction *) GetUnity;
			else { PrintToLog("ERROR : add surf1 : unknown value function 1.\n"); return; }
			
			if (!strcmp(kw4, "esp")) csp1.vf2 = (ValueFunction *) mm2_GetESPValue;
			else if (!strcmp(kw4, "vdws")) csp1.vf2 = (ValueFunction *) mm2_GetSASValue;
			else if (!strcmp(kw4, "dist")) csp1.vf2 = (ValueFunction *) GetDistance;
			else if (!strcmp(kw4, "unity")) csp1.vf2 = (ValueFunction *) GetUnity;
			else { PrintToLog("ERROR : add surf1 : unknown value function 2.\n"); return; }
			
			if (!strcmp(kw5, "red")) csp1.cf = (ColorFunction *) GetRedColor;
			else if (!strcmp(kw5, "green")) csp1.cf = (ColorFunction *) GetGreenColor;
			else if (!strcmp(kw5, "blue")) csp1.cf = (ColorFunction *) GetBlueColor;
			else if (!strcmp(kw5, "rb1")) csp1.cf = (ColorFunction *) GetRBRange1;
			else if (!strcmp(kw5, "rb2")) csp1.cf = (ColorFunction *) GetRBRange2;
			else { PrintToLog("ERROR : add surf1 : unknown colour function.\n"); return; }
			
			f64 sscale = strtod(kw6, endptr);
			f64 cscale = strtod(kw7, endptr);
			
			f64 dim = strtod(kw8, endptr);
			
			i32s res = strtol(kw9, endptr, 10);
			if (res < 4) res = 4;
			
			i32s solid = strtol(kwA, endptr, 10);
			if (solid < 0) solid = 0; if (solid > 1) solid = 1;

			i32s tp = strtol(kwB, endptr, 10);
			if (tp < 0) tp = 0; if (tp > 1) tp = 1;
			
			f64 alpha = strtod(kwC, endptr);
			
			static fGL dim_arr[3];
			dim_arr[0] = dim_arr[1] = dim_arr[2] = dim;
			
			static i32s res_arr[3];
			res_arr[0] = res_arr[1] = res_arr[2] = res;
			
			csp1.svalue = sscale; csp1.cvalue = cscale;
			csp1.dim = dim_arr; csp1.np = res_arr; csp1.wireframe = !solid;
			csp1.transparent = tp; csp1.alpha = alpha; csp1.toler = fabs(1.0e-6 * sscale); csp1.maxc = 250;
			
			ostrstream strN(object_name, sizeof(object_name));
			strN << kw3 << "-" << kw4 << "-" << ends;
			
			AddObject(new color_surface_object(ol_static(), csp1, object_name));
			UpdateAllGraphicsViews();
			
			ostrstream strR(mbuff1, sizeof(mbuff1));
			strR << "Added a new object : surf1 (" << kw3 << " " << kw4 << " " << kw5 << ")." << endl << ends;
			PrintToLog(mbuff1);
			return;
		}
		
		if (!strcmp("surf2", kw2))
		{
			char kw3[32]; istr >> kw3;	// vf1
			char kw4[32]; istr >> kw4;	// vf2
			char kw5[32]; istr >> kw5;	// cf1
			char kw6[32]; istr >> kw6;	// cf2
			char kw7[32]; istr >> kw7;	// sscale1
			char kw8[32]; istr >> kw8;	// sscale2
			char kw9[32]; istr >> kw9;	// cscale
			char kwA[32]; istr >> kwA;	// dim
			char kwB[32]; istr >> kwB;	// res
			char kwC[32]; istr >> kwC;	// solid
			char kwD[32]; istr >> kwD;	// tp
			char kwE[32]; istr >> kwE;	// alpha
			char ** endptr = NULL;
			
			cs_param csp2a; cs_param csp2b;
			
			csp2a.docv = this; csp2a.ref = (mm1_docv *) this; csp2a.next = & csp2b;

			csp2b.docv = this; csp2b.ref = (mm1_docv *) this; csp2b.next = NULL;
			
			if (!strcmp(kw3, "esp")) csp2a.vf1 = csp2b.vf1 = (ValueFunction *) mm2_GetESPValue;
			else if (!strcmp(kw3, "vdws")) csp2a.vf1 = csp2b.vf1 = (ValueFunction *) mm2_GetSASValue;
			else if (!strcmp(kw3, "dist")) csp2a.vf1 = csp2b.vf1 = (ValueFunction *) GetDistance;
			else if (!strcmp(kw3, "unity")) csp2a.vf1 = csp2b.vf1 = (ValueFunction *) GetUnity;
			else { PrintToLog("ERROR : add surf2 : unknown value function 1.\n"); return; }
			
			if (!strcmp(kw4, "esp")) csp2a.vf2 = csp2b.vf2 = (ValueFunction *) mm2_GetESPValue;
			else if (!strcmp(kw4, "vdws")) csp2a.vf2 = csp2b.vf2 = (ValueFunction *) mm2_GetSASValue;
			else if (!strcmp(kw4, "dist")) csp2a.vf2 = csp2b.vf2 = (ValueFunction *) GetDistance;
			else if (!strcmp(kw4, "unity")) csp2a.vf2 = csp2b.vf2 = (ValueFunction *) GetUnity;
			else { PrintToLog("ERROR : add surf2 : unknown value function 2.\n"); return; }
			
			if (!strcmp(kw5, "red")) csp2a.cf = (ColorFunction *) GetRedColor;
			else if (!strcmp(kw5, "green")) csp2a.cf = (ColorFunction *) GetGreenColor;
			else if (!strcmp(kw5, "blue")) csp2a.cf = (ColorFunction *) GetBlueColor;
			else if (!strcmp(kw5, "rb1")) csp2a.cf = (ColorFunction *) GetRBRange1;
			else if (!strcmp(kw5, "rb2")) csp2a.cf = (ColorFunction *) GetRBRange2;
			else { PrintToLog("ERROR : add surf2 : unknown colour function 1.\n"); return; }
			
			if (!strcmp(kw6, "red")) csp2b.cf = (ColorFunction *) GetRedColor;
			else if (!strcmp(kw6, "green")) csp2b.cf = (ColorFunction *) GetGreenColor;
			else if (!strcmp(kw6, "blue")) csp2b.cf = (ColorFunction *) GetBlueColor;
			else if (!strcmp(kw6, "rb1")) csp2b.cf = (ColorFunction *) GetRBRange1;
			else if (!strcmp(kw6, "rb2")) csp2b.cf = (ColorFunction *) GetRBRange2;
			else { PrintToLog("ERROR : add surf2 : unknown colour function 2.\n"); return; }
			
			f64 sscale1 = strtod(kw7, endptr);
			f64 sscale2 = strtod(kw8, endptr);
			f64 cscale = strtod(kw9, endptr);
			
			f64 dim = strtod(kwA, endptr);
			
			i32s res = strtol(kwB, endptr, 10);
			if (res < 4) res = 4;
			
			i32s solid = strtol(kwC, endptr, 10);
			if (solid < 0) solid = 0; if (solid > 1) solid = 1;

			i32s tp = strtol(kwD, endptr, 10);
			if (tp < 0) tp = 0; if (tp > 1) tp = 1;
			
			f64 alpha = strtod(kwE, endptr);
			
			static fGL dim_arr[3];
			dim_arr[0] = dim_arr[1] = dim_arr[2] = dim;
			
			static i32s res_arr[3];
			res_arr[0] = res_arr[1] = res_arr[2] = res;
			
			csp2a.svalue = sscale1; csp2a.cvalue = cscale;
			csp2a.dim = dim_arr; csp2a.np = res_arr; csp2a.wireframe = !solid;
			csp2a.transparent = tp; csp2a.alpha = alpha; csp2a.toler = fabs(1.0e-6 * sscale1); csp2a.maxc = 250;
			
			csp2b.svalue = sscale2; csp2b.cvalue = cscale;
			csp2b.dim = dim_arr; csp2b.np = res_arr; csp2b.wireframe = !solid;
			csp2b.transparent = tp; csp2b.alpha = alpha; csp2b.toler = fabs(1.0e-6 * sscale2); csp2b.maxc = 250;
			
			ostrstream strN(object_name, sizeof(object_name));
			strN << kw3 << "-" << kw4 << "-" << ends;
			
			AddObject(new color_surface_object(ol_static(), csp2a, object_name));
			UpdateAllGraphicsViews();
			
			ostrstream strR(mbuff1, sizeof(mbuff1));
			strR << "Added a new object : surf2 (" << kw3 << " " << kw4 << " " << kw5 << " " << kw6 << ")." << endl << ends;
			PrintToLog(mbuff1);
			return;
		}
		
		PrintToLog("ERROR : could not process a command : \"add\".\n");
	}
	
	// error message...
	ostrstream strE(mbuff1, sizeof(mbuff1)); strE << "ERROR : Unknown command : " << command << endl << ends;
	PrintToLog(mbuff1); PrintToLog("The \"help\" command will give more information about command strings.\n");
}

/*################################################################################################*/

void mm2_cm_state::GetColor(const void * p1, fGL_a4 & p2, prefs *p3)
{
	mm2_cdata * ref = (mm2_cdata *) p1;
	switch (ref->docv->chn_vector[ref->index[0]].res_vector[ref->index[1]].state)
	{
		case STATE_HELIX:
		p2[0] = 1.0; p2[1] = 0.0; p2[2] = 0.0;
		return;
		
		case STATE_STRAND:
		p2[0] = 0.0; p2[1] = 1.0; p2[2] = 0.0;
		return;
		
		default:	// STATE_LOOP
		p2[0] = 0.0; p2[1] = 0.0; p2[2] = 1.0;
		return;
	}
}

/*################################################################################################*/

void mm2_cm_residue::GetColor(const void * p1, fGL_a4 & p2, prefs *p3)
{
	mm2_cdata * ref = (mm2_cdata *) p1;
	
	i32s max = ref->docv->chn_vector[ref->index[0]].res_vector.size();
	fGL value = (fGL) ref->index[1] / (fGL) (max - 1);
	GetRBRange1(2.0 * value - 1.0, 1.0, p2);
}

// this is for displaying the penalties (from the "label" variable):
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//	mm2_cdata * ref = (mm2_cdata *) p1;
//	fGL value = ref->docv->chn_vector[ref->index[0]].res_vector[ref->index[1]].label[ref->index[2]] / 0.040;
//	GetRBRange1(value, 1.0, p2);

/*################################################################################################*/

void mm2_cm_sasa::GetColor(const void * p1, fGL_a4 & p2, prefs *p3)
{
	mm2_cdata * ref = (mm2_cdata *) p1;
	fGL value = ref->docv->chn_vector[ref->index[0]].res_vector[ref->index[1]].sasa[ref->index[2]] / 2.0;
	GetRBRange1(value, 1.0, p2);
}

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS

// eof
