// MM2RBN.H : ribbons for mm2-models.

// Copyright (C) 1998 Tommi Hassinen, Jarno Huuskonen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM2RBN_H
#define MM2RBN_H

#ifdef ENABLE_GRAPHICS

class mm2_ribbon;

/*################################################################################################*/

class spline;	 	// spline.h
class mm2_docv;		// mm2docv.h

#include "docview.h"
#include "objects.h"

/*################################################################################################*/

class mm2_ribbon : public smart_object
{
	protected:
	
	mm2_docv * docv;
	color_mode * cmode;
	
	i32s extra_points;
	i32s chn; i32s length;
	
	spline * ref;
	
	fGL_a3 head_refs[2];
	fGL_a3 * head_points;
	
	fGL_a3 tail_refs[2];
	fGL_a3 * tail_points;
	
	fGL * data1;		// places of the control points in spline
	fGL_a3 * data2;		// points calculated directly to the spline
	fGL_a3 * data3;		// extended begin- and end-points
	fGL_a3 * data4;		// directions for the y-axis
	fGL_a4 * data5;		// colors for the points
	
	iGLu list_id;
	
	static const i32s resol1;
	static const i32s resol2;
	
	static const fGL radius;
	
	public:
	
	mm2_ribbon(mm2_docv *, color_mode *, i32s, i32s);
	~mm2_ribbon(void);
	
	void MakeRibbon(void);
	void UpdateExtraPoints(void);
	
	const char * GetObjectName(void) { return "Ribbon"; }		// virtual

	void CameraEvent(const camera &) { }	// virtual
	
	bool BeginTransformation(void) { return false; }	// virtual
	bool EndTransformation(void) { return false; }		// virtual
	
	void Render(void);		// virtual
};

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS
#endif	// MM2RBN_H

// eof
