// T2VIEWS.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t2views.h"

#include "t2docv.h"
#include "utility.h"

#include <algorithm>
using namespace std;

/*################################################################################################*/

glut_view::glut_view(glut_docv * p1) : view()
{
	docv = p1;
}

glut_view::~glut_view(void)
{
}

docview * glut_view::GetDV(void)
{
	return docv;
}

/*################################################################################################*/

vector<glut_ogl_view *> glut_ogl_view::ogl_vector;

glut_ogl_view::glut_ogl_view(glut_docv * p1) : glut_view(p1), ogl_view()
{
	ogl_vector.push_back(this);
	
	glut_id = glutCreateWindow("");
	
	glutDisplayFunc(glut_ogl_view::DisplayHandler);
	glutKeyboardFunc(glut_ogl_view::KeyboardHandler);
	glutSpecialFunc(glut_ogl_view::SpecialHandler);
	
	glutReshapeFunc(glut_ogl_view::ReshapeHandler);
	
	glutMouseFunc(glut_ogl_view::MouseHandler);
	glutMotionFunc(glut_ogl_view::MotionHandler);
}

glut_ogl_view::~glut_ogl_view(void)
{
	vector<glut_ogl_view *>::iterator iter;
	iter = find(ogl_vector.begin(), ogl_vector.end(), this);
	
	if (iter != ogl_vector.end())
	{
		ogl_vector.erase(iter);
		glutDestroyWindow(glut_id);
	}
	else
	{
		cout << "WARNING : unknown glut_id at ~glut_ogl_view()!!!" << endl;
	}
}

void glut_ogl_view::Update(bool directly)
{
	if (directly) DisplayEvent();
	else
	{
		SetCurrent();
		glutPostRedisplay();
	}
}

void glut_ogl_view::SetTitle(const char * p1)
{
	SetCurrent();
	glutSetWindowTitle(p1);
}

void glut_ogl_view::SetCurrent(void)
{
	glutSetWindow(glut_id);
}

glut_ogl_view * glut_ogl_view::GetWindow(int id)
{
	vector<glut_ogl_view *>::iterator it1 = ogl_vector.begin();
	while (it1 != ogl_vector.end())
	{
		vector<glut_ogl_view *>::iterator it2 = it1++;
		if ((* it2)->glut_id == id) return (* it2);
	}
	
	// return NULL if the search failed...
	// return NULL if the search failed...
	// return NULL if the search failed...
	
	return NULL;
}

void glut_ogl_view::DisplayHandler(void)
{
	glut_ogl_view * window = GetWindow(glutGetWindow());
	if (!window) cout << "Unknown ID in DisplayHandler !!!" << endl;
	else window->DisplayEvent();
}

void glut_ogl_view::KeyboardHandler(unsigned char key, int x, int y)
{
	glut_ogl_view * window = GetWindow(glutGetWindow());
	if (!window) cout << "Unknown ID in KeyboardHandler !!!" << endl;
	else
	{
		// handle "remove window"-commands here to prevent "delete this"-situation!!!
		// handle "remove window"-commands here to prevent "delete this"-situation!!!
		// handle "remove window"-commands here to prevent "delete this"-situation!!!
		
		if (key == 'V')
		{
			graphics_view * gv = dynamic_cast<graphics_view *>(window);
			if (gv != NULL) gv->GetDV()->RemoveGraphicsView(gv);
		}
		else window->KeyboardEvent(key, x, y);
	}
}

void glut_ogl_view::SpecialHandler(int key, int x, int y)
{
	glut_ogl_view * window = GetWindow(glutGetWindow());
	if (!window) cout << "Unknown ID in SpecialHandler !!!" << endl;
	else window->SpecialEvent(key, x, y);
}

void glut_ogl_view::ReshapeHandler(int width, int height)
{
	glut_ogl_view * window = GetWindow(glutGetWindow());
	if (!window) cout << "Unknown ID in ReshapeHandler !!!" << endl;
	else window->SetSize(width, height);
}

void glut_ogl_view::MouseHandler(int ibtn, int istt, int x, int y)
{
	glut_ogl_view * window = GetWindow(glutGetWindow());
	if (!window) cout << "Unknown ID in MouseHandler !!!" << endl;
	else
	{
		if (istt == GLUT_DOWN)
		{
			if (button == mouse_tool::None)
			{
				switch (ibtn)
				{
					case GLUT_LEFT_BUTTON:
					button = mouse_tool::Left;
					break;
					
					case GLUT_RIGHT_BUTTON:
					button = mouse_tool::Right;
					break;
					
					default:
					button = mouse_tool::Middle;
				}
				
				int mod = glutGetModifiers();
				shift_down = (mod & GLUT_ACTIVE_SHIFT) ? true : false;
				ctrl_down = (mod & GLUT_ACTIVE_CTRL) ? true : false;
				
				state = mouse_tool::Down;
				
				current_tool->ButtonEvent((ogl_view *) window, x, y);
			}
		}
		else
		{
			if (button == mouse_tool::Left && ibtn != GLUT_LEFT_BUTTON) return;
			if (button == mouse_tool::Middle && ibtn != GLUT_MIDDLE_BUTTON) return;
			if (button == mouse_tool::Right && ibtn != GLUT_RIGHT_BUTTON) return;
			
			state = mouse_tool::Up;
			
			current_tool->ButtonEvent((ogl_view *) window, x, y);
			
			button = mouse_tool::None;
		}
	}
}

void glut_ogl_view::MotionHandler(int x, int y)
{
	glut_ogl_view * window = GetWindow(glutGetWindow());
	if (!window) cout << "Unknown ID in MotionHandler !!!" << endl;
	else current_tool->MotionEvent((ogl_view *) window, x, y);
}

/*################################################################################################*/

glut_graphics_view::glut_graphics_view(glut_docv * p1, camera * p2) :
	glut_ogl_view(p1), graphics_view(p2)
{
}

glut_graphics_view::~glut_graphics_view(void)
{
}

void glut_graphics_view::DisplayEvent(void)
{
	SetCurrent();
	Render(); glFlush();
	glutSwapBuffers();
}

void glut_graphics_view::KeyboardEvent(unsigned char key, int x, int y)
{
	char input;
	light * new_light;
	
	switch (key)
	{
		case 'h':
		cout << endl;
		cout << "modifier keys:" << endl;
		cout << "--------------" << endl;
		cout << "SHIFT     -> manipulate the selected object/atoms" << endl;
		cout << "CTRL      -> use object's own orientation (for translations only)" << endl;
		
		cout << endl;
		cout << "general keyboard commands:" << endl;
		cout << "--------------------------" << endl;
		cout << "F1-F10    -> change the current tool" << endl;
		cout << "F11 F12   -> select all / invert selection" << endl;
		cout << "HOME      -> switch the fog effect on/off" << endl;
		cout << "END       -> switch accumulation on/off" << endl;
		cout << "h         -> print out all available keyboard commands" << endl;
		cout << "P         -> switch orhographic/perspective projections" << endl;
		cout << "U         -> switch the quick update mode on/off" << endl;
		cout << "I         -> switch the info line on/off" << endl;
		cout << "c         -> create a new camera with a new view" << endl;
		cout << "v         -> create a new view using the current view camera" << endl;
		cout << "V         -> remove the current view" << endl;
		cout << "u         -> update the current view" << endl;
		cout << "A         -> add a new light" << endl;
		cout << "k K       -> switch local or global lights on/off" << endl;
		cout << "l L       -> select next local or global light" << endl;
		cout << "D         -> delete the currently selected object" << endl;
		
		cout << endl;
		cout << "model-dependent keyboard commands:" << endl;
		cout << "----------------------------------" << endl;
		docv->KeyEvent(this, key, x, y); cout << endl;
		break;
		
		case 'P' :
		cam->ortho = !cam->ortho; docv->UpdateGraphicsViews(cam);
		cout << "projection = " << (cam->ortho ? "orthographic" : "perspective") << endl;
		break;
		
		case 'U':
		quick_update = !quick_update;
		cout << "quick update = " << (quick_update ? "on" : "off") << endl;
		break;
		
		case 'I':
		draw_info = !draw_info;
		cout << "info line = " << (draw_info ? "on" : "off") << endl;
		docv->UpdateAllGraphicsViews();
		break;
		
		case 'c':
		docv->AddGraphicsView();
		break;
		
		case 'v':
		docv->AddGraphicsView(cam);
		break;
		
		// case 'V' is handled in glut_ogl_view::KeyboardHandler()!!!!!!!!!
		// case 'V' is handled in glut_ogl_view::KeyboardHandler()!!!!!!!!!
		// case 'V' is handled in glut_ogl_view::KeyboardHandler()!!!!!!!!!
		
		case 'u':
		cout << "update" << endl;
		docv->UpdateGraphicsView(this);
		break;
		
		case 'A':
		cout << "add light:" << endl;
		cout << "directional- or spotlight ? (d/s) "; cin >> input;
		
		if (input == 'd') new_light = new directional_light(ol_static());
		else if (input == 's')
		{
			new_light = new spot_light(ol_static());
			
			const fGL trans[3] = { 0.0, 0.0, -1.0 };
			new_light->TranslateObject((const fGL *) trans, cam->GetLocData());
		}
		else break;
		
		cout << "global or local light ? (g/l) "; cin >> input;
		
		if (input == 'g') docv->AddGlobalLight(new_light);
		else if (input == 'l') docv->AddLocalLight(new_light, cam);
		else delete new_light;
		
		if (input == 'g' || draw_info) docv->UpdateAllGraphicsViews();
		else if (input == 'l') docv->UpdateGraphicsViews(cam);
		break;
		
		case 'k':
		docv->DoSwitchLocalLights(cam, true);
		break;
		
		case 'K':
		docv->DoSwitchGlobalLights(cam, true);
		break;
		
		case 'l':
		if (docv->CountLocalLights(cam))
		{
			i32s tmp1 = (docv->IsLight(docv->selected_object) + 1) % docv->light_vector.size();
			while (docv->light_vector[tmp1]->owner != cam) tmp1 = (tmp1 + 1) % docv->light_vector.size();
			docv->SelectLight(docv->light_vector[tmp1]);
		}
		else cout << "no local lights to select" << endl;
		break;
		
		case 'L':
		if (docv->CountGlobalLights())
		{
			i32s tmp1 = (docv->IsLight(docv->selected_object) + 1) % docv->light_vector.size();
			while (docv->light_vector[tmp1]->owner != NULL) tmp1 = (tmp1 + 1) % docv->light_vector.size();
			docv->SelectLight(docv->light_vector[tmp1]);
		}
		else cout << "no global lights to select" << endl;
		break;
		
		case 'D':
		docv->DoDeleteCurrentObject();
		break;
		
		default:
		docv->KeyEvent(this, key, x, y);
		break;
	}
}

void glut_graphics_view::SpecialEvent(int key, int, int)
{
	switch (key)
	{
		case GLUT_KEY_F1: case GLUT_KEY_F2: case GLUT_KEY_F3: case GLUT_KEY_F4: case GLUT_KEY_F5:
		case GLUT_KEY_F6: case GLUT_KEY_F7: case GLUT_KEY_F8: case GLUT_KEY_F9: case GLUT_KEY_F10:
		if (ogl_view::button == mouse_tool::None) break;
		
		cout << "tool in use, cannot change at the moment..." << endl;
		return;
	}
	
	switch (key)
	{
		case GLUT_KEY_F1:
		current_tool = & ogl_view::tool_draw;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_F2:
		current_tool = & ogl_view::tool_erase;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_F3:
		current_tool = & ogl_view::tool_select;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_F4:
		current_tool = & ogl_view::tool_zoom;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_F5:
		current_tool = & ogl_view::tool_translate_xy;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_F6:
		current_tool = & ogl_view::tool_translate_z;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_F7:
		current_tool = & ogl_view::tool_orbit_xy;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_F8:
		current_tool = & ogl_view::tool_orbit_z;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_F9:
		current_tool = & ogl_view::tool_rotate_xy;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_F10:
		current_tool = & ogl_view::tool_rotate_z;
		cout << "tool = " << current_tool->GetToolName() << endl;
		if (draw_info) docv->UpdateAllGraphicsViews();
		break;
		
		case GLUT_KEY_HOME: enable_fog = !enable_fog; Update(false);
		cout << "fog effect = " << (enable_fog ? "TRUE" : "FALSE") << endl;
		break;
		
		case GLUT_KEY_END: accumulate = !accumulate; Update(false);
		cout << "accumulation = " << (accumulate ? "TRUE" : "FALSE") << endl;
//		if (accumulate) docv->UpdateAccumValues();	// ?????
		break;
		
		case GLUT_KEY_F11: cout << "select all" << endl;
		docv->SelectAll(); docv->UpdateAllGraphicsViews(false);
		break;
		
		case GLUT_KEY_F12: cout << "invert selection" << endl;
		docv->InvertSelection(); docv->UpdateAllGraphicsViews(false);
		break;
		
		default:
		cout << "glut_ogl_view::SpecialEvent(" << key << ")" << endl;
		break;
	}
}

/*################################################################################################*/

glut_plot1d_view::glut_plot1d_view(model_simple * p1, i32s p2, i32s p3) :
	glut_ogl_view(dynamic_cast<glut_docv *>(p1)), plot1d_view(p1, p2, p3)
{
}

glut_plot1d_view::~glut_plot1d_view(void)
{
}

void glut_plot1d_view::DisplayEvent(void)
{
cout << "display event" << endl;

	SetCurrent();
	Render(); glFlush();
	glutSwapBuffers();
}

void glut_plot1d_view::KeyboardEvent(unsigned char, int, int)
{
	cout << "glut_plot1d_view::KeyboardEvent() called." << endl;
}

void glut_plot1d_view::SpecialEvent(int, int, int)
{
	cout << "glut_plot1d_view::SpecialEvent() called." << endl;
}

glut_plot2d_view::glut_plot2d_view(model_simple * p1, i32s p2, i32s p3) :
	glut_ogl_view(dynamic_cast<glut_docv *>(p1)), plot2d_view(p1, p2, p3)
{
}

glut_plot2d_view::~glut_plot2d_view(void)
{
}

void glut_plot2d_view::DisplayEvent(void)
{
cout << "display event" << endl;

	SetCurrent();
	Render(); glFlush();
	glutSwapBuffers();
}

void glut_plot2d_view::KeyboardEvent(unsigned char, int, int)
{
	cout << "glut_plot2d_view::KeyboardEvent() called." << endl;
}

void glut_plot2d_view::SpecialEvent(int, int, int)
{
	cout << "glut_plot2d_view::SpecialEvent() called." << endl;
}

/*################################################################################################*/

glut_enlevdiag_view::glut_enlevdiag_view(qm1_mdl * p1) :
	glut_ogl_view(dynamic_cast<glut_docv *>(p1)), enlevdiag_view(p1)
{
}

glut_enlevdiag_view::~glut_enlevdiag_view(void)
{
}

void glut_enlevdiag_view::DisplayEvent(void)
{
	SetCurrent();
	Render(); glFlush();
	glutSwapBuffers();
}

void glut_enlevdiag_view::KeyboardEvent(unsigned char, int, int)
{
	cout << "glut_enlevdiag_view::KeyboardEvent() called." << endl;
}

void glut_enlevdiag_view::SpecialEvent(int, int, int)
{
	cout << "glut_enlevdiag_view::SpecialEvent() called." << endl;
}

/*################################################################################################*/

glut_class_factory * glut_class_factory::instance = NULL;
singleton_cleaner<glut_class_factory> glut_class_factory_cleaner(glut_class_factory::GetInstance());

glut_class_factory::glut_class_factory(void) : graphics_class_factory()
{
}

glut_class_factory::~glut_class_factory(void)
{
}

glut_class_factory * glut_class_factory::GetInstance(void)
{
	if (instance != NULL) return instance;
	else return (instance = new glut_class_factory());
}

err_util * glut_class_factory::ProduceErrUtil(void)
{
	return new console_err_util();
}

prefs * glut_class_factory::ProducePrefs(void)
{
        return new console_prefs();
}

graphics_view * glut_class_factory::ProduceGraphicsView(docview * docv1, camera * cam, bool)
{
	// the bool argument above is a "detached" flag, that matters only in the GNOME target.
	// if it's true, the view should be created in a separate window. here all views are
	// "detaced" in a sense, so we can ignore the flag here...
	
	glut_docv * docv2 = dynamic_cast<glut_docv *>(docv1);
	
	if (!docv2)
	{
		cout << "bad cast at glut_view_factory::ProduceGraphicsView()!!!" << endl;
		return NULL;
	}
	
	glut_graphics_view * gv = new glut_graphics_view(docv2, cam);
	gv->InitGL(); return gv;
}

plot1d_view * glut_class_factory::ProducePlot1DView(docview * docv, i32s ud1, i32s ud2)
{
	glut_plot1d_view * plotv = new glut_plot1d_view(docv, ud1, ud2);
	return plotv;
}

plot2d_view * glut_class_factory::ProducePlot2DView(docview * docv, i32s ud1, i32s ud2)
{
	glut_plot2d_view * plotv = new glut_plot2d_view(docv, ud1, ud2);
	return plotv;
}

enlevdiag_view * glut_class_factory::ProduceEnLevDiagView(qm1_mdl * mdl)
{
	glut_enlevdiag_view * eldv = new glut_enlevdiag_view(mdl);
	return eldv;
}

/*################################################################################################*/

// eof
