// T3MAIN.CPP

// Copyright (C) 1999 Tommi Hassinen, Ville Heikkil, Geoff Hutchison.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#define ENABLE_NLS	// supress the "gcc-3.2 and libintl.h" problem...
#include "t3main.h"

#include "t3errutil.h"
#include "t3dialog.h"
#include "notice.h"

//#include <popt.h>			// For parsing command-line; OLD
//#include <libgnome/gnome-popt.h>	// For parsing command-line; OLD
#include <popt-gnome.h>			// For parsing command-line.

#include <glade/glade.h>

#include <strstream>
using namespace std;

/*################################################################################################*/

i32s gnome_app_data::current_tool_index = 6;	// 6 is the index for orbit_xy tool (default)...

/*################################################################################################*/

GnomeUIInfo gnome_mdi_app::file_new_submenu[] =
{
	GNOMEUIINFO_MENU_NEW_ITEM("Quantum Mechanics (.gpr)", NULL,
		gnome_mdi_app::menu_FileNewQM1, NULL),
	
	GNOMEUIINFO_MENU_NEW_ITEM("Molecular Mechanics (.gpr)", NULL,
		gnome_mdi_app::menu_FileNewMM1, NULL),

	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_MENU_NEW_ITEM("Simplified Protein Model (.mm2gp)", NULL,
		gnome_mdi_app::menu_FileNewMM2, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mdi_app::file_open_submenu[] =
{
	GNOMEUIINFO_MENU_NEW_ITEM("Quantum Mechanics (.gpr)", NULL,
		gnome_mdi_app::menu_FileOpenQM1, NULL),
	
	GNOMEUIINFO_MENU_NEW_ITEM("Molecular Mechanics (.gpr)", NULL,
		gnome_mdi_app::menu_FileOpenMM1, NULL),

	GNOMEUIINFO_SEPARATOR,
		
	GNOMEUIINFO_MENU_NEW_ITEM("Simplified Protein Model (.mm2gp)", NULL,
		gnome_mdi_app::menu_FileOpenMM2, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mdi_app::file_submenu[] =
{
	GNOMEUIINFO_SUBTREE("_New Project...", file_new_submenu),
	GNOMEUIINFO_SUBTREE("_Open Project...", file_open_submenu),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_EXIT_ITEM(gnome_mdi_app::menu_FileExit, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mdi_app::win_mdimode_submenu[] =
{
	GNOMEUIINFO_ITEM("Notebook", NULL,
		gnome_mdi_app::menu_MDINotebook, NULL),
		
	GNOMEUIINFO_ITEM("Toplevel", NULL,
		gnome_mdi_app::menu_MDIToplevel, NULL),
		
	GNOMEUIINFO_ITEM("Modal", NULL,
		gnome_mdi_app::menu_MDIModal, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mdi_app::windows_submenu[] =
{
	GNOMEUIINFO_SUBTREE("_MDI Mode...", win_mdimode_submenu),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mdi_app::help_submenu[] =
{
	GNOMEUIINFO_ITEM("Help", NULL,
		gnome_mdi_app::menu_HelpHelp, NULL),
		
	GNOMEUIINFO_MENU_ABOUT_ITEM(gnome_mdi_app::menu_HelpAbout, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mdi_app::menubar_info[] =
{
	GNOMEUIINFO_SUBTREE("_File", file_submenu),
	GNOMEUIINFO_SUBTREE("_Windows", windows_submenu),
	GNOMEUIINFO_SUBTREE("_Help", help_submenu),
	GNOMEUIINFO_END
};

/*################################################################################################*/

#include "pixmaps/draw.xpm"
#include "pixmaps/erase.xpm"
#include "pixmaps/select.xpm"
#include "pixmaps/zoom.xpm"
#include "pixmaps/trans_xy.xpm"
#include "pixmaps/trans_z.xpm"
#include "pixmaps/orb_xy.xpm"
#include "pixmaps/orb_z.xpm"
#include "pixmaps/rot_xy.xpm"
#include "pixmaps/rot_z.xpm"
#include "pixmaps/distance.xpm"

GnomeUIInfo gnome_mdi_app::mousetools_toolbar_info[] =
{
	GNOMEUIINFO_TOGGLEITEM("Draw",
		"Add atoms and bonds to the model.",
		gnome_mdi_app::toolbar_Draw, draw_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Erase",
		"Remove atoms and bonds from the model.",
		gnome_mdi_app::toolbar_Erase, erase_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Select",
		"Make selections in the model, and also to select objects.",
		gnome_mdi_app::toolbar_Select, select_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Zoom",
		"Zoom the view.",
		gnome_mdi_app::toolbar_Zoom, zoom_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Translate XY",
		"Translate the camera or a selected object in XY-direction.",
		gnome_mdi_app::toolbar_TranslateXY, trans_xy_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Translate Z",
		"Translate the camera or a selected object in Z-direction.",
		gnome_mdi_app::toolbar_TranslateZ, trans_z_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Orbit XY",
		"Orbit the camera or a selected object around the focus point in XY-direction.",
		gnome_mdi_app::toolbar_OrbitXY, orb_xy_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Orbit Z",
		"Orbit the camera or a selected object around the focus point in Z-direction.",
		gnome_mdi_app::toolbar_OrbitZ, orb_z_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Rotate XY",
		"Turn the camera in XY-direction.",
		gnome_mdi_app::toolbar_RotateXY, rot_xy_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Rotate Z",
		"Turn the camera in Z-direction.",
		gnome_mdi_app::toolbar_RotateZ, rot_z_xpm),
		
	GNOMEUIINFO_TOGGLEITEM("Measure",
		"Measure the distances, angles and torsions.",
		gnome_mdi_app::toolbar_Measure, distance_xpm),
		
	GNOMEUIINFO_END
};

#include "pixmaps/element.xpm"
#include "pixmaps/bond.xpm"

//#include "pixmaps/select.xpm"
#include "pixmaps/invert.xpm"

//#include "pixmaps/select.xpm"
#include "pixmaps/residue.xpm"
#include "pixmaps/chain.xpm"
#include "pixmaps/molecule.xpm"

//#include "pixmaps/distance.xpm"
#include "pixmaps/angle.xpm"
#include "pixmaps/dihedral.xpm"

GnomeUIInfo gnome_mdi_app::shortcuts_toolbar_info[] =
{
	GNOMEUIINFO_ITEM("el",
		"Set the current element",
		shortcut_Element, element_xpm),
		
	GNOMEUIINFO_ITEM("bt",
		"Set the current bondtype",
		shortcut_BondType, bond_xpm),
		
	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_ITEM("sa",
		"Select All",
		shortcut_SelectAll, select_xpm),
		
	GNOMEUIINFO_ITEM("is",
		"Invert selection",
		shortcut_InvertSelection, invert_xpm),

	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_TOGGLEITEM("Atoms",
		"Select atoms",
		NULL, select_xpm),

	GNOMEUIINFO_TOGGLEITEM("Residue",
		"Select residues",
		NULL, residue_xpm),

	GNOMEUIINFO_TOGGLEITEM("Chain",
		"Select chains",
		NULL, chain_xpm),

	GNOMEUIINFO_TOGGLEITEM("Molecule",
		"Select molecules",
		NULL, molecule_xpm),

	GNOMEUIINFO_SEPARATOR,
		
	GNOMEUIINFO_TOGGLEITEM("Distance",
		"The distance measuring mode.",
		NULL, distance_xpm),

	GNOMEUIINFO_TOGGLEITEM("Angle",
		"The angle measuring mode.",
		NULL, angle_xpm),

	GNOMEUIINFO_TOGGLEITEM("Dihedral",
		"The torsion measuring mode.",
		NULL, dihedral_xpm),
		
	GNOMEUIINFO_END
};

/*################################################################################################*/

GnomeMDI * gnome_mdi_app::mdi = NULL;
vector<gnome_app_data> gnome_mdi_app::app_vector;
bool gnome_mdi_app::block_toolbar = false;

gnome_mdi_app * gnome_mdi_app::instance = NULL;

gnome_mdi_app::gnome_mdi_app(void)
{
	char title[256]; ostrstream str(title, sizeof(title));
	str << get_copyright_notice_line(0) << " - version " << VERSION << ends;
	
	mdi = GNOME_MDI(gnome_mdi_new("ghemical", title));
	
	// setup handlers...
	
	gtk_signal_connect(GTK_OBJECT(mdi), "app_created", GTK_SIGNAL_FUNC(AppCreateHandler), NULL);
	
	gtk_signal_connect(GTK_OBJECT(mdi), "child_changed", GTK_SIGNAL_FUNC(ChildChangeHandler), NULL);
	gtk_signal_connect(GTK_OBJECT(mdi), "remove_child", GTK_SIGNAL_FUNC(RemoveChildHandler), NULL);
	
	gtk_signal_connect(GTK_OBJECT(mdi), "destroy", GTK_SIGNAL_FUNC(DestroyHandler), NULL);
	
	// setup mdi-menubar...
	
	gnome_mdi_set_menubar_template(mdi, menubar_info);
//	gnome_mdi_set_child_menu_path(mdi, GNOME_MENU_FILE_STRING);
//	gnome_mdi_set_child_list_path(mdi, GNOME_MENU_WINDOWS_PATH);
	gnome_mdi_set_child_menu_path(mdi, "_File");
	gnome_mdi_set_child_list_path(mdi, "_Windows/");
	
	// ready...
	
	gnome_mdi_open_toplevel(mdi);
}

gnome_mdi_app::~gnome_mdi_app(void)
{
}

gnome_mdi_app * gnome_mdi_app::GetInstance(void)
{
	if (instance != NULL) return instance;
	else return (instance = new gnome_mdi_app());
}

void gnome_mdi_app::HelpHelp(void)
{
	static GnomeHelpMenuEntry ref = { "ghemical", "index.html" };
	gnome_help_display(NULL, & ref);
}

void gnome_mdi_app::HelpAbout(void)
{
	GtkWidget * aboutdialog;
	
	static char title[128];
	strcpy(title, get_copyright_notice_line(0));
	
	static char copyright[128];
	strcpy(copyright, get_copyright_notice_line(5));
	
	static char intro[2048];
	ostrstream intro_str(intro, sizeof(intro));
	intro_str << "Ghemical is a molecular modelling package released under the GNU GPL." << endl;
	for (i32s n1 = 3;n1 < COPYRIGHT_NOTICE_LINES;n1++) intro_str << get_copyright_notice_line(n1) << endl;
	intro_str << ends;
	
	const gchar * authors[] =
	{
		"Tommi Hassinen",
		"Geoff Hutchison",
		"Mike Cruz",
		"Michael Banck",
		"Christopher Rowley",
		NULL
	};
	
	aboutdialog = gnome_about_new(title, VERSION, copyright, authors, intro, NULL);
	gnome_dialog_run_and_close(GNOME_DIALOG(aboutdialog));
}

void gnome_mdi_app::menu_DummyEvent(GtkWidget *, gpointer)
{
	cout << "gnome_mdi_app::menu_DummyEvent() called!!!" << endl;
}

void gnome_mdi_app::menu_FileNewQM1(GtkWidget *, gpointer)
{
	gnome_docv * docv;
	docv = new gnome_qm1_docv(& cout, * gnome_class_factory::GetInstance());
	docv->InitGnomeMDIChild();
}

void gnome_mdi_app::menu_FileNewMM1(GtkWidget *, gpointer)
{
	gnome_docv * docv;
	docv = new gnome_mm1_docv(& cout, * gnome_class_factory::GetInstance());
	docv->InitGnomeMDIChild();
}

void gnome_mdi_app::menu_FileNewMM2(GtkWidget *, gpointer)
{
	gnome_docv * docv;
	docv = new gnome_mm2_docv(& cout, * gnome_class_factory::GetInstance(), NULL);
	docv->InitGnomeMDIChild();
}

void gnome_mdi_app::menu_FileOpenQM1(GtkWidget *, gpointer)
{
	new qm1_file_open_dialog(NULL);
}

void gnome_mdi_app::menu_FileOpenMM1(GtkWidget *, gpointer)
{
	new mm1_file_open_dialog(NULL);
}

void gnome_mdi_app::menu_FileOpenMM2(GtkWidget *, gpointer)
{
	new mm2_file_open_dialog(NULL);
}
	
void gnome_mdi_app::menu_FileExit(GtkWidget *, gpointer)
{
	if (gnome_mdi_remove_all(mdi, false)) gtk_object_destroy(GTK_OBJECT(mdi));
}

void gnome_mdi_app::menu_MDINotebook(GtkWidget *, gpointer)
{
	gnome_mdi_set_mode(mdi, GNOME_MDI_NOTEBOOK);
}

void gnome_mdi_app::menu_MDIToplevel(GtkWidget *, gpointer)
{
	gnome_mdi_set_mode(mdi, GNOME_MDI_TOPLEVEL);
}

void gnome_mdi_app::menu_MDIModal(GtkWidget *, gpointer)
{
	gnome_mdi_set_mode(mdi, GNOME_MDI_MODAL);
}

void gnome_mdi_app::menu_HelpHelp(GtkWidget *, gpointer)
{
	GetInstance()->HelpHelp();
}

void gnome_mdi_app::menu_HelpAbout(GtkWidget *, gpointer)
{
	GetInstance()->HelpAbout();
}

void gnome_mdi_app::toolbar_Draw(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(0);
}

void gnome_mdi_app::toolbar_Erase(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(1);
}

void gnome_mdi_app::toolbar_Select(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(2);
}

void gnome_mdi_app::toolbar_Zoom(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(3);
}

void gnome_mdi_app::toolbar_TranslateXY(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(4);
}

void gnome_mdi_app::toolbar_TranslateZ(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(5);
}

void gnome_mdi_app::toolbar_OrbitXY(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(6);
}

void gnome_mdi_app::toolbar_OrbitZ(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(7);
}

void gnome_mdi_app::toolbar_RotateXY(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(8);
}

void gnome_mdi_app::toolbar_RotateZ(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(9);
}

void gnome_mdi_app::toolbar_Measure(GtkWidget *, gpointer)
{
	if (!block_toolbar) ToolButtonHandler(10);
}

void gnome_mdi_app::ToolButtonHandler(i32s tool_index)
{
	block_toolbar = true;
	
	for (i32u n1 = 0;n1 < app_vector.size();n1++)
	{
		GtkWidget * widget = app_vector[n1].tool_widget[gnome_app_data::current_tool_index];
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
	}
	
	gnome_app_data::current_tool_index = tool_index;
	
	for (i32u n1 = 0;n1 < app_vector.size();n1++)
	{
		GtkWidget * widget = app_vector[n1].tool_widget[gnome_app_data::current_tool_index];
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
	}
	
	block_toolbar = false;
	
	switch (tool_index)
	{
		case 0:
		ogl_view::current_tool = & ogl_view::tool_draw;
		break;
		
		case 1:
		ogl_view::current_tool = & ogl_view::tool_erase;
		break;
		
		case 2:
		ogl_view::current_tool = & ogl_view::tool_select;
		break;
		
		case 3:
		ogl_view::current_tool = & ogl_view::tool_zoom;
		break;
		
		case 4:
		ogl_view::current_tool = & ogl_view::tool_translate_xy;
		break;
		
		case 5:
		ogl_view::current_tool = & ogl_view::tool_translate_z;
		break;
		
		case 6:
		ogl_view::current_tool = & ogl_view::tool_orbit_xy;
		break;
		
		case 7:
		ogl_view::current_tool = & ogl_view::tool_orbit_z;
		break;
		
		case 8:
		ogl_view::current_tool = & ogl_view::tool_rotate_xy;
		break;
		
		case 9:
		ogl_view::current_tool = & ogl_view::tool_rotate_z;
		break;

	        case 10:
		ogl_view::current_tool = & ogl_view::tool_measure;
		break;
		
		default:
		cout << "FATAL ERROR : unknown tool at gnome_mdi_app::ToolButtonHandler()!" << endl;
		exit(EXIT_FAILURE);
	}
}

void gnome_mdi_app::shortcut_Element(GtkWidget *, gpointer)
{
	new element_dialog();		// will call delete itself...
}

void gnome_mdi_app::shortcut_BondType(GtkWidget *, gpointer)
{
	new bondtype_dialog();		// will call delete itself...
}

// this same operation is done separately for the popup menu!!!
// take a look at gnome_graphics_view::popup_SelectAll().

void gnome_mdi_app::shortcut_SelectAll(GtkWidget *, gpointer)
{
	GtkObject * active = GTK_OBJECT(mdi->active_child);
	if (active != NULL)
	{
		docview * docv = (docview *) gtk_object_get_user_data(active);
		docv->SelectAll();
	}
	else
	{
		err_util * err = gnome_class_factory::GetInstance()->ProduceErrUtil();
		err->WarningMessage("Operation failed - no active project!");
	}
}

// this same operation is done separately for the popup menu!!!
// take a look at gnome_graphics_view::popup_InvertSelection().

void gnome_mdi_app::shortcut_InvertSelection(GtkWidget *, gpointer)
{
	GtkObject * active = GTK_OBJECT(mdi->active_child);
	if (active != NULL)
	{
		docview * docv = (docview *) gtk_object_get_user_data(active);
		docv->InvertSelection();
	}
	else
	{
		err_util * err = gnome_class_factory::GetInstance()->ProduceErrUtil();
		err->WarningMessage("Operation failed - no active project!");
	}
}

void gnome_mdi_app::AppCreateHandler(GnomeMDI *, GnomeApp * app, gpointer)
{
	gnome_app_data app_data;
	app_data.app = app;		// save the GnomeApp pointer...
	
	// we have to grab the "destroy"-signals for GnomeApp, so that we know when
	// the GnomeApp objects are destroyed...
	
	gtk_signal_connect(GTK_OBJECT(app), "destroy", GTK_SIGNAL_FUNC(AppDestroyHandler), NULL);
	
	// create a custom toolbar. we will save the widget pointers, so that we can
	// manipulate the button states later...
	
// THIS IS THE OLD VERSION, CAN'T HAVE MANY TOOLBARS THIS WAY...
//gnome_app_create_toolbar(GNOME_APP(app), toolbar_info);

	GtkWidget * toolbar;
	
// GTK_ORIENTATION_HORIZONTAL, GTK_ORIENTATION_VERTICAL
// GTK_TOOLBAR_ICONS, GTK_TOOLBAR_TEXT, GTK_TOOLBAR_BOTH
	toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
	
	gnome_app_fill_toolbar(GTK_TOOLBAR(toolbar), shortcuts_toolbar_info, NULL);
	gnome_app_add_toolbar(GNOME_APP(app), GTK_TOOLBAR(toolbar), "shortcuts", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_TOP, 2, 0, 0);
	
// GTK_ORIENTATION_HORIZONTAL, GTK_ORIENTATION_VERTICAL
// GTK_TOOLBAR_ICONS, GTK_TOOLBAR_TEXT, GTK_TOOLBAR_BOTH
	toolbar = gtk_toolbar_new(GTK_ORIENTATION_VERTICAL, GTK_TOOLBAR_BOTH);
	
	gnome_app_fill_toolbar(GTK_TOOLBAR(toolbar), mousetools_toolbar_info, NULL);
	gnome_app_add_toolbar(GNOME_APP(app), GTK_TOOLBAR(toolbar), "mousetools", GNOME_DOCK_ITEM_BEH_NORMAL, GNOME_DOCK_LEFT, 3, 0, 0);
	
	app_data.tool_widget[0] = mousetools_toolbar_info[0].widget;
	app_data.tool_widget[1] = mousetools_toolbar_info[1].widget;
	app_data.tool_widget[2] = mousetools_toolbar_info[2].widget;
	app_data.tool_widget[3] = mousetools_toolbar_info[3].widget;
	app_data.tool_widget[4] = mousetools_toolbar_info[4].widget;
	app_data.tool_widget[5] = mousetools_toolbar_info[5].widget;
	app_data.tool_widget[6] = mousetools_toolbar_info[6].widget;
	app_data.tool_widget[7] = mousetools_toolbar_info[7].widget;
	app_data.tool_widget[8] = mousetools_toolbar_info[8].widget;
	app_data.tool_widget[9] = mousetools_toolbar_info[9].widget;
	app_data.tool_widget[10] = mousetools_toolbar_info[10].widget;
	
	// set the currently selected tool active...
	
	GtkWidget * active = app_data.tool_widget[gnome_app_data::current_tool_index];
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(active), TRUE);
	
	// create the statusbar...
	
	app_data.statusbar = gtk_statusbar_new();
	app_data.context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(app_data.statusbar), "main");
	gnome_app_set_statusbar(app, app_data.statusbar);
	
	// and finally save the data...
	app_vector.push_back(app_data);
}

void gnome_mdi_app::AppDestroyHandler(GtkWidget * widget, gpointer)
{
	i32u index = 0;
	while (index < app_vector.size())
	{
		if (GTK_WIDGET(app_vector[index].app) != widget) index++;
		else break;
	}
	
	if (index == app_vector.size())
	{
		cout << "problems at gnome_mdi_app::AppDestroyHandler()!!!" << endl;
		exit(EXIT_FAILURE);
	}
	
	app_vector.erase(app_vector.begin() + index);
}

void gnome_mdi_app::ChildChangeHandler(GnomeMDI *, GnomeMDIChild *, gpointer)
{
	docview * docv = (docview *) gtk_object_get_user_data(GTK_OBJECT(mdi->active_child));
	
	// we use this function just for setting the correct texts to the statusbar...
	// we use this function just for setting the correct texts to the statusbar...
	// we use this function just for setting the correct texts to the statusbar...
	
	docv->event_SelectedObjectChanged();
}

gboolean gnome_mdi_app::RemoveChildHandler(GnomeMDI *, GnomeMDIChild * child, gpointer)
{
	char question[256];
	ostrstream qstr(question, sizeof(question));
	
	qstr << "Are you sure you wish to close" << endl;
	qstr << child->name << " ?" << ends;
	
	GtkWidget * msgbox;
	msgbox = gnome_message_box_new(question,
		GNOME_MESSAGE_BOX_QUESTION, GNOME_STOCK_BUTTON_YES,
		GNOME_STOCK_BUTTON_NO, NULL);
		
	return (gnome_dialog_run_and_close(GNOME_DIALOG(msgbox)) == 0);
}

void gnome_mdi_app::DestroyChildHandler(GtkObject * obj, gpointer)
{
	// here we try to delete the model and release memory,
	// but it seems to fail more or less... still wrong order!??!?!
	
	docview * docv = (docview *) gtk_object_get_user_data(obj);
	gtk_object_set_user_data(obj, NULL); delete docv;
}

void gnome_mdi_app::DestroyHandler(GtkObject *, gpointer)
{
	gtk_main_quit();
}

/*################################################################################################*/

singleton_cleaner<gnome_mdi_app> app_cleaner;
char *filename = NULL;
char *importname = NULL;

int main(int argc, char ** argv)
{
        //char **args;
        poptContext options_context;
        const struct poptOption options_table[] = {
	  {"file",'f', POPT_ARG_STRING, &filename, 0, "open file", "filename"},
	  {"import",'i', POPT_ARG_STRING, &importname, 0, "import file as gpr", "filename"},
	  {NULL,'\0', 0, NULL, 0, NULL, NULL}
	};
	options_context = poptGetContext(NULL, argc, argv, options_table, 0);
	gnome_init_with_popt_table("ghemical", VERSION, argc, argv, options_table, 0, &options_context);

	glade_gnome_init();

	app_cleaner.SetInstance(gnome_mdi_app::GetInstance());

	if (filename != NULL && strlen(filename) != 0)
	  {
	    gnome_docv * docv;
	    docv = new gnome_mm1_docv(& cout, * gnome_class_factory::GetInstance());
	    ifstream ifile;
	    ifile.open(filename, ios::in);
	    if (docv->ReadStream(ifile, false) != false)
	      {
		docv->InitGnomeMDIChild();
		docv->ParseProjectFileNameAndPath(filename);
		docv->UpdateAllWindowTitles();
	      }
	    ifile.close();
	  }

	if (importname != NULL && strlen(importname) != 0)
	  {
	    gnome_docv * docv;
	    docv = new gnome_mm1_docv(& cout, * gnome_class_factory::GetInstance());
	    if (docv->ImportFile(importname, 0) != false)
	      {
		docv->InitGnomeMDIChild();
		docv->ParseProjectFileNameAndPath(importname);
		docv->UpdateAllWindowTitles();
	      }
	  }
	
	while ((importname = poptGetArg(options_context)) != NULL)
	  {
	    gnome_docv * docv;
	    docv = new gnome_mm1_docv(& cout, * gnome_class_factory::GetInstance());
	    if (docv->ImportFile(importname, 0) != false)
	      {
		docv->InitGnomeMDIChild();
		docv->ParseProjectFileNameAndPath(importname);
		docv->UpdateAllWindowTitles();
	      }
	  }
	
	poptFreeContext(options_context);

	gtk_main(); gtk_exit(0);
}

/*################################################################################################*/

// eof
