/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_SEARCH_CB_H__
#define __UI_SEARCH_CB_H__

#include "event.h"
#include "ui_search.h"

typedef enum
{
	/* Displayed */
	SEARCH_FILENAME = 0,
	SEARCH_AVAILABILITY,
	SEARCH_SOURCES,
	SEARCH_SIZE,
	
	/* Hided */
       	SEARCH_HASH,
	SEARCH_URL,
	SEARCH_FILESIZE,
	
	SEARCH_ICON,
	SEARCH_ISDOWNLOAD,
	SEARCH_ID,
	SEARCH_PIXBUF,
	
	SEARCH_NUMBER
} GiftuiSearchColumn_t;

typedef enum
{
	SEARCH_ALL = 0,
	SEARCH_AUDIO,
	SEARCH_VIDEO,
	SEARCH_PICTURE,
	SEARCH_TEXT,
	SEARCH_DOCUMENT,
	SEARCH_SOFTWARE
} GiftuiSearchType_t;

void giftui_search_add_result (GiftuiSearch *se, GiftuiEvent_t *in);
void giftui_search_update_networks (GiftuiSearch *se);

#endif
