/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_DEVICE_H__
#define __GNOME_CMD_DEVICE_H__

#include "gnome-cmd-pixmap.h"

typedef struct _GnomeCmdDevice GnomeCmdDevice;
typedef struct _GnomeCmdDevicePrivate GnomeCmdDevicePrivate;

struct _GnomeCmdDevice {
	GnomeCmdDevicePrivate *priv;
};


GnomeCmdDevice*
gnome_cmd_device_new                 (void);

GnomeCmdDevice*
gnome_cmd_device_new_with_values     (const gchar *alias,
									  const gchar *device_fn, 
									  const gchar *mountp,
									  const gchar *icon_path);

void
gnome_cmd_device_free                (GnomeCmdDevice *dev);

void
gnome_cmd_device_set_alias           (GnomeCmdDevice *dev,
									  const gchar *alias);

void
gnome_cmd_device_set_device_fn       (GnomeCmdDevice *dev,
									  const gchar *device_fn);

void
gnome_cmd_device_set_mountp          (GnomeCmdDevice *dev,
									  const gchar *mountp);

void
gnome_cmd_device_set_icon_path       (GnomeCmdDevice *dev,
									  const gchar *icon_path);

const gchar*
gnome_cmd_device_get_alias           (GnomeCmdDevice *dev); 

const gchar*
gnome_cmd_device_get_device_fn       (GnomeCmdDevice *dev);

const gchar*
gnome_cmd_device_get_mountp          (GnomeCmdDevice *dev);

const gchar*
gnome_cmd_device_get_icon_path       (GnomeCmdDevice *dev);

GnomeCmdPixmap *
gnome_cmd_device_get_pixmap          (GnomeCmdDevice *dev);

GnomeCmdPixmap *
gnome_cmd_device_get_umount_pixmap   (GnomeCmdDevice *dev);


#endif //__GNOME_CMD_DEVICE_H__
