/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_FILE_TYPES_H__
#define __GNOME_CMD_FILE_TYPES_H__

BEGIN_GNOME_DECLS

#define GNOME_CMD_FILE(obj) \
	GTK_CHECK_CAST (obj, gnome_cmd_file_get_type (), GnomeCmdFile)
#define GNOME_CMD_FILE_CLASS(klass) \
	GTK_CHECK_CLASS_CAST (klass, gnome_cmd_file_get_type (), GnomeCmdFileClass)
#define GNOME_CMD_IS_FILE(obj) \
    GTK_CHECK_TYPE (obj, gnome_cmd_file_get_type ())


typedef struct _GnomeCmdFile GnomeCmdFile;
typedef struct _GnomeCmdFileClass GnomeCmdFileClass;

#include "gnome-cmd-dir-types.h"

struct _GnomeCmdFile
{
	GtkObject parent;
	
	GnomeVFSFileInfo *info;
	GnomeCmdDir *dir;
	GnomeVFSURI *uri;
	gchar *uri_str;
	gchar *path;
	gint ref_cnt;
	GList *observers;
};

struct _GnomeCmdFileClass
{
	GtkObjectClass parent_class;
};


#endif //__GNOME_CMD_FILE_TYPES_H__
