/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include "gnome-cmd-includes.h"
#include "gnome-cmd-style.h"
#include "gnome-cmd-data.h"
#include "gnome-cmd-types.h"

GtkRcStyle *main_rc_style = NULL;
GtkStyle *list_style = NULL;
GtkStyle *sel_list_style = NULL;


static GtkRcStyle *
create_main_rc_style ()
{
	GtkRcStyle *style;

	style = gtk_rc_style_new ();
	style->font_name = g_strdup (gnome_cmd_data_get_misc_font ());
	
	return style;
}


static GtkStyle *
create_list_style ()
{
	GtkStyle *style;
	GdkFont *font = NULL;
	GnomeCmdLayoutColors *cols = gnome_cmd_data_get_layout_colors ();
	const gchar *font_name = gnome_cmd_data_get_list_font ();

	if (strcmp (font_name, "default") != 0) {
		font = gdk_font_load (font_name);		
	}

	style = gtk_style_new ();

	if (font) {
		gdk_font_unref (style->font);
		gdk_font_ref (font);
		style->font = font;
	}

	style->fg[GTK_STATE_SELECTED] = *cols->curs_fg;
	style->fg[GTK_STATE_NORMAL] = *cols->norm_fg;

	style->bg[GTK_STATE_SELECTED] = *cols->curs_bg;
	style->base[GTK_STATE_NORMAL] = *cols->norm_bg;
	style->base[GTK_STATE_ACTIVE] = *cols->norm_bg;
	
	return style;
}


static GtkStyle *
create_sel_list_style ()
{
	GtkStyle *style;
	GdkFont *font = NULL;
	GnomeCmdLayoutColors *cols = gnome_cmd_data_get_layout_colors ();
	const gchar *font_name = gnome_cmd_data_get_list_font ();

	if (strcmp (font_name, "default") != 0) {
		font = gdk_font_load (font_name);		
	}

	style = gtk_style_new ();

	if (font) {
		gdk_font_unref (style->font);
		gdk_font_ref (font);
		style->font = font;
	}

	style->fg[GTK_STATE_SELECTED] = *cols->sel_fg;
	style->fg[GTK_STATE_NORMAL] = *cols->sel_fg;

	style->bg[GTK_STATE_SELECTED] = *cols->curs_bg;
	style->bg[GTK_STATE_NORMAL] = *cols->sel_bg;
	style->base[GTK_STATE_NORMAL] = *cols->norm_bg;
	style->base[GTK_STATE_ACTIVE] = *cols->norm_bg;
	
	return style;
}


void gnome_cmd_style_create (void)
{
	if (main_rc_style) gtk_rc_style_unref (main_rc_style);
	if (list_style) gtk_style_unref (list_style);
	if (sel_list_style) gtk_style_unref (sel_list_style);
	
	main_rc_style = create_main_rc_style ();	
	list_style = create_list_style ();
	sel_list_style = create_sel_list_style ();
}


