/* GNOME-DB Front End
 * Copyrigth (C) 2000 Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

/*
 * Public functions
 */

void
fe_wizard_new_database (void)
{
	GtkWidget *dialog;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *use_new_db;
	GtkWidget *use_new_name;
	GtkWidget *use_new_description;
	GtkWidget *use_new_directory;
	GtkWidget *use_existing_db;

	/* create the dialog */
	dialog = gnome_dialog_new(_("New database"),
				  GNOME_STOCK_BUTTON_OK,
				  GNOME_STOCK_BUTTON_CANCEL,
				  NULL);
	gnome_dialog_set_default(GNOME_DIALOG(dialog), 0);

	frame = gnome_db_new_frame_widget(NULL);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), frame, 1, 1, 0);
	table = gnome_db_new_table_widget(8, 10, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);

	use_new_db = gnome_db_new_radio_button_widget(_("Create a new data source for this database"),
						      NULL);
	gtk_table_attach(GTK_TABLE(table), use_new_db, 0, 4, 0, 1, GTK_FILL, GTK_FILL, 3, 3);

	label = gnome_db_new_label_widget(_("Name"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 3, 3);
	use_new_name = gnome_db_new_entry_widget(0, TRUE);
	gtk_table_attach(GTK_TABLE(table), use_new_name, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 3, 3);

	label = gnome_db_new_label_widget(_("Description"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 3, 3);
	use_new_description = gnome_db_new_entry_widget(0, TRUE);
	gtk_table_attach(GTK_TABLE(table), use_new_description, 2, 3, 2, 3, GTK_FILL, GTK_FILL, 3, 3);

	label = gnome_db_new_label_widget(_("Directory"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label, 1, 2, 3, 4, GTK_FILL, GTK_FILL, 3, 3);
	use_new_directory = gnome_db_new_file_entry_widget("GNOME_DB_NewDatabase");
	gtk_table_attach(GTK_TABLE(table), use_new_directory, 2, 4, 3, 4, GTK_FILL, GTK_FILL, 3, 3);

 run_dialog:
	/* run the dialog */
	if (!gnome_dialog_run(GNOME_DIALOG(dialog))) {
		GdaDsn *dsn = NULL;

		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(use_new_db))) {
			gchar *name;
			gchar *description;
			gchar *directory;
			gchar *dsn_str;

			/* retrieve data from dialog */
			name = gtk_entry_get_text(GTK_ENTRY(use_new_name));
			description = gtk_entry_get_text(GTK_ENTRY(use_new_description));
			directory = gtk_entry_get_text(
				GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(use_new_directory))));

			if (!name || strlen(name) <= 0) {
				gnome_db_show_error(_("You must specify a name for the data source"));
				goto run_dialog;
			}
			if (!directory || strlen(directory) <= 0) {
				gnome_db_show_error(_("You must specify a directory for the new database"));
				goto run_dialog;
			}

			/* add the new data source */
			dsn = gda_dsn_new();
			gda_dsn_set_provider(dsn, "OAFIID:GNOME_GDA_Provider_Default_ConnectionFactory");
			gda_dsn_set_name(dsn, name);
			gda_dsn_set_description(dsn, description);
			gda_dsn_set_username(dsn, g_get_user_name());
			dsn_str = g_strdup_printf("DIRECTORY=%s", directory);
			gda_dsn_set_dsn(dsn, dsn_str);
			g_free((gpointer) dsn_str);

			if (!gda_dsn_save(dsn)) {
				gda_dsn_free(dsn);
				gnome_db_show_error(_("Could not save GDA data source"));
				goto run_dialog;
			}
		}

		/* free memory */
		if (dsn)
			gda_dsn_free(dsn);
	}
	gnome_dialog_close(GNOME_DIALOG(dialog));
}
