/* GnomerMind - A MasterMind(R)-based game for Gnome
 * (C) 2001 Germano Rizzo
 *
 * sounds.c - routines to control sounds
 * Author: Germano Rizzo
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
#include "common.h"

#ifdef HAVE_ESD

#include <sys/stat.h>
#include "cache.h"
#include <esd.h>

static gboolean active = FALSE;

gboolean sound_enable;

/**
 * sound_activate
 *
 * Activate the sound for the next event
 **/
inline void
sound_activate ()
{
  active = TRUE;
}

/**
 * sound_load
 * @name: the `base' name of the sound
 *
 * Loads a sound into the esound system, returns its ID
 **/
gint
sound_load (const gchar * name)
{
  struct stat buf;
  gchar *spath;
  gint id;

  spath = g_strconcat (SOUNDSPATH, "gm-", name, ".wav", NULL);

  if (stat (spath, &buf) && S_ISREG (buf.st_mode))
    {
      gchar *srow1, *srow2, *srow3;

      srow1 = _("Sound files not correctly installed.");
      srow2 = g_strdup_printf (_("The file %s can't be loaded"), spath);
      srow3 = _("Try installing again...");
      g_warning ("%s\n%s\n%s\n", srow1, srow2, srow3);

      return 0;
    }

  id = gnome_sound_sample_load (name, spath);

  if (id < 0)
    g_warning (_("can't load %s data from file %s"), "wav", spath);

  return id;
}

/**
 * sound_play
 * @id: the id of a sound
 * @uncond: if TRUE, plays the sound not caring the `active' flag
 *
 * Does the needed checks, and plays a sound
 **/
void
sound_play (gint id, gint uncond)
{
  if (sound_enable && (active || uncond))
    if (sndstock.sample[id] >= 0)
      {
	esd_sample_play (sndstock.connection, sndstock.sample[id]);
	fsync (sndstock.connection);
	active = FALSE;
      }
}

#endif
