#####################################################
#  gdip-lib.pl          Part of GnuDIP 2.1.1        #
#                                                   #
#    Common subs used by GnuDIP scripts             #
#                                                   #
#    See COPYING for licensing information          #
#                                                   #
#       Mike Machado <mike@innercite.com>           #
#                                                   #
#####################################################


my $conffile = '/etc/gnudip.conf';

# Simple routine to read config information from a file
# Added to the Debian GnuDIP package by Randolph Chung <tausq@debian.org>
sub readconf {
  my $var = shift;
  my $result;

  open (CONF, "<$conffile");
  while (<CONF>) {
    if (/^$var\s*=\s*(.+)$/) {
      $result = $1;
    }
  }
  close CONF;
  return $result;
}

# Returns the date and time in a mysql format
sub getdatetime {
  my $today = localtime(time());
  my ($day,$mon,$dayofmon,$time,$year) = split(/\s+/,$today);
  my @datemonths = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");

  my $numidx = "01";
  my ($nummon);
  foreach my $mons (@datemonths) {
    if ($mon eq $mons) {
     $nummon = $numidx;
    }
    $numidx++;
  }

  return "$year-$nummon-$dayofmon $time";

}

# Check to make sure an octet is really in the form of an IP octet
sub isoctet {
 my $string = shift;

 return 0 if $string eq '';
 return 0 if $string < 0 || $string > 255;

 $string =~ tr/[0-9]/ /;
 $string =~ s/ //g;

 return 1 if $string eq '';
 return 0;
}


# Generates a MD5 checksum
sub gensum {

 my $string = shift;

 my $md5 = new MD5;
 $md5->add($string);
 my $digest = $md5->digest();
 my $sum = unpack("H*", $digest);

 return $sum;
}
