/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -L ANSI-C -t -N lookup_type type_words.gperf  */
struct Type { char *name; SQLTypeWord type_word; };

#define TOTAL_KEYWORDS 20
#define MIN_WORD_LENGTH 3
#define MAX_WORD_LENGTH 9
#define MIN_HASH_VALUE 3
#define MAX_HASH_VALUE 57
/* maximum key range = 55, duplicates = 0 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static unsigned char asso_values[] =
    {
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 20,  5,
      15, 15, 58, 58, 28,  0, 58, 58,  0,  0,
       0, 58, 20, 58,  0,  5,  0, 58, 10, 25,
      58,  0, 20, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
      58, 58, 58, 58, 58, 58
    };
  return len + asso_values[(unsigned char)str[len - 1]] + asso_values[(unsigned char)str[0]];
}

#ifdef __GNUC__
__inline
#endif
struct Type *
lookup_type (register const char *str, register unsigned int len)
{
  static struct Type wordlist[] =
    {
      {""}, {""}, {""},
      {"int",            TW_INT},
      {"real",           TW_REAL},
      {"money",          TW_MONEY},
      {""},
      {"integer",        TW_INT},
      {"interval",       TW_INTERVAL},
      {"char",		TW_CHAR},
      {""}, {""},
      {"numeric",        TW_DECIMAL},
      {"smallint",       TW_SMALLINT},
      {"character",      TW_CHAR},
      {""}, {""},
      {"varchar",        TW_VARCHAR},
      {""},
      {"time",           TW_TIME},
      {""}, {""},
      {"decimal",        TW_DECIMAL},
      {""},
      {"bool",           TW_BOOL},
      {""}, {""},
      {"boolean",        TW_BOOL},
      {""},
      {"timestamp",      TW_TIMESTAMP},
      {""}, {""},
      {"without",	TW_WITHOUT},
      {""},
      {"date",           TW_DATE},
      {""}, {""}, {""}, {""},
      {"zone",		TW_ZONE},
      {""}, {""}, {""}, {""},
      {"blob",		TW_BLOB},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"with",		TW_WITH}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
