/*
 *  PGGraphvizDocument.h
 *  graphviz
 *
 *  Created by Glen Low on Tue Dec 23 2003.
 *  Copyright (c) 2003, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/graphviz/
 *  graphviz@pixelglow.com
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions
 *    and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Pixelglow Software nor the names of its contributors may be used to endorse or
 *    promote products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
#import <Cocoa/Cocoa.h>

typedef enum
	{
		ProcessNone,
		ProcessRendering,
		ProcessExporting,
		ProcessRenderedOK,
		ProcessExportedOK,
		ProcessRenderedError,
		ProcessExportedError
	} Process;

typedef enum
	{
		RenderDone,
		RenderDoing,
		RenderDeferred	
	} Render;
	
@class PGOption;
@class PGGraphvizSavePanelAccessoryController;

@interface PGGraphvizDocument : NSDocument
	{
		@private
			Process process_;
			Render render_;
			
			NSImage* image_;
			
			PGOption* layout_;
			PGOption* verbose_;
			PGOption* scale_;
			PGOption* invertY_;
			PGOption* position_;
			PGOption* reduceGraph_;
			PGOption* format_;
			
			NSArray* graphDefaults_;
			NSArray* nodeDefaults_;
			NSArray* edgeDefaults_;
			
			NSMutableArray* options_;
			NSMutableArray* taskers_;
			
			NSString* lastSaveToDirectory_;
	}
	
- (Process) process;
- (NSImage*) image;
	
- (PGOption*) layout;
- (PGOption*) verbose;
- (PGOption*) scale;
- (PGOption*) invertY;
- (PGOption*) position;
- (PGOption*) reduceGraph;
- (PGOption*) format;

- (NSArray*) graphDefaults;
- (NSArray*) nodeDefaults;
- (NSArray*) edgeDefaults;

- (NSMutableArray*) arguments;
- (NSString*) currentDirectoryPath;

- (IBAction) stopDocument: (id) sender;
- (IBAction) renderDocument: (id) sender;
- (IBAction) rememberSettings: (id) sender;

- (void) optionDidChange: (NSNotification*) notification;
- (void) rendererDidOutput: (NSNotification*) notification;
- (void) rendererDidStatus: (NSNotification*) notification;
- (void) exporterDidStatus: (NSNotification*) notification;

- (NSData*) data;
- (void) queueRender;

@end

extern NSString* DotDocumentProcessDidChange;
extern NSString* DotDocumentImageDidChange;
extern NSString* DotDocumentWillPrepareSavePanel;

extern NSString* DotDocumentSavePanel;
