// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.59 $
#include "hk_reportutils.h"
#include "hk_reportsectionpair.h"
#include "hk_datasource.h"
#include <nl_types.h>
#include <langinfo.h>
#include <locale.h>

//****************************************************
//*                 HTML Stuff                       *
//****************************************************

hk_reporthtml::hk_reporthtml(void):hk_report()
{
    p_columnbefore="";
    set_recodefunction("Html");
    p_withheader=true;
    p_pagehead="<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n";
    p_head="<meta http-equiv=\"Content-Type\" content=\"text/html;charset=iso-8859-1\">\n";
   hk_reportsectionpair* p_tableheadersectionpair= new_sectionpair();
   hk_reportsectionpair* p_tablesurroundpair= new_sectionpair();

   p_tableheadersection=p_tableheadersectionpair->headersection();
   p_tableheadersection->set_automatic_create_data(true);
   p_beforetablesection=p_tablesurroundpair->headersection();
   p_datasection=datasection();
   p_tableendsection=p_tablesurroundpair->footersection();
   p_beforetabledata=p_beforetablesection->new_data();
   p_aftertabledata=p_tableendsection->new_data();
//   set_fileextension(".html");

   p_pageheaddata=page_header()->new_data();
    configure_page();
    configure_table();


}


hk_reporthtml::~hk_reporthtml(void)
{

}


void hk_reporthtml::configure_page(void)
{
    hk_string buffer=p_pagehead+"\n<HTML>\n <HEAD>\n";
    page_header()->set_sectionbegin(buffer);
    buffer="   ";
    buffer+=p_head;
    if (p_title.size()>0)
    {
        buffer+="   <TITLE>";
        buffer+=p_title+"</TITLE>\n";

    }
    if (p_author.size()>0)
    {
        buffer+="   <meta name=\"author\" content=\"";
        buffer+=p_author+"\">\n";

    }

    p_pageheaddata->set_data(recode_html(buffer,this));
    page_header()->set_sectionend("\n </HEAD>\n <BODY>\n");
    page_footer()->set_sectionend(" </BODY>\n</HTML>\n");
    p_datasection->set_automatic_create_data(true);
}


void hk_reporthtml::configure_table(void)
{
    hk_string buffer;
    hk_string trtag="   <TR ";
    hk_string trendtag="</TR>\n";
    trtag+=p_trtag+">";
    p_beforetablesection->reportsectionpair()->set_columnname(p_groupcolumn);cerr <<"p_groupcolumn: "<<p_groupcolumn<<endl;
    p_beforetablesection->set_unique(true);
    p_beforetablesection->set_automatic_create_data(false);
    set_tabletag(" WIDTH=\"600\" BORDER=1 CELLSPACING=1");

    p_tableheadersection->reportsectionpair()->set_columnname(p_groupcolumn);
    p_tableheadersection->set_unique(true);
    if (p_withheader)
    {
        buffer="<TH ";
        buffer+=p_thtag+">%FIELDNAME%</TH>";
        p_tableheadersection->set_sectionbegin(trtag);
        p_tableheadersection->set_sectionend(trendtag);

    }
    else                                          //(not withheader
    {
        buffer="";
    }
    p_tableheadersection->set_default_reportdata(buffer);

    buffer="<TD ";
    buffer+=p_tdtag+">";
    p_datasection->set_default_beforereportdata(buffer);
    p_datasection->set_default_afterreportdata("</TD>");
    p_datasection->set_default_reportdata("%VALUE%");
    p_datasection->set_sectionbegin(trtag);
    p_datasection->set_sectionend(trendtag);

    p_tableendsection->set_columnname(p_groupcolumn);
    p_tableendsection->set_unique(true,true);
    p_tableendsection->set_automatic_create_data(false);
    p_tableendsection->set_sectionbegin("  </TABLE>\n");
    p_tableendsection->set_new_page_after_section(p_multiplefiles);



    buffer=p_aftervalue;
    if (p_columnafter.size()>0)buffer+="%VALUE%";
    p_aftertabledata->set_data(buffer);
    p_aftertabledata->set_columnname(p_columnafter);

    buffer=p_beforevalue;
    if (p_columnbefore.size()>0)buffer+="%VALUE%";
    p_beforetabledata->set_data(buffer);
    p_beforetabledata->set_columnname(p_columnbefore);

}


void hk_reporthtml::set_tabletag(const hk_string& t)
{
    p_tabletag=t;
    hk_string buffer;
    buffer="  <TABLE ";
    buffer+=p_tabletag+">\n";
    p_beforetablesection->set_sectionend(buffer);

}


void    hk_reporthtml::set_beforetable(const hk_string& value,const hk_string& columnname)
{
    p_columnbefore=columnname;
    p_beforevalue=recode_html(value,this);
    configure_table();
}


void    hk_reporthtml::set_aftertable(const hk_string& value,const hk_string& columnname)
{
    p_columnafter=columnname;
    p_aftervalue=recode_html(value,this);
    configure_table();
}


void hk_reporthtml::set_multiplefiles(bool m)
{
    hk_report::set_multiplefiles(m);
    configure_table();
}


void    hk_reporthtml::set_trtag(const hk_string& t)
{
    p_trtag=t;
    configure_table();
}


void    hk_reporthtml::set_thtag(const hk_string& t)
{
    p_thtag=t;
    configure_table();
}


void    hk_reporthtml::set_tdtag(const hk_string& t)
{
    p_tdtag=t;
    configure_table();
}


void    hk_reporthtml::set_beforehtmltag(const hk_string& b)
{
    p_pagehead=b;
    configure_page();
}


void    hk_reporthtml::set_betweenheadtags(const hk_string& b,const hk_string& colname)
{
    p_head=b;
    p_pageheaddata->set_columnname(colname);
    configure_page();
}


void    hk_reporthtml::set_title(const hk_string& t)
{
    p_title=t;
    configure_page();
}


void    hk_reporthtml::set_author(const hk_string& a)
{
    p_author=a;
    configure_page();
}


void    hk_reporthtml::set_groupcolumn(const hk_string& c)
{
    p_groupcolumn=c;cerr <<"set_: "<<p_groupcolumn<<endl;
    configure_table();
}


hk_string  recode_html(const hk_string& where,hk_report*)
{
    hk_string p_where;
    p_where=where;

    hk_string benannt[]=
    {
        "&nbsp;","&iexcl;","&cent;","&pound;","&curren;","&yen;",
        "&brvbar;","&sect;","&uml;","&copy;","&ordf;","&laquo;","&not;","&shy;",
        "&reg;","&macr;","&deg;","&plusmn;","&sup2;","&sup3;","&acute;","&micro;",
        "&para;","&middot;","&cedil;","&sup1;","&ordm;","&raquo;","&frac14;","&frac12;",
        "&frac34;","&iquest;","&Agrave;","&Aacute;","&Acirc;","&Atilde;","&Auml;","&Aring;",
        "&AElig;","&Ccedil;","&Egrave;","&Eacute;","&Ecirc;","&Euml;","&Igrave;","&Iacute;",
        "&Icirc;","&Iuml;","&ETH;","&Ntilde;","&Ograve;","&Oacute;","&Ocirc;","&Otilde;",
        "&Ouml;","&times;","&Oslash;","&Ugrave;","&Uacute;","&Ucirc;","&Uuml;","&Yacute;",
        "&THORN;","&szlig;","&agrave;","&aacute;","&acirc;",
        "&atilde;","&auml;","&aring;","&aelig;","&ccedil;","&egrave;","&eacute;","&ecirc;",
        "&euml;","&igrave;","&iacute;","&icirc;","&iuml;","&eth;","&ntilde;","&ograve;",
        "&oacute;","&ocirc;","&otilde;","&ouml;","&divide;","&oslash;","&ugrave;","&uacute;",
        "&ucirc;","&uuml;","&yacute;","&thorn;","&yuml;"

    } ;

    char* l= new char[2];
    l[1]=0;
    if (p_where.size()==0)p_where="&nbsp;";
    else
        for (int k=160;k<256;k++)
    {
        l[0]=k;
        p_where=replace_all(l,p_where,benannt[k-160]);
    }

    delete[] l;
    return p_where;

}


//****************************************************
//*             POSTSCRIPT Stuff                     *
//****************************************************

bool set_reporttype_postscript(hk_report* report,bool registerchange)
{
    if (report==NULL) return false;
    report->neutralize_definition(registerchange);
    report->set_fileextension(".ps",registerchange);
    report->set_pagedelimiter("showpage\n",registerchange);
    report->set_recodefunction("Postscript",registerchange);
    report->set_reportconfigurefunction("Postscript",registerchange);
    report->set_default_reportdata("%VALUE%",registerchange);
    report->configure_page();

    return true;

}


hk_string  recode_postscript(const hk_string& where,hk_report*r)
{
    hk_string p_where;
    p_where=smallstringconversion(where,nl_langinfo(CODESET),r!=NULL?r->fontencodingstring():"");

    p_where=replace_all("\\",p_where,"\\\\");     // Double all backslashes first BRH 06Nov02
    p_where=replace_all("(",p_where,"\\(");
    p_where=replace_all(")",p_where,"\\)");
    p_where=replace_all("\t",p_where,"\\t");
    p_where=replace_all("\b",p_where,"\\b");
    p_where=replace_all("\n",p_where,"\15");
    p_where=replace_all("\f",p_where,"\\f");

    const int bsize=60;
    char* m= new char[bsize];
    char* l= new char[2];
    l[1]=0;
    for (int k=160;k<256;k++)
    {
        snprintf(m,bsize,"%#o",k);
        m[0]='\\';
        l[0]=k;
        p_where=replace_all(l,p_where,m);
    }
    delete[] l;
    delete[] m;
    return p_where;

}


unsigned long recount_postscript(hk_reportsection* s)
{
    if (s==NULL) return 0;
    unsigned long c=0;
    unsigned long res=0;
    vector<hk_reportdata*>* dlist=s->datalist();
    if (dlist!=NULL)
    {
        vector<hk_reportdata*>::iterator it=dlist->begin();
        while (it!=dlist->end())
        {
            c=(*it)->y()+(*it)->height();
            if (c>res) res=c;
            it++;
        }
    }
    res+=s->offset();
    if (s->report()->sizetype()==hk_presentation::relative)
       res=s->relativ2vertical(res);
    return res;
}


void   configure_postscriptdata(hk_reportdata* d)
{
    if (d==NULL) return;
    hk_string res;
    res+="%XPOS% zmm %YPOS% zmm %WIDTH% zmm %HEIGHT% zmm (%ALIGN%) %FONTSIZE%  set_variables\n%BGRED% rgb %BGGREEN% rgb %BGBLUE% rgb %FGRED% rgb %FGGREEN% rgb %FGBLUE% rgb paint_background\n(";
    d->set_beforedata(res);
    if (d->wordbreak()) res=") /%PSFONT% BreakIntoLines\n";
    else res=") /%PSFONT% set_all\n" ;
    if (d->topline())res+="paint_top\n";
    if (d->bottomline())res+="paint_bottom\n";
    if (d->leftline())res+="paint_left\n";
    if (d->rightline())res+="paint_right\n";
    if (d->diagonalluro())res+="paint_diagonal_luro\n";
    if (d->diagonalloru())res+="paint_diagonal_loru\n";
//  if (d->report()->page_header()==d->section()
//      ||d->report()->page_footer()==d->section())res+="grestore\nset_pageboundaries\n";
    d->set_afterdata(res,false);
    int fsize=d->report()->vertical2relativ(zmm2ps(d->font().fontsize()));
    if ((int)d->height()<fsize)
    {
        d->set_height(fsize,false);
    }
}


void set_reportsection(hk_reportsection*s,const hk_string& p_defaultsctbegin
,const hk_string& p_defaultsctend
,const hk_string& p_defaultbeforedata
,const hk_string& p_defaultafterdata
)
{
//  internal function used by  configure_postscriptreport

    if (s==NULL) return;
    s->set_sectionbegin(p_defaultsctbegin,false);
    s->set_sectionend(p_defaultsctend,false);
    s->set_sectioncountfunction("Postscript",false);
    s->set_default_reportdataconfigurefunction("Postscript",false);
    s->set_default_reportdata(s->report()->default_reportdata(),false);
    s->set_default_beforereportdata(p_defaultbeforedata,false);
    s->set_default_afterreportdata(p_defaultafterdata,false);

    vector<hk_reportdata*>*d=s->datalist();
    if (d!=NULL)
    {
        vector<hk_reportdata*>::iterator data_it=d->begin();
        while(data_it!=d->end())
        {
            (*data_it)->set_configurefunction("Postscript",false);
            (*data_it)->set_beforedata(p_defaultbeforedata,false);
            (*data_it)->set_afterdata(p_defaultafterdata,false);
            configure_postscriptdata((*data_it));
            data_it++;
        }

    }
}


bool   configure_postscriptreport(hk_report* report,int encoding)
{

    int p_encoding=encoding;
    if  (p_encoding<1||p_encoding>12) p_encoding=1;
    p_encoding--;
    const hk_string encodingtable[13] =
    {
        "%ISO8859-15\n\
 [ /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n \
 /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n \
 /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n \
 /.notdef /.notdef /space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quoteright\n \
 /parenleft /parenright /asterisk /plus /comma /hyphen /period /slash /zero /one\n \
 /two /three /four /five /six /seven /eight /nine /colon /semicolon\n \
 /less /equal /greater /question /at /A /B /C /D /E\n \
 /F /G /H /I /J /K /L /M /N /O  /P /Q /R /S /T /U /V /W /X /Y\n \
 /Z /bracketleft /backslash /bracketright /asciicircum /underscore /quoteleft /a /b /c\n \
 /d /e /f /g /h /i /j /k /l /m\n \
 /n /o /p /q /r /s /t /u /v /w\n \
 /x /y /z /braceleft /bar /braceright /asciitilde /.notdef /.notdef /.notdef\n \
 /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n \
 /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n \
 /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n \
 /space /exclamdown /cent /sterling /Euro /yen /brokenbar /section /dieresis /copyright\n \
 /ordfeminine /guillemotleft /logicalnot /hyphen /registered /macron /degree /plusminus /twosuperior /threesuperior\n \
 /acute /mu /paragraph /periodcentered /cedilla /onesuperior /ordmasculine /guillemotright /onequarter /onehalf\n \
 /threequarters /questiondown /Agrave /Aacute /Acircumflex /Atilde /Adieresis /Aring /AE /Ccedilla\n \
 /Egrave /Eacute /Ecircumflex /Edieresis /Igrave /Iacute /Icircumflex /Idieresis /Eth /Ntilde\n \
 /Ograve /Oacute /Ocircumflex /Otilde /Odieresis /multiply /Oslash /Ugrave /Uacute /Ucircumflex\n \
 /Udieresis /Yacute /Thorn /germandbls /agrave /aacute /acircumflex /atilde /adieresis /aring\n \
 /ae /ccedilla /egrave /eacute /ecircumflex /edieresis /igrave /iacute /icircumflex /idieresis\n \
 /eth /ntilde /ograve /oacute /ocircumflex /otilde /odieresis /divide /oslash /ugrave\n \
 /uacute /ucircumflex /udieresis /yacute /thorn /ydieresis]",

        "%ISO8859-2\n\
 [  /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef   \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft   \n\
/parenright /asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five \n\
/six /seven /eight /nine /colon /semicolon /less /equal /greater /question /at /A /B /C /D /E /F \n\
/G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z /bracketleft /backslash /bracketright \n\
/asciicircum /underscore /grave /a /b /c /d /e /f /g  /h  /i /j /k /l /m /n /o /p /q /r /s /t /u  \n\
/v /w /x /y /z /braceleft /bar /braceright /asciitilde  \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  \n\
/space /Aogonek /breve /Lslash /currency /Lcaron /Sacute /section /dieresis /Scaron /Scedilla /Tcaron  \n\
/Zacute /hyphen /Zcaron /Zdotaccent /degree /aogonek /ogonek /lslash /acute /lcaron /sacute /caron  \n\
/cedilla /scaron /scedilla /tcaron /zacute /hungarumlaut /zcaron /zdotaccent /Racute /Aacute /Acircumflex  \n\
/Abreve /Adieresis /Lacute /Cacute /Ccedilla /Ccaron /Eacute /Eogonek /Edieresis /Ecaron /Iacute  \n\
/Icircumflex /Dcaron /Dcroat /Nacute /Ncaron /Oacute /Ocircumflex /Ohungarumlaut /Odieresis /multiply \n\
/Rcaron /Uring /Uacute /Uhungarumlaut /Udieresis /Yacute /Tcommaaccent /germandbls /racute /aacute  \n\
/acircumflex /abreve /adieresis /lacute /cacute /ccedilla /ccaron /eacute /eogonek /edieresis /ecaron  \n\
/iacute /icircumflex /dcaron /dcroat /nacute /ncaron /oacute /ocircumflex /ohungarumlaut  \n\
/odieresis /divide /rcaron  /uring /uacute /uhungarumlaut /udieresis /yacute /tcommaaccent /dotaccent ]",

        "%ISO8859-3\n\
 [ /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft \n\
/parenright /asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four\n\
/five /six /seven /eight /nine /colon /semicolon /less /equal /greater /question /at\n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z \n\
/bracketleft /backslash /bracketright /asciicircum /underscore /grave \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n\
/braceleft /bar /braceright /asciitilde \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /Hbar /breve /sterling /currency /.notdef /Hcircumflex /section /dieresis /Idotaccent \n\
/Scedilla /Gbreve /Jcircumflex /hyphen /.notdef /Zdotaccent /degree /hbar /twosuperior \n\
/threesuperior /acute /mu /hcircumflex /periodcentered /cedilla /dotlessi /scedilla /gbreve\n\
/jcircumflex /onehalf /.notdef /zdotaccent /Agrave /Aacute /Acircumflex /.notdef /Adieresis\n\
/Cdotaccent /Ccircumflex /Ccedilla /Egrave /Eacute /Ecircumflex /Edieresis /Igrave /Iacute \n\
/Icircumflex /Idieresis /.notdef /Ntilde /Ograve /Oacute /Ocircumflex /Gdotaccent /Odieresis \n\
/multiply /Gcircumflex /Ugrave /Uacute /Ucircumflex /Udieresis /Ubreve /Scircumflex /germandbls\n\
/agrave /aacute /acircumflex /.notdef /adieresis /cdotaccent /ccircumflex /ccedilla /egrave\n\
/eacute /ecircumflex /edieresis /igrave /iacute /icircumflex /idieresis /.notdef /ntilde /ograve \n\
/oacute /ocircumflex /gdotaccent /odieresis /divide /gcircumflex /ugrave /uacute /ucircumflex \n\
/udieresis /ubreve /scircumflex /dotaccent\
 ]",

        "%ISO8859-4\n\
 [ /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft /parenright\n\
/asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five /six /seven /eight \n\
/nine /colon /semicolon /less /equal /greater /question /at  \n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z\n\
/bracketleft /backslash /bracketright /asciicircum /underscore  /grave \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n\
/braceleft /bar /braceright /asciitilde \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /Aogonek /kgreenlandic /Rcommaaccent /currency /Itilde /Lcommaaccent /section /dieresis /Scaron\n\
/Emacron /Gcommaaccent /Tbar /hyphen /Zcaron /macron /degree /aogonek /ogonek /rcommaaccent /acute \n\
/itilde /lcommaaccent /caron /cedilla /scaron /emacron /gcommaaccent /tbar /Eng /zcaron /eng \n\
/Amacron /Aacute /Acircumflex /Atilde /Adieresis /Aring /AE /Iogonek /Ccaron /Eacute /Eogonek /Edieresis\n\
/Edotaccent /Iacute /Icircumflex /Imacron /Dcroat /Ncommaaccent /Omacron /Kcommaaccent /Ocircumflex \n\
/Otilde /Odieresis /multiply /Oslash /Uogonek /Uacute /Ucircumflex /Udieresis /Utilde /Umacron /germandbls \n\
/amacron /aacute /acircumflex /atilde /adieresis /aring /ae /iogonek /ccaron /eacute /eogonek /edieresis\n\
/edotaccent /iacute /icircumflex /imacron /dcroat /ncommaaccent /omacron /kcommaaccent /ocircumflex \n\
/otilde /odieresis /divide /oslash /uogonek /uacute /ucircumflex /udieresis /utilde /umacron /dotaccent\
 ]",

        "%ISO8859-5\n\
 [/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft /parenright\n\
/asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five /six /seven /eight \n\
/nine /colon /semicolon /less /equal /greater /question /at  \n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z\n\
/bracketleft /backslash /bracketright /asciicircum /underscore  /grave \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n\
/braceleft /bar /braceright /asciitilde \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /afii10023 /afii10051 /afii10052 /afii10053 /afii10054 /afii10055 /afii10056 /afii10057 \n\
/afii10058 /afii10059 /afii10060 /afii10061 /hyphen /afii10062 /afii10145 /afii10017 /afii10018 \n\
/afii10019 /afii10020 /afii10021 /afii10022 /afii10024 /afii10025 /afii10026 /afii10027 /afii10028\n\
/afii10029 /afii10030 /afii10031 /afii10032 /afii10033 /afii10034 /afii10035 /afii10036 /afii10037\n\
/afii10038 /afii10039 /afii10040 /afii10041 /afii10042 /afii10043 /afii10044 /afii10045 /afii10046\n\
/afii10047 /afii10048 /afii10049 /afii10065 /afii10066 /afii10067 /afii10068 /afii10069 /afii10070\n\
/afii10072 /afii10073 /afii10074 /afii10075 /afii10076 /afii10077 /afii10078 /afii10079 /afii10080\n\
/afii10081 /afii10082 /afii10083 /afii10084 /afii10085 /afii10086 /afii10087 /afii10088 /afii10089\n\
/afii10090 /afii10091 /afii10092 /afii10093 /afii10094 /afii10095 /afii10096 /afii10097 /afii61352\n\
/afii10071 /afii10099 /afii10100 /afii10101 /afii10102 /afii10103 /afii10104 /afii10105 /afii10106\n\
/afii10107 /afii10108 /afii10109 /section   /afii10110 /afii10193\
 ]",

        "%ISO8859-6\n\
 [/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft /parenright\n\
/asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five /six /seven /eight \n\
/nine /colon /semicolon /less /equal /greater /question /at  \n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z\n\
/bracketleft /backslash /bracketright /asciicircum /underscore  /grave \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n\
/braceleft /bar /braceright /asciitilde \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /.notdef /.notdef /.notdef /currency /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  \n\
/.notdef /afii57388 /hyphen /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /afii57403 /.notdef /.notdef /.notdef /afii57407 /.notdef \n\
/afii57409 /afii57410 /afii57411 /afii57412 /afii57413 /afii57414 /afii57415 /afii57416 /afii57417 \n\
/afii57418 /afii57419 /afii57420 /afii57421 /afii57422 /afii57423 /afii57424 /afii57425 /afii57426 \n\
/afii57427 /afii57428 /afii57429 /afii57430 /afii57431 /afii57432 /afii57433 /afii57434 /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /afii57440 /afii57441 /afii57442 /afii57443 /afii57444 /afii57445 \n\
/afii57446 /afii57470 /afii57448 /afii57449 /afii57450 /afii57451 /afii57452 /afii57453 /afii57454 \n\
/afii57455 /afii57456 /afii57457 /afii57458 /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \
 ]",

        "%ISO8859-7\n\
 [/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft /parenright\n\
/asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five /six /seven /eight \n\
/nine /colon /semicolon /less /equal /greater /question /at  \n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z\n\
/bracketleft /backslash /bracketright /asciicircum /underscore  /grave \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n\
/braceleft /bar /braceright /asciitilde \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /quoteleft /quoteright /sterling /.notdef /.notdef /brokenbar /section /dieresis /copyright\n\
/.notdef /guillemotleft /logicalnot /hyphen /.notdef /afii00208 /degree /plusminus /twosuperior  \n\
/threesuperior /tonos /dieresistonos /Alphatonos /periodcentered /Epsilontonos /Etatonos /Iotatonos \n\
/guillemotright /Omicrontonos /onehalf /Upsilontonos /Omegatonos /iotadieresistonos /Alpha  /Beta \n\
/Gamma /Delta /Epsilon /Zeta /Eta /Theta /Iota /Kappa /Lambda /Mu /Nu /Xi /Omicron /Pi /Rho /.notdef \n\
/Sigma /Tau /Upsilon /Phi /Chi /Psi /Omega /Iotadieresis /Upsilondieresis /alphatonos /epsilontonos \n\
/etatonos /iotatonos /upsilondieresistonos /alpha /beta /gamma /delta /epsilon /zeta /eta /theta \n\
/iota /kappa /lambda /mu /nu /xi /omicron /pi /rho /sigma1 /sigma /tau /upsilon /phi /chi /psi \n\
/omega /iotadieresis /upsilondieresis /omicrontonos /upsilontonos /omegatonos /.notdef\
 ]",

        "%ISO8859-8\n\
 [ /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft /parenright\n\
/asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five /six /seven /eight \n\
/nine /colon /semicolon /less /equal /greater /question /at  \n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z\n\
/bracketleft /backslash /bracketright /asciicircum /underscore  /grave \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n\
/braceleft /bar /braceright /asciitilde \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /.notdef /cent /sterling /currency /yen /brokenbar /section /dieresis /copyright /multiply \n\
/guillemotleft /logicalnot /hyphen /registered /macron /degree /plusminus /twosuperior /threesuperior \n\
/acute /mu /paragraph /periodcentered /cedilla /onesuperior /divide /guillemotright /onequarter \n\
/onehalf /threequarters /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/underscoredbl /afii57664 /afii57665 /afii57666 /afii57667 /afii57668 /afii57669 /afii57670 /afii57671 \n\
/afii57672 /afii57673 /afii57674 /afii57675 /afii57676 /afii57677 /afii57678 /afii57679 /afii57680 \n\
/afii57681 /afii57682 /afii57683 /afii57684 /afii57685 /afii57686 /afii57687 /afii57688 /afii57689 \n\
/afii57690 /.notdef /.notdef /afii299 /afii300 /.notdef \
 ]",

        "%ISO8859-9\n\
 [ /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft /parenright\n\
/asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five /six /seven /eight \n\
/nine /colon /semicolon /less /equal /greater /question /at  \n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z\n\
/bracketleft /backslash /bracketright /asciicircum /underscore  /grave \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n\
/braceleft /bar /braceright /asciitilde \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclamdown /cent /sterling /currency /yen /brokenbar /section /dieresis /copyright /ordfeminine \n\
/guillemotleft /logicalnot /hyphen /registered /macron /degree /plusminus /twosuperior /threesuperior \n\
/acute /mu /paragraph /periodcentered /cedilla /onesuperior /ordmasculine /guillemotright /onequarter \n\
/onehalf /threequarters /questiondown /Agrave /Aacute /Acircumflex /Atilde /Adieresis /Aring /AE \n\
/Ccedilla /Egrave /Eacute /Ecircumflex /Edieresis /Igrave /Iacute /Icircumflex /Idieresis /Gbreve \n\
/Ntilde /Ograve /Oacute /Ocircumflex /Otilde /Odieresis /multiply /Oslash /Ugrave /Uacute /Ucircumflex \n\
/Udieresis /Idotaccent /Scedilla /germandbls /agrave /aacute /acircumflex /atilde /adieresis /aring \n\
/ae /ccedilla /egrave /eacute /ecircumflex /edieresis /igrave /iacute /icircumflex /idieresis /gbreve \n\
/ntilde /ograve /oacute /ocircumflex /otilde /odieresis /divide /oslash /ugrave /uacute /ucircumflex \n\
/udieresis /dotlessi /scedilla /ydieresis \
 ]",

        "%ISO8859-10\n\
 [/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef\n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft /parenright\n\
/asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five /six /seven /eight \n\
/nine /colon /semicolon /less /equal /greater /question /at  \n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z\n\
/bracketleft /backslash /bracketright /asciicircum /underscore  /grave \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n\
/braceleft /bar /braceright /asciitilde \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /Aogonek /Emacron /Gcommaaccent /Imacron /Itilde /Kcommaaccent /section /Lcommaaccent /Dcroat \n\
/Scaron /Tbar /Zcaron /hyphen /Umacron /Eng /degree /aogonek /emacron /gcommaaccent /imacron /itilde \n\
/kcommaaccent /periodcentered /lcommaaccent /dcroat /scaron /tbar /zcaron /afii00208 /umacron /eng \n\
/Amacron /Aacute /Acircumflex /Atilde /Adieresis /Aring /AE /Iogonek /Ccaron /Eacute /Eogonek \n\
/Edieresis /Edotaccent /Iacute /Icircumflex /Idieresis /Eth /Ncommaaccent /Omacron /Oacute /Ocircumflex \n\
/Otilde /Odieresis /Utilde /Oslash /Uogonek /Uacute /Ucircumflex /Udieresis /Yacute /Thorn /germandbls \n\
/amacron /aacute /acircumflex /atilde /adieresis /aring /ae /iogonek /ccaron /eacute /eogonek /edieresis \n\
/edotaccent /iacute /icircumflex /idieresis /eth /ncommaaccent /omacron /oacute /ocircumflex /otilde \n\
/odieresis /utilde /oslash /uogonek /uacute /ucircumflex /udieresis /yacute /thorn /kgreenlandic \
 ]",

        "%KOI8-R\n\
 [/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef  \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft /parenright \n\
/asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five /six /seven /eight \n\
/nine /colon /semicolon /less /equal /greater /question /at \n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z\n\
/bracketleft /backslash /bracketright /asciicircum /underscore /grave \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z \n\
/braceleft /bar /braceright /asciitilde /.notdef /SF100000 /SF110000 /SF010000 /SF030000 /SF020000 \n\
/SF040000 /SF080000 /SF090000 /SF060000 /SF070000 /SF050000 /upblock /dnblock /block /lfblock /rtblock \n\
/ltshade /shade /dkshade /integraltp /filledbox /periodcentered /radical /approxequal /lessequal \n\
/greaterequal /space /integralbt /degree /twosuperior /periodcentered /divide /SF430000 /SF240000 \n\
/SF510000 /afii10071 /SF520000 /SF390000 /SF220000 /SF210000 /SF250000 /SF500000 /SF490000 /SF380000 \n\
/SF280000 /SF270000 /SF260000 /SF360000 /SF370000 /SF420000 /SF190000 /afii10023 /SF200000 /SF230000 \n\
/SF470000 /SF480000 /SF410000 /SF450000 /SF460000 /SF400000 /SF540000 /SF530000 /SF440000 /copyright \n\
/afii10096 /afii10065 /afii10066 /afii10088 /afii10069 /afii10070 /afii10086 /afii10068 /afii10087 \n\
/afii10074 /afii10075 /afii10076 /afii10077 /afii10078 /afii10079 /afii10080 /afii10081 /afii10097 \n\
/afii10082 /afii10083 /afii10084 /afii10085 /afii10072 /afii10067 /afii10094 /afii10093 /afii10073 \n\
/afii10090 /afii10095 /afii10091 /afii10089 /afii10092 /afii10048 /afii10017 /afii10018 /afii10040 \n\
/afii10021 /afii10022 /afii10038 /afii10020 /afii10039 /afii10026 /afii10027 /afii10028 /afii10029 \n\
/afii10030 /afii10031 /afii10032 /afii10033 /afii10049 /afii10034 /afii10035 /afii10036 /afii10037 \n\
/afii10024 /afii10019 /afii10046 /afii10045 /afii10025 /afii10042 /afii10047 /afii10043 /afii10041 \n\
/afii10044  \
 ]",

        "%KOI8-U\n\
 [/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n\
/space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quotesingle /parenleft /parenright \n\
/asterisk /plus /comma /hyphen /period /slash /zero /one /two /three /four /five /six /seven /eight \n\
/nine /colon /semicolon /less /equal /greater /question /at \n\
/A /B /C /D /E /F /G /H /I /J /K /L /M /N /O /P /Q /R /S /T /U /V /W /X /Y /Z \n\
/bracketleft /backslash /bracketright /asciicircum /underscore /grave  \n\
/a /b /c /d /e /f /g /h /i /j /k /l /m /n /o /p /q /r /s /t /u /v /w /x /y /z\n\n\n\
/braceleft /bar /braceright /asciitilde /.notdef \n\
/SF100000 /SF110000 /SF010000 /SF030000 /SF020000 /SF040000 /SF080000 /SF090000 /SF060000 /SF070000 \n\
/SF050000 /upblock /dnblock /block /lfblock /rtblock /ltshade /shade /dkshade /integraltp /filledbox \n\
/bullet /radical /approxequal /lessequal /greaterequal /space /integralbt /degree /twosuperior\n\
/periodcentered /divide /SF430000 /SF240000 /SF510000 /afii10071 /afii10101 /SF390000 /afii10103 \n\
/afii10104 /SF250000 /SF500000 /SF490000 /SF380000 /SF280000 /afii10098  /SF260000 /SF360000 /SF370000 \n\
/SF420000 /SF190000 /afii10023 /afii10053 /SF230000 /afii10055 /afii10056 /SF410000 /SF450000 /SF460000\n\
/SF400000 /SF540000 /afii10050 /SF440000 /copyright /afii10096 /afii10065 /afii10066 /afii10088  \n\
/afii10069 /afii10070 /afii10086 /afii10068 /afii10087 /afii10074 /afii10075 /afii10076 /afii10077 \n\
/afii10078 /afii10079 /afii10080 /afii10081 /afii10097 /afii10082 /afii10083 /afii10084 /afii10085 \n\
/afii10072  /afii10067 /afii10094 /afii10093 /afii10073 /afii10090 /afii10095 /afii10091 /afii10089 \n\
/afii10092 /afii10048 /afii10017 /afii10018 /afii10040 /afii10021 /afii10022 /afii10038 /afii10020 \n\
/afii10039 /afii10026 /afii10027 /afii10028 /afii10029 /afii10030 /afii10031 /afii10032  /afii10033 \n\
/afii10049 /afii10034 /afii10035 /afii10036 /afii10037 /afii10024 /afii10019 /afii10046  /afii10045 \n\
/afii10025 /afii10042 /afii10047 /afii10043 /afii10041 /afii10044 \
 ]"
    } ;

    if (report==NULL) return false;
    hk_string p_filehead="%!PS-Adobe-3.0\n%%Creator:  HK_CLASSES <c> 2000-2002 Horst Knorr <hk_classes@knoda.org>\n\
%%Pages: (atend)\n%%DocumentNeededFonts: (atend)\n%%DocumentSuppliedFonts: (atend)\n%BOUNDINGBOX%\n%%Orientation: ";
    p_filehead+=(report->orientation()==hk_report::landscape?"Landscape":"Portrait");
    p_filehead+="\n%%DocumentMedia: Plain ";
    p_filehead+=ulongint2string(zmm2ps(report->designwidth()))+" ";
    p_filehead+=ulongint2string(zmm2ps(report->designheight()));
//      delete[] m;

    p_filehead+=" () ()\n\n%%EndComments\n%%BeginProlog\n%%EndProlog\n%%BeginSetup\n%DEFINITIONS\n%\n\
/set_clippath\n{\nnewpath\n\tx leftborder add  y  moveto\n\twidth 0 rlineto\n\t0 height rlineto\n\
   \twidth neg 0 rlineto\n\tclosepath clip\n} def\n\n \
/position\n{\n\tdup stringwidth pop\n\t/w exch def\n\talign (RIGHT) eq\n\t{/nx x width add leftborder add w sub def}\
{\n\talign (CENTER) eq\n\t{/nx x width 2 div add leftborder add w 2 div sub def}\n\t{/nx x leftborder add def\n\t}\
\n\t   	ifelse\n\t}\n\tifelse\n} def\n\n\
/set_textposition\n{\n\tposition\n\tnx y fontsize 5 div add moveto\n} def\n\n\
/set_font\n{\n\t/wantedfont exch def\n\twantedfont /myfont fontencoding ReEncode\n\t/myfont\
                \n\tfindfont\n\tfontsize scalefont\n\tsetfont\n} def\n\n\
/set_variables\n{\n\t/fontsize exch def\n\t/align exch def\n\t/height exch def\n\t/width exch def\n\t/y exch def\n\t/x exch def\n\t/yrel offset y sub fontsize sub def\n\t/y offset y sub height sub def\n} def\n\n\
/set_all\n{\n\tgsave\n\tset_clippath\n\tset_font\n\tset_textposition\n\tshow\n\tgrestore\n} def\n\n\
/paint_background\n{\n\t/fgblue exch def\n\t/fggreen exch def\n\t/fgred exch def\n\t/bgblue exch def\n\t/bggreen exch def\n\t/bgred exch def\n\t\
\n\tgsave\n\tset_clippath\n\tbgred bggreen bgblue setrgbcolor\n\tfill\n\tgrestore\n\tfgred fggreen fgblue setrgbcolor\n\t} def\n\t\
   \n/set_pageboundaries\n{\n\tgsave\n\t/x 0 def\n\t/y bottomborder def\n\t/width pagewidth leftborder sub rightborder sub def\n\t/height pageheight topborder sub bottomborder sub def\n\
   \t/offset pageheight topborder sub def\n\t%set_clippath\n";

    if (report->topline())p_filehead+="\tpaint_top\n";
    if (report->bottomline())p_filehead+="\tpaint_bottom\n";
    if (report->leftline())p_filehead+="\tpaint_left\n";
    if (report->rightline())p_filehead+="\tpaint_right\n";
    if (report->diagonalluro())p_filehead+="\tpaint_diagonal_luro\n";
    if (report->diagonalloru())p_filehead+="\tpaint_diagonal_loru\n";

    p_filehead+="\n\t} def\n\n\n" ;
    p_filehead+=encodingtable[p_encoding];

    p_filehead+=" /fontencoding exch def \n\n\
/ReEncode\n{\n\t/newencoding exch def\n\t/newfontname exch def\n\
   \t/basefontname exch def\n\t/basefontdict basefontname findfont def\n\
   \t/newfont basefontdict maxlength dict def\n\n\tbasefontdict\n\t{\
    \n\texch dup dup /FID ne exch /Encoding ne and \n\t{ exch newfont 3 1 roll put }\n\t{ pop pop } \
    \n\tifelse\n\t} forall\n\tnewfont /FontName newfontname put\n\tnewfont /Encoding newencoding put \
   \n\tnewfontname newfont definefont pop\n} def\n\n\
   /paint_top\n{\n\tnewpath\n\tx leftborder add   y height add moveto\n\twidth  0 rlineto\n\tstroke\n} def\n\n\n \
   /paint_bottom\n{\n\tnewpath\n\tx leftborder add  y   moveto\n\twidth  0 rlineto\n\tstroke\n} def\n\n\n \
   /paint_left\n{\n\tnewpath\n\tx leftborder add  y   moveto\n\t0  height rlineto\n\tstroke\n} def\n\n\n \
   /paint_right\n{\n\tnewpath\n\tx leftborder add width add y  moveto\n\t0 height rlineto\n\tstroke\n} def\n\n\n \
   /paint_diagonal_loru\n{\n\tnewpath\n\tx leftborder add  y  height add moveto\n\twidth height neg rlineto\n\tstroke\n} def\n\n\n \
   /paint_diagonal_luro\n{\n\tnewpath\n\tx leftborder add  y  moveto\n\twidth height rlineto\n\tstroke\n} def\n\n\n \
   \n/zmm\n{\n\t72 mul 254 div\n} def\n\n\n \
   \n/rgb\n{\n\t 255 div\n} def\n\n\n \
    /set_pagesize\n{\n\t/x 0 def\n\t/y bottomborder def\n\t/height pageheight topborder sub bottomborder sub def\
\n\t/width pagewidth leftborder sub rightborder sub def\n\tgsave\n\tset_clippath\n\t/offset pageheight def\n} def\
   /pagehead\n{\n\t/x 0 def\n\t/y pageheight topborder sub def\n\t/height topborder def\n\n \
   \t/width pagewidth leftborder sub rightborder sub def\n\tset_clippath\n\t/offset pageheight def\n} def\n\n\n \
   /pagefoot\n{\n\t/x 0 def\n\t/y 0 def\n\t/height bottomborder def\n\n \
   \t/width pagewidth leftborder sub rightborder sub def\n\tset_clippath\n\t/offset bottomborder  def\n} def\n\n\
/proc\n\t{\n\tposition\n\tnx yrel moveto show\n\t/yrel yrel fontsize sub def\n\t} def\n\n\
/wordbreak ( ) def\n\n\
/singleBreakIntoLines\n\t{\n\tgsave\n\tset_clippath\n\tset_font\n\t/nextword () def\n\t/textstring exch def\n\t\
/breakwidth wordbreak stringwidth pop def\n\t/curwidth 0 def\n\t/lastwordbreak 0 def\n\t/startchar 0 def\n\t\
/restoftext textstring def\n\t{  %loop begin\n\trestoftext wordbreak search\n\t{\n\t/nextword exch def pop\
\n\t/restoftext exch def\n\t/wordwidth nextword stringwidth pop def\n\tcurwidth wordwidth add width gt\n\t\{\
\n\ttextstring startchar\n\tlastwordbreak startchar sub\n\tgetinterval proc\n\t/startchar lastwordbreak def\
\n\t/curwidth wordwidth breakwidth add def\n\t}\n\t{\n\t/curwidth curwidth wordwidth add breakwidth add def\n\t}\
ifelse\n\t/lastwordbreak lastwordbreak nextword length add 1 add def\n\t}\n\t{\n\t/restoftext exch def exit\n\t}\
\n\tifelse\n\t} loop\n\t/wordwidth nextword stringwidth pop def\n\t/lastchar textstring length def\
\n\t/restlength  lastchar startchar sub  def\n\ttextstring startchar restlength\n\tgetinterval\n\t/txt exch def\
\n\ttxt stringwidth pop width gt\n\t{\n\ttextstring startchar lastwordbreak startchar sub getinterval\
\n\tproc\n\trestoftext\n\tproc\n\t}\n\t{\n\ttxt\n\tproc\n\t}\n\tifelse\n\tgrestore\n}def\n\
/textvor () def\
/EOLchar (\n) def\
/BreakIntoLines\
{\n/font exch def\
 /textnach exch def\
{\ntextnach\nEOLchar search\
   { %if  Success\n/textvor exch def\n     pop %ignore match\n     /textnach exch def\n}\
   { %else    \n    font singleBreakIntoLines\n     exit\n   }ifelse\ntextvor font\nsingleBreakIntoLines\
} loop\
} def\n";
    hk_string   p_defaultbeforedata="%XPOS% zmm %YPOS% zmm %WIDTH% zmm %HEIGHT% zmm (%ALIGN%) %FONTSIZE%  set_variables\n(";
    hk_string   p_defaultafterdata=") /%PSFONT% set_all\n";

    hk_string def;
    hk_string defbefore;
    hk_string defafter;
    defbefore="gsave\npagehead\n";
    defbefore+=p_defaultbeforedata;
    report->page_header()->set_default_beforereportdata(defbefore,false);
    hk_string sectionbegin="\n%%Page: %PAGENUMBER% %ABSOLUTEPAGENUMBER% \n";
    if ((report->orientation()==hk_report::landscape)&&report->pageformat()!=hk_report::userdefined)
    {
        sectionbegin+=longint2string(report->designheight());
        sectionbegin+=" zmm 0 translate\n90 rotate\n\n";
    }
    sectionbegin+="/offset pageheight topborder sub def\ngsave\npagehead\n";
    report->page_header()->set_sectionbegin(sectionbegin,false);
//   defafter=p_defaultafterdata+"grestore\ngsave\nset_pageboundaries\n";
//   report->page_header()->set_default_afterdata(defafter);
    report->page_header()->set_default_afterreportdata("",false);
    report->page_header()->set_sectionend("grestore\nset_pagesize\n%BGRED% rgb %BGGREEN% rgb %BGBLUE% rgb %FGRED% rgb %FGGREEN% rgb %FGBLUE% rgb paint_background\nset_pageboundaries\n\n%Pagehead Ende\n",false);

    report->page_header()->set_default_reportdata(report->default_reportdata(),false);
    report->page_header()->set_default_reportdataconfigurefunction("Postscript",false);
// set pagehead
    vector<hk_reportdata*>*dit=report->page_header()->datalist();
    if (dit!=NULL)
    {
        vector<hk_reportdata*>::iterator data_it=dit->begin();
        while(data_it!=dit->end())
        {
            (*data_it)->set_configurefunction("Postscript",false);
            (*data_it)->set_beforedata(defbefore,false);
            (*data_it)->set_afterdata(defafter,false);
            configure_postscriptdata((*data_it));
            data_it++;
        }
    }

    defbefore="";
    defbefore+=p_defaultbeforedata;
    report->page_footer()->set_default_beforereportdata(defbefore,false);
    report->page_footer()->set_default_afterreportdata(defafter,false);
    report->page_footer()->set_default_reportdata(report->default_reportdata(),false);
    report->page_footer()->set_default_reportdataconfigurefunction("Postscript",false);
    report->page_footer()->set_sectionbegin("grestore\ngrestore\ngsave\n\npagefoot\n%Pagefooter Begin\n",false);
    report->page_footer()->set_sectionend("grestore\ngsave\nset_pageboundaries\ngrestore\n%Pagefooter Ende\n",false);

// set pagefoot
    dit=report->page_footer()->datalist();
    if (dit!=NULL)
    {
        vector<hk_reportdata*>::iterator data_it=dit->begin();
        while(data_it!=dit->end())
        {
            (*data_it)->set_configurefunction("Postscript",false);
            (*data_it)->set_beforedata(defbefore,false);
            (*data_it)->set_afterdata(defafter,false);
            configure_postscriptdata((*data_it));
            data_it++;
        }
    }

    hk_string h=p_filehead;

    h+="\n/pagewidth ";
    hk_string d=" zmm def\n";
    h+=longint2string(report->designwidth());
    h+=d+"/pageheight ";
    h+=longint2string(report->designheight());
    h+=d+"/leftborder %BORDERLEFT%";

    h+=d+"/rightborder %BORDERRIGHT%";

    h+=d+"/topborder %BORDERTOP%";

    h+=d+"/bottomborder %BORDERBOTTOM%";

    h+=d;
    h+="%%EndSetup\n%PROGRAMM START\n \n\n";
    report->set_filebegin(h,false);
    report->set_periodic(report->designheight()-
      ((report->sizetype()==hk_report::relative)?(
      report->relativ2vertical(report->border_bottom()+report->border_top()))
      :(report->border_bottom()+report->border_top())),"",true,false);

    hk_string p_defaultsctend="/offset offset %COUNTS_AS% zmm  sub def\n\n\n";
    report->set_default_beforereportdata(p_defaultbeforedata,false);
    report->set_default_afterreportdata(p_defaultafterdata,false);
    report->set_default_reportsectionbegin("",false);
    report->set_default_reportsectionend(p_defaultsctend,false);
    report->set_default_reportsectioncountfunction("Postscript",false);
    report->set_default_reportdataconfigurefunction("Postscript",false);
    report->set_fileend("%%Trailer\n%PSNEEDEDFONTS%%PSSUPPLIEDFONTS%\n%%Pages: %ABSOLUTEPAGENUMBER%\n%%EOF\n",false);

// set data

    vector<hk_reportsectionpair*>* s=report->sectionpairs();

    if (s!=NULL)
    {
        vector<hk_reportsectionpair*>::iterator section_it=s->begin();
        while(section_it!=s->end())
        {
            set_reportsection((*section_it)->headersection(),"",p_defaultsctend,p_defaultbeforedata,p_defaultafterdata);
            set_reportsection((*section_it)->footersection(),"",p_defaultsctend,p_defaultbeforedata,p_defaultafterdata);
            section_it++;
        }

        if (report->report_header()!=NULL) set_reportsection(report->report_header(),"%reportheadersection\n",p_defaultsctend,p_defaultbeforedata,p_defaultafterdata);
        if (report->report_footer()!=NULL) set_reportsection(report->report_footer(),"%reportfootersection\n",p_defaultsctend,p_defaultbeforedata,p_defaultafterdata);
        if (report->datasection()!=NULL) set_reportsection(report->datasection(),"%reportdatasection\n",p_defaultsctend,p_defaultbeforedata,p_defaultafterdata);

    }
    return true;
}


unsigned long zmm2ps(unsigned long u)
{
    return (unsigned long)(u*72/254+0.5);

}


unsigned long ps2zmm(unsigned long u)
{

    return (unsigned long)(u*254/72+0.5);
}


//****************************************************
//*             CSV Stuff                            *
//****************************************************

hk_reportcsv::hk_reportcsv(void):hk_report()
{
    p_datasection=datasection();
    p_footsection=new_sectionpair()->footersection();;
    p_withheader=true;
    p_delimiter="\"";
    p_between=" , ";
    set_default_use_reportseparator(false);
    set_default_reportprecision(-1);
    set_use_standard_storagepath(false);
    configure_page();
}


hk_reportcsv::~hk_reportcsv(void)
{

}


void hk_reportcsv::set_groupcolumn(const hk_string& c)
{
    p_groupcolumn=c;
    p_footsection->set_columnname(p_groupcolumn);
    p_footsection->set_unique(true,true);
}


void hk_reportcsv::set_multiplefiles(bool m)
{
    hk_report::set_multiplefiles(m);
    p_footsection->set_new_page_after_section(m);
}


void    hk_reportcsv::set_dataformat(const hk_string& delimiter,const hk_string& between)
{
    p_delimiter=delimiter;
    p_between=between;
    configure_page();

}


void hk_reportcsv::set_withheader(bool with)
{

    p_withheader=with;
    configure_page();

}


void hk_reportcsv::configure_page(void)
{
    if (p_withheader)
    {

        hk_string h=p_delimiter+"%FIELDNAME%";
        h+=p_delimiter;
        page_header()->set_default_reportdata(h);
        page_header()->set_betweendata(p_between);
        page_header()->set_sectionend("\n");
        page_header()->set_automatic_create_data(true);
    }
    else
    {
        page_header()->set_default_reportdata("");
        page_header()->set_betweendata("");
        page_header()->set_sectionend("");
        page_header()->set_automatic_create_data(false);
    }

    hk_string h="%VALUE%";
    p_datasection->set_default_reportprecision(-1);
    p_datasection->set_default_use_reportseparator(false);
    p_datasection->set_default_reportdata(h);
    p_datasection->set_betweendata(p_between);
    p_datasection->set_sectionend("\n");
    p_datasection->set_automatic_create_data(true);
    p_footsection->set_columnname( p_groupcolumn);
    p_footsection->set_unique(true,true);
    p_footsection->set_automatic_create_data(false);

}


void    hk_reportcsv::widget_specific_before_execute(void)
{
    setlocale(LC_NUMERIC,"C");
    datasection()->set_automaticcreatedatafunction(&automatic_create_csvfields);
}


void    hk_reportcsv::widget_specific_after_execute(void)
{
    setlocale(LC_NUMERIC,locale().c_str());
}


void set_cvs(hk_report* e,bool with_header,const hk_string& col_delimiter, const hk_string& betweendata)
{
    if (e==NULL)return;
    hk_string delimiter=col_delimiter;
    hk_string between=betweendata;
    if (with_header)
    {

        hk_reportsectionpair* header=e->new_sectionpair();
        hk_string h=delimiter+"%FIELDNAME%";
        h+=delimiter;
        header->headersection()->set_default_reportdata(h);
        header->headersection()->set_betweendata(between);
        header->headersection()->set_sectionend("\n");
        header->headersection()->set_unique();

    }
    hk_reportsection* section=e->datasection();
    hk_string h=delimiter+"%VALUE%";
    h+=delimiter;
    section->set_default_reportdata(h);
    section->set_betweendata(between);
    section->set_sectionend("\n");

}


void automatic_create_csvfields(hk_reportsection* s)
{
    if (!s) return;
    if (!s->report()->datasource()) return;
    hk_reportcsv *rcsv = dynamic_cast<hk_reportcsv*>(s->report());
    if (!rcsv) return;
    list<hk_column*>* cols=s->report()->datasource()->columns();
    if (cols!=NULL)
    {
        list<hk_column*>::iterator cit=cols->begin();
        while (cit!=cols->end())
        {
            hk_reportdata* dat=s->new_data();
            dat->set_columnname((*cit)->name());
            dat->set_data(s->default_reportdata());
            if ((*cit)->columntype()==hk_column::textcolumn || (*cit)->columntype()==hk_column::memocolumn)
            {
                dat->set_beforedata(rcsv->textdelimiter());
                dat->set_afterdata(rcsv->textdelimiter());

            }
            cit++;
        }
    }

}


// XML STUFF

hk_reportxml::hk_reportxml(void):hk_report()
{
    set_recodefunction("UTF8");
    set_default_use_reportseparator(false);
    set_default_reportprecision(0);
    set_use_standard_storagepath(false);
    set_maindocumenttag("table");
    set_rowtag("row");
    set_includetableschema(false);
    p_fieldtag=fieldname;
    configure_page();
}


hk_reportxml::~hk_reportxml(void)
{

}


void hk_reportxml::set_fieldname_as_attribute(enum_fieldtag tag)
{
    p_fieldtag=tag;
    configure_page();

}


hk_reportxml::enum_fieldtag hk_reportxml::fieldname_as_attribute(void)
{
    return p_fieldtag;
}


bool hk_reportxml::set_maindocumenttag(const hk_string& t)
{
    if (t.size()==0) return false;
    p_maindocumenttag=t;
    configure_page();
    return true;

}


hk_string hk_reportxml::maindocumenttag(void)
{
    return p_maindocumenttag;
}


bool hk_reportxml::set_rowtag(const hk_string& t)
{
    if (t.size()==0) return false;
    p_rowtag=t;
    configure_page();
    return true;
}


hk_string hk_reportxml::rowtag(void)
{
    return p_rowtag;
}


void hk_reportxml::configure_page(void)
{
    hk_string header= "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE %DT%>\n<%DT%>\n";
    header=replace_all("%DT%",header,p_maindocumenttag);
    hk_string footer=replace_all("%DT%","</%DT%>\n",p_maindocumenttag);
    hk_reportdata* d=NULL;
    if (page_header()->datalist()->size()==0) d=page_header()->new_data();
    else d=page_header()->data_at(0);
    if (d!=NULL)
    {
        d->set_data(header);
    }

    if (page_footer()->datalist()->size()==0) d=page_footer()->new_data();
    else d=page_footer()->data_at(0);
    if (d!=NULL)
    {
        d->set_data(footer);
    }

    datasection()->set_default_beforereportdata(p_fieldtag==fieldname?"   <%FIELDNAME%>":"   <field NAME=\"%FIELDNAME%\">");
    datasection()->set_default_afterreportdata(p_fieldtag==fieldname?"</%FIELDNAME%>\n":"</field>\n");
    datasection()->set_sectionbegin(replace_all("%RT%","  <%RT%>\n",p_rowtag));
    datasection()->set_sectionend(replace_all("%RT%","  </%RT%>\n",p_rowtag));
    datasection()->set_automatic_create_data(true);
}


void    hk_reportxml::widget_specific_before_execute(void)
{
    setlocale(LC_NUMERIC,"C");
}


void    hk_reportxml::widget_specific_after_execute(void)
{
    setlocale(LC_NUMERIC,locale().c_str());
}


hk_string  recode_utf8(const hk_string& where,hk_report*)
{
    return l2u(where);
}


void hk_reportxml::set_includetableschema(bool i)
{
    p_include_tableschema=i;
}


bool hk_reportxml::includetableschema(void)
{
    return p_include_tableschema;

}


void hk_reportxml::widget_specific_before_last_outstream_closed(void)
{
    if (p_include_tableschema) datasource()->save_datasourcedefinition(*outputstream());
}
