/*
 *      grok.c - Look for datafiles by searching the disk
 *
 *      Allegro-based version
 */

#include <allegro.h>
#include <string.h>
#include <stdlib.h>
#ifndef _WIN32
#include <unistd.h>
#endif
#include "../ithelib.h"
#include "grok.h"

// Defines

#define FNAME_LENGTH 1024

// Variables

static GROKFILES *grkptr=NULL;
static char *grknam;
static char pathstack[4096];
extern char projectname[];

// Functions

static void grok_count(const char *name, int attrib, int addmode);
static void grok_mount(const char *name, int attrib, int addmode);
static void grok_sort(GROKFILES *g);
static int q_string(const void *e1, const void *e2);

// Code

/*
 * Find out how much memory we'll need
 */

void grok_count(const char *name, int attrib, int filemode)
{
errno=0; // prevent abort
if(!strcmp(name,".") || !strcmp(name,".."))
	return;

if(!filemode)
	{
	if(!chdir(name))
		{
		for_each_file("*.*",FA_DIREC,grok_count,0);
		for_each_file(grknam,FA_RDONLY|FA_ARCH,grok_count,1);
		chdir("..");
		}
	}
else
	grkptr->total++;
errno=0; // prevent abort
}

/*
 * Log the files into memory
 */

void grok_mount(const char *name, int attrib, int filemode)
{
int len;
errno=0; // prevent abort
if(!strcmp(name,".") || !strcmp(name,".."))
	return;

if(!filemode)
	{
	if(!chdir(name))
		{
		strcat(pathstack,"/");		// Push onto stack
		strcat(pathstack,name);
		for_each_file("*.*",FA_DIREC,grok_mount,0);
		for_each_file(grknam,FA_RDONLY|FA_ARCH,grok_mount,1);
		*strrchr(pathstack,'/')='\0'; // Pop from stack
		chdir("..");
		}
	}
else
	{
	len=strlen(name)+strlen(&pathstack[1])+2;
	grkptr->list[grkptr->file]=(char *)M_get(1,len);
	strcpy(grkptr->list[grkptr->file],&pathstack[1]); // Skip inital '/'
	strcat(grkptr->list[grkptr->file],"/");
	strcat(grkptr->list[grkptr->file],name);
	grkptr->file++;
	}
errno=0; // prevent abort
}

/*
 * Set case and sort
 */

void grok_sort(GROKFILES *g)
{
int ctr;
for(ctr=0;ctr<g->total;ctr++)
    {
    strupr(g->list[ctr]);
    strslash(g->list[ctr]);
    }
qsort((char **)g->list, (int)g->total, sizeof(char *), q_string);
}

/*
 * Get the information
 */

int grok_files(GROKFILES *g,char **a)
{
char curdir[FNAME_LENGTH];
int ctr;

getcwd(curdir,FNAME_LENGTH);
chdir(projectname);

g->total=0;
g->file=0;
grkptr=g;

for(ctr=0;a[ctr];ctr++)
    if(a[ctr])
		{
		grknam=a[ctr];
		for_each_file("*.*",FA_DIREC,grok_count,0);
		for_each_file(grknam,FA_RDONLY|FA_ARCH,grok_count,1);
		}

if(!g->total)
    {
    chdir(curdir);
	grkptr=NULL;
    return 0;
    }

g->list=(char **)M_get(g->total+1,sizeof(char *));

for(ctr=0;a[ctr];ctr++)
    if(a[ctr])
		{
		pathstack[0]='\0'; // empty stack for mounting
		pathstack[1]='\0'; // catch &pathstack[1] too
		grknam=a[ctr];
		for_each_file("*.*",FA_DIREC,grok_mount,0);
		for_each_file(grknam,FA_RDONLY|FA_ARCH,grok_mount,1);
		}

grok_sort(g);

chdir(curdir);
grkptr=NULL;
return 1;
}

/*
 * clean up afterwards
 */

void grok_free(GROKFILES *g)
{
int ctr;
for(ctr=0;ctr<g->total;ctr++)
    M_free(g->list[ctr]);
M_free(g->list);
g->total=0;
g->file=0;
}

/*
 * helper function for Qsort
 */

int q_string(const void *e1, const void *e2)
{
return strcmp(*(char **)e1, *(char **)e2);
}

