/***************************************************************************
                          dvbstream.h  -  description
                             -------------------
    begin                : Mon Jan 20 2003
    copyright            : (C) 2003-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:25 $ by $Author: juergenk $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBSTREAM_H
#define DVBSTREAM_H

#include <sys/poll.h>
#include <sys/stat.h>

#include <qthread.h>
#include <qptrlist.h>
#include <qfile.h>
#include <qobject.h>
#include <qtimer.h>
#include <qstringlist.h>

#include "channeldesc.h"
#include "dvbout.h"

#define MAX_CHANNELS 8

class DVBevents;



struct diseqc_cmd {
	struct dvb_diseqc_master_cmd cmd;
	uint32_t wait;
};



class DvbStream : public QObject, public QThread
{
	Q_OBJECT

public :

	enum { ErrDontSwitchAudio=-1, ErrCantTune=1, ErrCantSetPids=2, ErrIsRecording=3, ErrNoLive=4, ErrCantOpenFile=5 };
	
	DvbStream( int card, fe_type_t type, QString src );
	~DvbStream();
	void setSources( QString src );
	QStringList getSources();
	bool canSource( ChannelDesc *chan );
	bool tuneDvb( ChannelDesc *chan, bool dvr=true );
	void stopFrontend();
	virtual void run();
	int goLive( ChannelDesc *chan, QString pipeName, int &napid );
	void stopLive( ChannelDesc *chan );
	void stop();
	void stopScan();
	void setScanning( bool b );
	bool hasVideo();
	bool doPause( QString name );
	bool timeShiftMode();
	bool running();
	ChannelDesc getLiveChannel();
	Transponder getCurrentTransponder();
	bool isTuned();
	bool startTimer( ChannelDesc *chan, QString path, RecTimer *t );
	int canStartTimer( bool &live, ChannelDesc *chan );
	bool hasRec();
	bool liveIsRecording();

	unsigned char thBuf[188*10];
	struct pollfd pfd;
	DVBevents *dvbEvents;
	int dvbCard;
	fe_type_t dvbType;

public slots:

	bool checkStatus();
	void receivePlayDvb();
	void recordEnded( DVBout *o, RecTimer *t, bool kill );
	void receiveShifting( bool b );
	void updateTimer( RecTimer *t, int ms );

private :

	int setupSwitch( int switchPos, int voltage18, int hiband );
	int diseqc( fe_sec_voltage_t v, struct diseqc_cmd **cmd, fe_sec_tone_mode_t t, fe_sec_mini_cmd_t b);
	int getSatPos( QString src );
	bool setPids( DVBout *o, int napid=0 );
	void removePids( DVBout *o );
	void removeOut( DVBout *o );
	void recordingState();
	
	QFile liveFile;
	bool timeShifting;
	QPtrList<DVBout> out;
	bool openFe();
	bool closeFe();
	void connectStatus( bool con );
	int waitPause;
	Transponder currentTransponder;

	QString frontendName;
	QString dvrName;
	QString demuxName;
	int fdFrontend;
	int ndmx;
	int fdDvr, fdPipe;
	bool isRunning;
	QTimer statusTimer;
	QString timeShiftFileName;
	QStringList source;

signals:

	void playDvb();
	void isRecording(bool);
	void timerEnded(RecTimer*);

	void errorMsg( QString );
	void snrStatus( int );
	void signalStatus( int );
	void lockStatus( bool );
	void shifting( bool );
	
};

#endif
