/***************************************************************************
                          kevents.h  -  description
                             -------------------
    begin                : Wed Jan 7 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:25 $ by $Author: juergenk $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEVENTS_H
#define KEVENTS_H

#include <qtimer.h>
#include <qdialog.h>
#include <qdatetime.h>
#include <qtextbrowser.h>

#include <klistview.h>
#include <kpushbutton.h>

class EventDesc;
class DVBevents;
class ChannelDesc;



class EventsItem
{

public:

	EventDesc *event;
	KListViewItem *item;
};
	


class KEvents : public QDialog
{
	Q_OBJECT
	
public:

	KEvents( QPtrList<ChannelDesc> *chans, DVBevents *ev, QWidget *parent, QSize size );
	~KEvents();

private slots:

	void checkNewEvent();
	void mouseClickedSlot( int btn, QListViewItem *it, const QPoint &p, int c );
	void reset();
	void setMode( int m, QString name="" );
	void setCurrentNext();

private:

	DVBevents *dvbEvents;
	KListView *listView;
	KPushButton *resetBtn, *currentNextBtn;
	QPtrList<ChannelDesc> *channels;
	QPtrList<EventsItem> evitem;
	int nEvents;
	QTimer checkTimer;
	QTextBrowser *textBrow;
	int mode;
	ChannelDesc *chan;

signals:

	void addTimer( QString channel, QString name, QDateTime begin, QTime duration );
};

#endif
