//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QDataStream;
import org.kde.qt.QPixmap;
import java.util.ArrayList;
import org.kde.qt.QVariant;
import org.kde.qt.QWidget;

/**

 Represent a service, i.e. an application bound to one or several mimetypes
 (or servicetypes) as written in its desktop entry file.
 A service may be a library, too.
 The starting point you need is often the static methods.
 Service types are stored as desktop files in the "service" resource..
		@author Torben Weis <weis@kde.org>
 
		@short    Represent a service, i.
		@see KServiceType
		@see KServiceGroup

*/
public class KService extends KSycocaEntry  {
	protected KService(Class dummy){super((Class) null);}
	/**	
		 Describes the DCOP type of the service.
		
			<li>
			None - This service has no DCOP support
			</li>
			
			<li>
			Unique - This service provides a unique DCOP service.
			              The service name is equal to the desktopEntryName.
			</li>
			
			<li>
			Multi - This service provides a DCOP service which can be run
			             with multiple instances in parallel. The service name of
			             an instance is equal to the desktopEntryName + "-" +
			             the PID of the process.
			</li>
			
			<li>
			Wait - This service has no DCOP support, the launcher will wait
			            till it is finished.
			   
			</li>		@short    Describes the DCOP type of the service.
	*/
	public static final int DCOP_None = 0;
	public static final int DCOP_Unique = 1;
	public static final int DCOP_Multi = 2;
	public static final int DCOP_Wait = 3;

	/**	
		 Construct a temporary service with a given name, exec-line and icon.
			@param _name the name of the service
			@param _exec the executable 
			@param _icon the name of the icon
		   		@short    Construct a temporary service with a given name, exec-line and icon.
	*/
	public KService(String _name, String _exec, String _icon) {
		super((Class) null);
		newKService(_name,_exec,_icon);
	}
	private native void newKService(String _name, String _exec, String _icon);
	/**	
		 Construct a service and take all information from a config file.
			@param _fullpath Full path to the config file.
		   		@short    Construct a service and take all information from a config file.
	*/
	public KService(String _fullpath) {
		super((Class) null);
		newKService(_fullpath);
	}
	private native void newKService(String _fullpath);
	/**	
		 Construct a service and take all information from a desktop file.
			@param config the desktop file to read
		   		@short    Construct a service and take all information from a desktop file.
	*/
	public KService(KDesktopFile config) {
		super((Class) null);
		newKService(config);
	}
	private native void newKService(KDesktopFile config);
	/**	
			 Construct a service from a stream.
		 The stream must already be positionned at the correct offset.
		   		@short
	*/
	public KService(QDataStream _str, int offset) {
		super((Class) null);
		newKService(_str,offset);
	}
	private native void newKService(QDataStream _str, int offset);
	/**	
		 Returns the type of the service.
				@return the type of the service ("Application" or "Service")
   
		@short    Returns the type of the service.
	*/
	public native String type();
	/**	
		 Returns the name of the service.
				@return the name of the service,
         or null if not set
   
		@short    Returns the name of the service.
	*/
	public native String name();
	/**	
		 Returns the executable.
				@return the command that the service executes,
         or null if not set
   
		@short    Returns the executable.
	*/
	public native String exec();
	/**	
		 Returns the name of the service's library.
				@return the name of the library that contains the services
         implementation,
         or null if not set
   
		@short    Returns the name of the service's library.
	*/
	public native String library();
	/**	
		 Returns the name of the init function to call (KControl modules).
				@return the name of the init function to call in this service
         during startup of KDE. (KControl modules only),
         or null if not set
   
		@short    Returns the name of the init function to call (KControl modules).
	*/
	public native String init();
	/**	
		 Returns the name of the icon.
				@return the icon associated with the service,
         or null if not set
   
		@short    Returns the name of the icon.
	*/
	public native String icon();
	/**	
		 Returns the pixmap that represents the icon.
				@return a pixmap for this service (finds and loads icon()),
         null if not set

		@short    Returns the pixmap that represents the icon.
		@see #icon
	*/
	public native QPixmap pixmap(int _group, int _force_size, int _state, StringBuffer _path);
	public native QPixmap pixmap(int _group, int _force_size, int _state);
	public native QPixmap pixmap(int _group, int _force_size);
	public native QPixmap pixmap(int _group);
	/**	
		 Checks whethe the service should be run in a terminal.
				@return true if the service is to be run in a terminal.
   
		@short    Checks whethe the service should be run in a terminal.
	*/
	public native boolean terminal();
	/**	
		 Returns any options associated with the terminal the service
		 runs in, if it requires a terminal.
			 The service must be a tty-oriented program.
				@return the terminal options,
         or null if not set
   
		@short    Returns any options associated with the terminal the service  runs in, if it requires a terminal.
	*/
	public native String terminalOptions();
	/**	
		 Checks whether the service runs with a different user id.
				@return true if the service has to be run under a different uid.

		@short    Checks whether the service runs with a different user id.
		@see #username
	*/
	public native boolean substituteUid();
	/**	
		 Returns the user name, if the service runs with a 
		 different user id.
				@return the username under which the service has to be run,
         or null if not set

		@short    Returns the user name, if the service runs with a   different user id.
		@see #substututeUida
	*/
	public native String username();
	/**	
		 Returns the path to the location where the service desktop entry
		 is stored.
			 This is a relative path if the desktop entry was found in any
		 of the locations pointed to by $KDEDIRS (e.g. "Internet/kppp.desktop")
		 It is a full path if the desktop entry originates from another
		 location.
				@return the path of the service's desktop file,
         or null if not set
   
		@short    Returns the path to the location where the service desktop entry  is stored.
	*/
	public native String desktopEntryPath();
	/**	
		 Returns the filename of the service desktop entry without any
		 extension. E.g. "kppp"
				@return the name of the desktop entry without path or extension,
         or null if not set
   
		@short    Returns the filename of the service desktop entry without any  extension.
	*/
	public native String desktopEntryName();
	/**	
		 Returns the menu ID of the service desktop entry.
		 The menu ID is used to add or remove the entry to a menu.
				@return the menu ID

		@short    Returns the menu ID of the service desktop entry.
	*/
	public native String menuId();
	/**	
		 Returns a normalized ID suitable for storing in configuration files.
		 It will be based on the menu-id when available and otherwise falls
		 back to desktopEntryPath()
				@return the storage ID

		@short    Returns a normalized ID suitable for storing in configuration files.
	*/
	public native String storageId();
	/**	
		 Returns the DCOPServiceType supported by this service.
				@return the DCOPServiceType supported by this service
   
		@short    Returns the DCOPServiceType supported by this service.
	*/
	public native int DCOPServiceType();
	/**	
		 Returns the working directory to run the program in.
				@return the working directory to run the program in,
         or null if not set
   
		@short    Returns the working directory to run the program in.
	*/
	public native String path();
	/**	
		 Returns the descriptive comment for the service, if there is one.
				@return the descriptive comment for the service, or null
         if not set
   
		@short    Returns the descriptive comment for the service, if there is one.
	*/
	public native String comment();
	/**	
		 Returns the generic name for the service, if there is one
		 (e.g. "Mail Client").
				@return the generic name, 
         or null if not set
   
		@short    Returns the generic name for the service, if there is one  (e.
	*/
	public native String genericName();
	/**	
		 Returns the untranslated (US English) generic name 
		 for the service, if there is one
		 (e.g. "Mail Client").
				@return the generic name, 
         or null if not set

		@short    Returns the untranslated (US English) generic name   for the service, if there is one  (e.
	*/
	public native String untranslatedGenericName();
	/**	
		 Returns a list of descriptive keywords the service, if there are any.
				@return the list of keywords
   
		@short    Returns a list of descriptive keywords the service, if there are any.
	*/
	public native ArrayList keywords();
	/**	
		 Returns a list of VFolder categories.
				@return the list of VFolder categories

		@short    Returns a list of VFolder categories.
	*/
	public native ArrayList categories();
	/**	
		 Returns the service types that this service supports.
				@return the list of service types that are supported
   
		@short    Returns the service types that this service supports.
	*/
	public native ArrayList serviceTypes();
	/**	
		 Checks whether the service supports this service type
			@param _service The name of the service type you are
		        interested in determining whether this services supports.
				@return true if the service you specified is supported,
        otherwise false.
   
		@short    Checks whether the service supports this service type
	*/
	public native boolean hasServiceType(String _service);
	/**	
		 Checks whether a service is used as a default setting, for
		         example as plugin in a file manager. Usually that is the 
		         case, but some services may only be started when the user 
		         selected them. This kind of services returns false here.
				@return true if the service may be used as a default setting
   
		@short    Checks whether a service is used as a default setting, for          example as plugin in a file manager.
	*/
	public native boolean allowAsDefault();
	/**	
		 Checks whether this service can handle several files as
		 startup arguments.
				@return true if multiple files may be passed to this service at
 startup. False if only one file at a time may be passed.
   
		@short    Checks whether this service can handle several files as  startup arguments.
	*/
	public native boolean allowMultipleFiles();
	/**	
		 What preference to associate with this service initially (before
		 the user has had any chance to define a profile for it).
		 The bigger the value, the most preferred the service is.
				@return the service preference level of the service
   
		@short    What preference to associate with this service initially (before  the user has had any chance to define a profile for it).
	*/
	public native int initialPreference();
	/**	
		 What preference to associate with this service initially 
		 for handling the specified mimetype. (before the user has
		 had any chance to define a profile for it).
		 The bigger the value, the most preferred the service is.
				@return the service preference level of the service for
 this mimetype
   
		@short    What preference to associate with this service initially   for handling the specified mimetype.
	*/
	public native int initialPreferenceForMimeType(String mimeType);
	/**	
			   		@short
	*/
	public native void setInitialPreference(int i);
	/**	
		 Whether the entry should be suppressed in menus.
				@return true to suppress this service
   
		@short    Whether the entry should be suppressed in menus.
	*/
	public native boolean noDisplay();
	/**	
		 Name of the application this service belongs to.
		 (Useful for e.g. plugins)
				@return the parent application, or null if not set

		@short    Name of the application this service belongs to.
	*/
	public native String parentApp();
	/**	
		 Returns the requested property. Some often used properties
		 have convenience access functions like exec(),
		 serviceTypes etc.
			 It depends upon the serviceTypes() of this service which
		 properties a service can have.
			@param _name the name of the property
				@return the property, or invalid if not found

		@short    Returns the requested property.
		@see KServiceType
	*/
	public native QVariant property(String _name);
	/**	
		 Returns the requested property.
			@param _name the name of the property
			@param t the assumed type of the property
				@return the property, or invalid if not found

		@short    Returns the requested property.
		@see KServiceType
	*/
	public native QVariant property(String _name, int t);
	/**	
		 Returns the list of all properties that this service can have.
		 That means, that some of these properties may be empty.
				@return the list of supported properties
   
		@short    Returns the list of all properties that this service can have.
	*/
	public native ArrayList propertyNames();
	/**	
		 Checks whether the service is valid.
				@return true if the service is valid (e.g. name is not empty)
   
		@short    Checks whether the service is valid.
	*/
	public native boolean isValid();
	/**	
		 Returns a path that can be used for saving changes to this
		 service
				@return path that can be used for saving changes to this service

		@short    Returns a path that can be used for saving changes to this  service
	*/
	public native String locateLocal();
	/**	
			 Load the service from a stream.
		   		@short
	*/
	public native void load(QDataStream arg1);
	/**	
			 Save the service to a stream.
		   		@short
	*/
	public native void save(QDataStream arg1);
	/**	
			 Set the menu id
		   		@short
	*/
	public native void setMenuId(String menuId);
	/**	
			 Sets whether to use a terminal or not
		   		@short
	*/
	public native void setTerminal(boolean b);
	/**	
			 Sets the terminal options to use
		   		@short
	*/
	public native void setTerminalOptions(String options);
	/**	
		 Find a service by name, i.e. the translated Name field. You should
		 really not use this method, since the name is translated.
			@param _name the name to search
				@return a pointer to the requested service or 0 if the service is
         unknown.
 @em Very @em important: Don't store the result in a KService* !
   
		@short    Find a service by name, i.
	*/
	// KService::Ptr serviceByName(const QString& arg1); >>>> NOT CONVERTED
	/**	
		 Find a service based on its path as returned by {@link #desktopEntryPath}.
		 It's usually better to use {@link #serviceByStorageId} instead.
			@param _path the path of the configuration file
				@return a pointer to the requested service or 0 if the service is
         unknown.
 @em Very @em important: Don't store the result in a KService* !
   
		@short    Find a service based on its path as returned by @ref desktopEntryPath().
	*/
	// KService::Ptr serviceByDesktopPath(const QString& arg1); >>>> NOT CONVERTED
	/**	
		 Find a service by the name of its desktop file, not depending on
		 its actual location (as long as it's under the applnk or service
		 directories). For instance "konqbrowser" or "kcookiejar". Note that
		 the ".desktop" extension is implicit.
			 This is the recommended method (safe even if the user moves stuff)
		 but note that it assumes that no two entries have the same filename.
			@param _name the name of the configuration file
				@return a pointer to the requested service or 0 if the service is
         unknown.
 @em Very @em important: Don't store the result in a KService* !
   
		@short    Find a service by the name of its desktop file, not depending on  its actual location (as long as it's under the applnk or service  directories).
	*/
	// KService::Ptr serviceByDesktopName(const QString& arg1); >>>> NOT CONVERTED
	/**	
		 Find a service by its menu-id
			@param _menuId the menu id of the service
				@return a pointer to the requested service or 0 if the service is
         unknown.
 @em Very @em important: Don't store the result in a KService* !

		@short    Find a service by its menu-id
	*/
	// KService::Ptr serviceByMenuId(const QString& arg1); >>>> NOT CONVERTED
	/**	
		 Find a service by its storage-id or desktop-file path. This 
		 function will try very hard to find a matching service.
			@param _storageId the storage id or desktop-file path of the service
				@return a pointer to the requested service or 0 if the service is
         unknown.
 @em Very @em important: Don't store the result in a KService* !

		@short    Find a service by its storage-id or desktop-file path.
	*/
	// KService::Ptr serviceByStorageId(const QString& arg1); >>>> NOT CONVERTED
	/**	
		 Returns the whole list of services.
			  Useful for being able to
		 to display them in a list box, for example.
		 More memory consuming than the ones above, don't use unless
		 really necessary.
				@return the list of all services
   
		@short    Returns the whole list of services.
	*/
	// KService::List allServices(); >>>> NOT CONVERTED
	/**	
		 Returns all services that require initialisation.
			 Only needed by "kcminit"
				@return the list of all services that need to be initialized
   
		@short    Returns all services that require initialisation.
	*/
	// KService::List allInitServices(); >>>> NOT CONVERTED
	/**	 
		 Returns a path that can be used to create a new KService based
		 on <code>suggestedName.</code>
			@param showInMenu true, if the service should be shown in the KDE menu
		        false, if the service should be hidden from the menu
			@param suggestedName name to base the file on, if a service with such 
		        name already exists, a prefix will be added to make it unique.
			@param menuId If provided, menuId will be set to the menu id to use for
		        the KService
			@param reservedMenuIds If provided, the path and menu id will be chosen
		        in such a way that the new menu id does not conflict with any
		        of the reservedMenuIds
				@return The path to use for the new KService.

		@short     Returns a path that can be used to create a new KService based  on <code>suggestedName.</code>
	*/
	public static native String newServicePath(boolean showInMenu, String suggestedName, StringBuffer menuId, String[] reservedMenuIds);
	public static native String newServicePath(boolean showInMenu, String suggestedName, StringBuffer menuId);
	public static native String newServicePath(boolean showInMenu, String suggestedName);
	/**	
		 Rebuild KSycoca and show a progress dialog while doing so.
			@param parent Parent widget for the progress dialog
				@short    Rebuild KSycoca and show a progress dialog while doing so.
	*/
	public static native void rebuildKSycoca(QWidget parent);
	protected native void init(KDesktopFile config);
	protected native ArrayList accessServiceTypes();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
