/*
 * This file defines the SIP library internal interfaces.
 *
 * Copyright (c) 2004
 * 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
 * 
 * This file is part of SIP.
 * 
 * This copy of SIP is licensed for use under the terms of the SIP License
 * Agreement.  See the file LICENSE for more details.
 * 
 * SIP is supplied WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _SIPINT_H
#define	_SIPINT_H


#include <stdarg.h>


#ifdef __cplusplus
extern "C" {
#endif

#undef	TRUE
#define	TRUE		1

#undef	FALSE
#define	FALSE		0


/*
 * This defines a single entry in an object map's hash table.
 */
typedef struct
{
	void *key;			/* The C/C++ address. */
	sipWrapper *first;		/* The first object at this address. */
} sipHashEntry;


/*
 * This defines the interface to a hash table class for mapping C/C++ addresses
 * to the corresponding wrapped Python object.
 */
typedef struct
{
	int primeIdx;			/* Index into table sizes. */
	unsigned long size;		/* Size of hash table. */
	unsigned long unused;		/* Nr. unused in hash table. */
	sipHashEntry *hash_array;	/* Current hash table. */
} sipObjectMap;


extern PyInterpreterState *sipInterpreter;	/* The interpreter. */


#ifdef SIP_QT_SUPPORT
extern sipWrapperType *sipQObjectClass;	/* The Python QObject class. */

void *sipConvertRx(sipProxyFunc spf,sipWrapper *txSelf,const char *sigargs,
		   PyObject *rxObj,const char *slot,const char **memberp);
void *sipGetRx(sipWrapper *txSelf,const char *sigargs,PyObject *rxObj,
	       const char *slot,const char **memberp);
int sip_api_emit_signal(PyObject *self,const char *sig,PyObject *sigargs);
void sip_api_emit_to_slot(void *sender,sipSlot *slot,char *fmt,...);
void *sip_api_get_sender();
PyObject *sip_api_connect_rx(PyObject *txObj,const char *sig,
			     PyObject *rxObj,const char *slot);
PyObject *sip_api_disconnect_rx(PyObject *txObj,const char *sig,
				PyObject *rxObj,const char *slot);
#endif


/*
 * These are part of the SIP API but are also used within the SIP module.
 */
void *sip_api_malloc(size_t nbytes);
void sip_api_free(void *mem);
void *sip_api_get_cpp_ptr(sipWrapper *w,sipWrapperType *type);
PyObject *sip_api_new_cpp_to_self(void *cppPtr,sipWrapperType *type,
				  int initflags);
void sip_api_start_thread(void);
void sip_api_end_thread(void);


/*
 * These are not part of the SIP API but are used within the SIP module.
 */
PyObject *sipBuildObjectTuple(char *fmt,va_list va);
void sipSaveMethod(sipPyMethod *pm,PyObject *meth);
void *sipGetPending(int *fp);

void sipOMInit(sipObjectMap *om);
void sipOMFinalise(sipObjectMap *om);
sipWrapper *sipOMFindObject(sipObjectMap *om,void *key,sipWrapperType *type);
void sipOMAddObject(sipObjectMap *om,sipWrapper *val);
int sipOMRemoveObject(sipObjectMap *om,sipWrapper *val);

void sipSetBool(void *ptr,int val);
int sipWrapper_Check(PyObject *op);


#ifdef __cplusplus
}
#endif

#endif
