/****************************************************************************
** $Id: ABMainWindow.java,v 1.1 2002/02/22 18:13:06 rdale Exp $
**
** Copyright ( C ) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
import org.kde.qt.*;

class ABMainWindow extends QMainWindow
{
    protected QToolBar fileTools;
    protected String filename;
    protected ABCentralWidget view;

public ABMainWindow()
{
    super( null, "example addressbook application" );
    filename = "";
    setupMenuBar();
    setupFileTools();
    setupStatusBar();
    setupCentralWidget();
}

public void setupMenuBar()
{
    QPopupMenu file = new QPopupMenu( this );
    menuBar().insertItem( "&File", file );

    file.insertItem( "New", this, SLOT( "fileNew()" ), new QKeySequence(CTRL + Key_N) );
    file.insertItem( new QIconSet(new QPixmap( "fileopen.xpm" )), "Open", this, SLOT( "fileOpen()" ), new QKeySequence(CTRL + Key_O) );
    file.insertSeparator();
    file.insertItem( new QIconSet(new QPixmap( "filesave.xpm" )), "Save", this, SLOT( "fileSave()" ), new QKeySequence(CTRL + Key_S) );
    file.insertItem( "Save As...", this, SLOT( "fileSaveAs()" ) );
    file.insertSeparator();
    file.insertItem( new QIconSet(new QPixmap( "fileprint.xpm" )), "Print...", this, SLOT( "filePrint()" ), new QKeySequence(CTRL + Key_P) );
    file.insertSeparator();
    file.insertItem( "Close", this, SLOT( "closeWindow()" ), new QKeySequence(CTRL + Key_W) );
    file.insertItem( "Quit", qApp(), SLOT( "quit()" ), new QKeySequence(CTRL + Key_Q) );
}

public void setupFileTools()
{
    //fileTools = new QToolBar( this, "file operations" );
}

public void setupStatusBar()
{
    //statusBar()->message( "Ready", 2000 );
}

public void setupCentralWidget()
{
    view = new ABCentralWidget( this );
    setCentralWidget( view );
}

public void closeWindow()
{
    close();
}

public void fileNew()
{
}

public void fileOpen()
{
    String fn = QFileDialog.getOpenFileName( "", "", this );
    if ( !fn.equals("") ) {
        filename = fn;
        view.load( filename );
    }
}

public void fileSave()
{
    if ( filename.equals("") ) {
        fileSaveAs();
        return;
    }

    view.save( filename );
}

public void fileSaveAs()
{
    String fn = QFileDialog.getSaveFileName( "", "", this );
    if ( !fn.equals("") ) {
        filename = fn;
        fileSave();
    }
}

public void filePrint()
{
}

}
