/*
    This file is part of KitchenSync.

    Copyright (c) 2002 Holger Freyther <zecke@handhelds.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
#ifndef KSYNC_STD_PROGRESS_H
#define KSYNC_STD_PROGRESS_H

#include "progress.h"

namespace KSync {
    struct StdProgress {
        static Progress connection();
        static Progress connected();
        static Progress authenticated();
        static Progress syncing(const QString&);
        static Progress downloading(const QString& );
        static Progress uploading(const QString&);
        static Progress converting(const QString&);
        static Progress reconverting(const QString&);
        static Progress done();
    };
}


#endif
