/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qpainter.h>
#include <qcolor.h>
#include <kdebug.h>
#include "DCanvasItem.h"
#include "DCanvasRef.h"
#include "settings.h"

	DCanvasRef::DCanvasRef(QCanvas* canvas, DCanvasItem* orig)
: DCanvasLink(canvas, orig)
{
	m_orig = orig;
	updateColor();
	show();
}

DCanvasRef::~DCanvasRef()
{
	hide();
}

void DCanvasRef::updateColor()
{
	QPen pen;
	pen.setStyle( DotLine );
	pen.setWidth( m_orig->control()->m_showDirectionSize );

	QBrush brush;
	brush.setStyle( QBrush::Dense5Pattern );
	if ( m_orig->control()->m_reverseVideo )
	{
		brush.setColor( QColor(Qt::white) );
		pen.setColor( QColor(Qt::white) );
	}
	else
	{
		brush.setColor( QColor( m_orig->control()->m_col_ref ) );
		pen.setColor( m_orig->control()->m_col_ref );
	}
	setBrush(brush);
	setPen(pen);
	m_ellipse->setBrush(brush);
	int s = m_orig->control()->m_showDirectionSize;
	m_ellipse->setSize(s+5, s+5);
}

