/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kdebug.h>

#include <qwidget.h>
#include <qstring.h>

#include "DItem.h"
#include "DBase.h"

DBase::DBase(QWidget*, const char*)
{
}

DBase::~DBase()
{
    m_map.clear();
}

DItem* DBase::Item(int id) const
{
    DItem * item = NULL;
    if (isRegistered(id))
	item = m_map[id];
    return item;
}

void DBase::registerItem(DItem *item)
{
    if (!item)
	return;

    int id = item->Id();

    if (isRegistered(id))
	return;

    m_map[id] = item;
}

void DBase::unregisterItem(int id)
{
    DItem * item = NULL;
    if (isRegistered(id))
    {
	item = Item(id);
	m_map.remove(id);
    }

    // auto-delete
    delete item;
}

bool DBase::isRegistered(int id) const
{
    if (Total()>0)
	return m_map.contains(id);
    else
	return 0;
}

int DBase::Total() const
{
    return m_map.count();
}

void DBase::printallids()
{
    QString allids;
    QMapIterator<int, DItem*> it;
    for (it = m_map.begin(); it != m_map.end(); ++it)
    {
	allids += QString::number( (*it)->Id() );
	allids += QString(" ");
    }
    //kdWarning()<<"all ids that belong to this object : "<<this<<endl;
    //kdWarning()<<allids<<endl;
}

