/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KDISSERTPART_H_
#define _KDISSERTPART_H_

#include <kparts/part.h>
#include <kparts/factory.h>

class QWidget;
class QPainter;
class KURL;
class KAboutData;
class KToggleAction;
class DGuiView;
class DCanvasView;
class DTreeListView;
class DDataControl;
class DDataItem;

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Thomas Nagy <tnagytwofivesix@yahoo.fr>
 * @version 0.3.3
 */
class KDissertPart : public KParts::ReadWritePart
{
    Q_OBJECT
    public:
	/**
	 * Default constructor
	 */
	KDissertPart(QWidget *parentWidget, const char *widgetName,
		QObject *parent, const char *name, const QStringList & /*args*/);

	/**
	 * Destructor
	 */
	virtual ~KDissertPart();

	/**
	 * This is a virtual function inherited from KParts::ReadWritePart.  
	 * A shell will use this to inform this Part if it should act
	 * read-only
	 */
	virtual void setReadWrite(bool rw);

	bool openURL(KURL url);

	static KAboutData *createAboutData();

	inline DTreeListView *treeview() {return m_treelistview;}

	/*
	 * Tell the views that the settings have changed
	 */
	void settingsChanged();

	QString m_caption;

    protected:
	/**
	 * This must be implemented by each part
	 */
	virtual bool openFile();

	/**
	 * This must be implemented by each read-write part
	 */
	virtual bool saveFile();

	/**
	 * This queries a file to save the document to
	 */
	bool saveFileAs();

    signals:
	void accessed(const KURL &);
	void stateChanged();
	void itemSelected(DDataItem *);
	void itemChanged(int);

    protected slots:

	/**
	 * Reimplemented to disable and enable Save action
	 */
	virtual void setModified(bool modified);
    	void docProperties();
	void itemChanged(int, DGuiView*);

    private slots:

	void setItemChanged(int);
    	void launchURL(const QString& url, bool usekfmclient);
	void checkFlags();

    public slots:

        /// Switch to point mode, to select mindmap trees
        void setPointMode();

        /// Switch to link mode, to link mindmap items
        void setLinkMode();

        /// Switch to sort mode, to sort mindmap trees
        void setSortMode();

        /// Switch to scroll mode, to navigate in the mindmap view
        void setScrollMode();

        /// remove all mindmap items
        void clearDocument();

	void slotFileOpen();
	void slotFileSave();
	void slotFileSaveAs();

        /*
         * This method calls the document generators
         */
        void generateDocument();

        /*
         * This method is used to take a snapshot of the mindmap
         * view as a png file
         */
        void savePic();

	void zoomIn();
	void zoomOut();
	void setZoom(int zoom);

    private:

	/// This object holds the mindmap view
	DCanvasView* m_canvasview;
	/// This object holds the tree view
	DTreeListView* m_treelistview;
	/// This object handles the mindmap data
	DDataControl* m_data;

	/// keep the save action ready
	KAction* m_saveAction;

	int m_lastid;
	
	KToggleAction *m_warning, *m_good, *m_idea, *m_work, *m_clarify, *m_question, *m_trash, *m_meeting, *m_trouble;
};

#endif // _KDISSERTPART_H_

