/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _DTREELISTVIEW_H
#define _DTREELISTVIEW_H

#include <qpixmap.h>
#include <qvaluelist.h>

#include <klistview.h>

#include "../gui/DGuiItem.h"
#include "../gui/DGuiView.h"
#include "../datastruct/DItem.h"

class QDragEnterEvent;
class QMouseEvent;
class QDropEvent;
class QDragObject;
class DTreeListPopup;
class DTreeListTip;
/**
 * This class is a linear view for the mindmap
 *
 * @short Mindmap linear view
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DTreeListView : public KListView, public DGuiView
{
	Q_OBJECT

	public:
		DTreeListView( QWidget* parent=0, const char* name=0 );
		~DTreeListView();

	private:
		DTreeListPopup* m_menu;
		DTreeListTip*   m_tip;

		void plug();
		void unplug();

	public slots:
		void settingsChanged();
		void updateItem(int);
		void createItem(int);
		void removeItem(int);
		void updateSelectedItem(int, DGuiView*);

		void changeSelection();

		void applyChoice(int id);
		void contentsMousePressEvent(QMouseEvent* me);

	public:
		void keyPressEvent(QKeyEvent *);

	protected slots:
		void changeRef(int, int, bool add=true);
		void applyMoved( QListViewItem *, QListViewItem * afterFirst, QListViewItem * afterNow );
};

#endif // _DTREELISTVIEW_H

