import os
import os.path
import string
import sys
import tempfile
from SCons.Platform.posix import exitvalmap
import SCons.Action
import SCons.Util
class TempFileMunge:
    """ """
    def __init__(self, cmd):
        self.cmd=cmd
    def __call__(self, target, source, env, for_signature):
        if for_signature:
            return self.cmd
        cmd=env.subst_list(self.cmd, 0, target, source)[0]
        try:
            maxline=int(env.subst('$MAXLINELENGTH'))
        except ValueError:
            maxline=2048
        if (reduce(lambda x, y: x + len(y), cmd, 0) + len(cmd)) <= maxline:
            return self.cmd
        else:
            tmp=os.path.normpath(tempfile.mktemp('.lnk'))
            native_tmp=SCons.Util.get_native_path(tmp)
            if env['SHELL'] and env['SHELL']=='sh':
                native_tmp=string.replace(native_tmp, '\\', r'\\\\')
                rm=env.Detect('rm') or 'del'
            else:
                rm='del'
            args=map(SCons.Util.quote_spaces, cmd[1:])
            open(tmp, 'w').write(string.join(args, " ") + "\n")
            if SCons.Action.print_actions:
                print("Using tempfile "+native_tmp+" for command line:\n"+
                      str(cmd[0]) + " " + string.join(args," "))
            return [ cmd[0], '@' + native_tmp + '\n' + rm, native_tmp ]
def piped_spawn(sh, escape, cmd, args, env, stdout, stderr):
    if not sh:
        sys.stderr.write("scons: Could not find command interpreter, is it in your PATH?\n")
        return 127
    else:
        tmpFileStdout=os.path.normpath(tempfile.mktemp())
        tmpFileStderr=os.path.normpath(tempfile.mktemp())
        stdoutRedirected=0
        stderrRedirected=0
        for arg in args:
            if (string.find( arg, ">", 0, 1 ) != -1 or
                string.find( arg, "1>", 0, 2 ) != -1):
                stdoutRedirected=1
            if string.find( arg, "2>", 0, 2 ) != -1:
                stderrRedirected=1
        if stdoutRedirected==0:
            args.append(">" + str(tmpFileStdout))
        if stderrRedirected==0:
            args.append("2>" + str(tmpFileStderr))
        try:
            args=[sh, '/C', escape(string.join(args)) ]
            ret=os.spawnve(os.P_WAIT, sh, args, env)
        except OSError, e:
            ret=exitvalmap[e[0]]
            if stderr != None:
                stderr.write("scons: %s: %s\n" % (cmd, e[1]))
        if stdout != None and stdoutRedirected==0:
            try:
                stdout.write(open( tmpFileStdout, "r" ).read())
                os.remove( tmpFileStdout )
            except (IOError, OSError):
                pass
        if stderr != None and stderrRedirected==0:
            try:
                stderr.write(open( tmpFileStderr, "r" ).read())
                os.remove( tmpFileStderr )
            except (IOError, OSError):
                pass
        return ret
def spawn(sh, escape, cmd, args, env):
    if not sh:
        sys.stderr.write("scons: Could not find command interpreter, is it in your PATH?\n")
        return 127
    else:
        try:
            args=[sh, '/C', escape(string.join(args)) ]
            ret=os.spawnve(os.P_WAIT, sh, args, env)
        except OSError, e:
            ret=exitvalmap[e[0]]
            sys.stderr.write("scons: %s: %s\n" % (cmd, e[1]))
        return ret
escape=lambda x: '"' + x + '"'
def get_system_root():
    try:
        val=os.environ['SYSTEMROOT']
    except KeyError:
        val="C:/WINDOWS"
        pass
    if SCons.Util.can_read_reg:
        try:
            k=SCons.Util.RegOpenKeyEx(SCons.Util.hkey_mod.HKEY_LOCAL_MACHINE,
                                      'Software\\Microsoft\\Windows NT\\CurrentVersion')
            val, tok=SCons.Util.RegQueryValueEx(k, 'SystemRoot')
        except SCons.Util.RegError:
            try:
                k=SCons.Util.RegOpenKeyEx(SCons.Util.hkey_mod.HKEY_LOCAL_MACHINE,
                                          'Software\\Microsoft\\Windows\\CurrentVersion')
                val, tok=SCons.Util.RegQueryValueEx(k, 'SystemRoot')
            except KeyboardInterrupt:
                raise
            except:
                pass
    return val
def get_program_files_dir():
    val=''
    if SCons.Util.can_read_reg:
        try:
            k=SCons.Util.RegOpenKeyEx(SCons.Util.hkey_mod.HKEY_LOCAL_MACHINE,
                                      'Software\\Microsoft\\Windows\\CurrentVersion')
            val, tok=SCons.Util.RegQueryValueEx(k, 'ProgramFilesDir')
        except SCons.Util.RegError:
            val=''
            pass
    if val=='':
        val=os.path.join(os.path.dirname(get_system_root()),"Program Files")
        
    return val
def generate(env):
    cmd_interp=''
    if SCons.Util.can_read_reg:
        try:
            k=SCons.Util.RegOpenKeyEx(SCons.Util.hkey_mod.HKEY_LOCAL_MACHINE,
                                          'Software\\Microsoft\\Windows NT\\CurrentVersion')
            val, tok=SCons.Util.RegQueryValueEx(k, 'SystemRoot')
            cmd_interp=os.path.join(val, 'System32\\cmd.exe')
        except SCons.Util.RegError:
            try:
                k=SCons.Util.RegOpenKeyEx(SCons.Util.hkey_mod.HKEY_LOCAL_MACHINE,
                                              'Software\\Microsoft\\Windows\\CurrentVersion')
                val, tok=SCons.Util.RegQueryValueEx(k, 'SystemRoot')
                cmd_interp=os.path.join(val, 'command.com')
            except KeyboardInterrupt:
                raise
            except:
                pass
    if not cmd_interp:
        systemroot=r'C:\Windows'
        if os.environ.has_key('SYSTEMROOT'):
            systemroot=os.environ['SYSTEMROOT']
        tmp_path=systemroot + os.pathsep + \
                   os.path.join(systemroot,'System32')
        tmp_pathext='.com;.exe;.bat;.cmd'
        if os.environ.has_key('PATHEXT'):
            tmp_pathext=os.environ['PATHEXT'] 
        cmd_interp=SCons.Util.WhereIs('cmd', tmp_path, tmp_pathext)
        if not cmd_interp:
            cmd_interp=SCons.Util.WhereIs('command', tmp_path, tmp_pathext)
    if not cmd_interp:
        cmd_interp=env.Detect('cmd')
        if not cmd_interp:
            cmd_interp=env.Detect('command')
    
    if not env.has_key('ENV'):
        env['ENV']       ={}
    import_env=[ 'SYSTEMROOT' ]
    for var in import_env:
        v=os.environ.get(var)
        if v:
            env['ENV'][var]=v
    env['ENV']['PATHEXT']='.COM;.EXE;.BAT;.CMD'
    env['OBJPREFIX']     =''
    env['OBJSUFFIX']     ='.obj'
    env['SHOBJPREFIX']   ='$OBJPREFIX'
    env['SHOBJSUFFIX']   ='$OBJSUFFIX'
    env['PROGPREFIX']    =''
    env['PROGSUFFIX']    ='.exe'
    env['LIBPREFIX']     =''
    env['LIBSUFFIX']     ='.lib'
    env['SHLIBPREFIX']   =''
    env['SHLIBSUFFIX']   ='.dll'
    env['LIBPREFIXES']   =[ '$LIBPREFIX' ]
    env['LIBSUFFIXES']   =[ '$LIBSUFFIX' ]
    env['PSPAWN']        =piped_spawn
    env['SPAWN']         =spawn
    env['SHELL']         =cmd_interp
    env['TEMPFILE']      =TempFileMunge
    env['MAXLINELENGTH'] =2048
    env['ESCAPE']        =escape
