import re
import string
import SCons.Node
import SCons.Node.FS
import SCons.Scanner
import SCons.Util
import SCons.Warnings
class F90Scanner(SCons.Scanner.Classic):
    """ """
    def __init__(self, name, suffixes, path_variable, use_regex,
                 incl_regex, fs=SCons.Node.FS.default_fs, *args, **kw):
        self.cre_use=re.compile(use_regex, re.M)
        self.cre_incl=re.compile(incl_regex, re.M)
        self.fs=fs
        def _scan(node, env, path, self=self, fs=fs):
            return self.scan(node, env, path)
        kw['function']=_scan
        kw['path_function']=SCons.Scanner.FindPathDirs(path_variable, fs)
        kw['recursive']=1
        kw['skeys']=suffixes
        kw['name']=name
        apply(SCons.Scanner.Current.__init__, (self,) + args, kw)
    def scan(self, node, env, path=()):
        node=node.rfile()
        if not node.exists():
            return []
        if node.includes != None:
            mods_and_includes=node.includes
        else:
            includes=self.cre_incl.findall(node.get_contents())
            modules=self.cre_use.findall(node.get_contents())
            suffix=env.subst('$FORTRANMODSUFFIX')
            modules=map(lambda x, s=suffix: string.lower(x) + s, modules)
            mods_and_includes=SCons.Util.unique(includes+modules)
            node.includes=mods_and_includes
        nodes=[]
        source_dir=node.get_dir()
        for dep in mods_and_includes:
            n, i=self.find_include(dep, source_dir, path)
            if not n is None:
                nodes.append(n)
            else:
                SCons.Warnings.warn(SCons.Warnings.DependencyWarning,
                                    "No dependency generated for file: %s (referenced by: %s) -- file not found" % (i, node))
        def st(List, Metric):
            def pairing(element, M=Metric):
                return (M(element), element)
            def stripit(pair):
                return pair[1]
            paired=map(pairing, List)
            paired.sort()
            return map(stripit, paired)
        def normalize(node):
            return SCons.Node.FS._my_normcase(str(node))
        transformed=st(nodes, normalize)
        return transformed
def FortranScan(path_variable="FORTRANPATH", fs=SCons.Node.FS.default_fs):
    """ """
    use_regex="(?i)(?:^|;)\s*USE(?:\s+|(?:(?:\s*,\s*(?:NON_)?INTRINSIC)?\s*::))\s*(\w+)"
    include_regex="""(?i)(?:^|['">]\s*;)\s*INCLUDE\s+(?:\w+_)?[<"'](.+?)(?=["'>])"""
    scanner=F90Scanner("FortranScan",
                         "$FORTRANSUFFIXES",
                         path_variable,
                         use_regex,
                         include_regex,
                         fs=fs)
    return scanner
