__version__="0.96.1"
__build__="D001"
__buildsys__="casablanca"
__date__="2004/08/23 09:55:29"
__developer__="knight"
import os
import os.path
import sys
import time
script_dir=sys.path[0]
if script_dir in sys.path:
    sys.path.remove(script_dir)
libs=[]
if os.environ.has_key("SCONS_LIB_DIR"):
    libs.append(os.environ["SCONS_LIB_DIR"])
local='scons-local-' + __version__
if script_dir:
    local=os.path.join(script_dir, local)
libs.append(local)
scons_version='scons-%s' % __version__
prefs=[]
if sys.platform=='win32':
    prefs.append(sys.prefix)
    prefs.append(os.path.join(sys.prefix, 'Lib', 'site-packages'))
else:
    if script_dir=='bin':
        prefs.append(os.getcwd())
    else:
        if script_dir=='.' or script_dir=='':
            script_dir=os.getcwd()
        head, tail=os.path.split(script_dir)
        if tail=="bin":
            prefs.append(head)
    head, tail=os.path.split(sys.prefix)
    if tail=="usr":
        prefs.append(sys.prefix)
        prefs.append(os.path.join(sys.prefix, "local"))
    elif tail=="local":
        h, t=os.path.split(head)
        if t=="usr":
            prefs.append(sys.prefix)
            prefs.append(head)
        else:
            prefs.append(sys.prefix)
    else:
        prefs.append(sys.prefix)
    temp=map(lambda x: os.path.join(x, 'lib'), prefs)
    temp.extend(map(lambda x: os.path.join(x,
                                           'lib',
                                           'python' + sys.version[:3],
                                           'site-packages'),
                           prefs))
    prefs=temp
libs.extend(map(lambda x: os.path.join(x, scons_version), prefs))
libs.extend(map(lambda x: os.path.join(x, 'scons'), prefs))
sys.path=libs + sys.path
import cPickle
import imp
import string
import whichdb
import SCons.SConsign
def my_whichdb(filename):
    try:
        f=open(filename + ".dblite", "rb")
        f.close()
        return "SCons.dblite"
    except IOError:
        pass
    return _orig_whichdb(filename)
_orig_whichdb=whichdb.whichdb
whichdb.whichdb=my_whichdb
def my_import(mname):
    if '.' in mname:
        i=string.rfind(mname, '.')
        parent=my_import(mname[:i])
        fp, pathname, description=imp.find_module(mname[i+1:],
                                                    parent.__path__)
    else:
        fp, pathname, description=imp.find_module(mname)
    return imp.load_module(mname, fp, pathname, description)
class Flagger:
    default_value=1
    def __setitem__(self, item, value):
        self.__dict__[item]=value
        self.default_value=0
    def __getitem__(self, item):
        return self.__dict__.get(item, self.default_value)
Do_Call=None
Print_Directories=[]
Print_Entries=[]
Print_Flags=Flagger()
Verbose=0
Readable=0
def default_mapper(entry, name):
    try:
        val=eval("entry."+name)
    except:
        val=None
    return str(val)
def map_timestamp(entry, name):
    try:
        timestamp=entry.timestamp
    except AttributeError:
        timestamp=None
    if Readable and timestamp:
        return "'" + time.ctime(timestamp) + "'"
    else:
        return str(timestamp)
def map_bkids(entry, name):
    try:
        bkids=entry.bsources + entry.bdepends + entry.bimplicit
        bkidsigs=entry.bsourcesigs + entry.bdependsigs + entry.bimplicitsigs
    except AttributeError:
        return None
    result=[]
    for i in xrange(len(bkids)):
        result.append("%s: %s" % (bkids[i], bkidsigs[i]))
    if result==[]:
        return None
    return string.join(result, "\n        ")
map_field={
    'timestamp' : map_timestamp,
    'bkids'     : map_bkids,
}
map_name={
    'implicit'  : 'bkids',
}
def printfield(name, entry):
    def field(name, verbose=Verbose, entry=entry):
        if not Print_Flags[name]:
            return None
        fieldname=map_name.get(name, name)
        mapper=map_field.get(fieldname, default_mapper)
        val=mapper(entry, name)
        if verbose:
            val=name + ": " + val
        return val
    fieldlist=["timestamp", "bsig", "csig"]
    outlist=[name+":"] + filter(None, map(field, fieldlist))
    sep=Verbose and "\n    " or " "
    print string.join(outlist, sep)
    outlist=field("implicit", 0)
    if outlist:
        if Verbose:
            print "    implicit:"
        print "        " + outlist
def printentries(entries):
    if Print_Entries:
        for name in Print_Entries:
            try:
                entry=entries[name]
            except KeyError:
                sys.stderr.write("sconsign: no entry `%s' in `%s'\n" % (name, args[0]))
            else:
                printfield(name, entry)
    else:
        for name, e in entries.items():
            printfield(name, e)
class Do_SConsignDB:
    def __init__(self, dbm_name, dbm):
        self.dbm_name=dbm_name
        self.dbm=dbm
    def __call__(self, fname):
        try:
            db=self.dbm.open(fname, "r")
        except (IOError, OSError), e:
            print_e=e
            try:
                db=self.dbm.open(os.path.splitext(fname)[0], "r")
            except (IOError, OSError):
                try:
                    open(fname, "r")
                except (IOError, OSError), e:
                    print_e=e
                sys.stderr.write("sconsign: %s\n" % (print_e))
                return
        except:
            sys.stderr.write("sconsign: ignoring invalid `%s' file `%s'\n" % (self.dbm_name, fname))
            return
        if Print_Directories:
            for dir in Print_Directories:
                try:
                    val=db[dir]
                except KeyError:
                    sys.stderr.write("sconsign: no dir `%s' in `%s'\n" % (dir, args[0]))
                else:
                    self.printentries(dir, val)
        else:
            keys=db.keys()
            keys.sort()
            for dir in keys:
                self.printentries(dir, db[dir])
    def printentries(self, dir, val):
        print '=== ' + dir + ':'
        printentries(cPickle.loads(val))
def Do_SConsignDir(name):
    try:
        fp=open(name, 'rb')
    except (IOError, OSError), e:
        sys.stderr.write("sconsign: %s\n" % (e))
        return
    try:
        sconsign=SCons.SConsign.Dir(fp)
    except:
        sys.stderr.write("sconsign: ignoring invalid .sconsign file `%s'\n" % name)
        return
    printentries(sconsign.entries)
import getopt
helpstr="""\
Usage: sconsign [OPTIONS] FILE [...]
Options:
  -b, --bsig                  Print build signature information.
  -c, --csig                  Print content signature information.
  -d DIR, --dir=DIR           Print only info about DIR.
  -e ENTRY, --entry=ENTRY     Print only info about ENTRY.
  -f FORMAT, --format=FORMAT  FILE is in the specified FORMAT.
  -h, --help                  Print this message and exit.
  -i, --implicit              Print implicit dependency information.
  -r, --readable              Print timestamps in human-readable form.
  -t, --timestamp             Print timestamp information.
  -v, --verbose               Verbose, describe each field.
""" """
