/***************************************************************************
                  challenge_graph_view.cpp  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2003 by Eric Faccer
    email                : e.faccer@qut.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string>
#include <qpoint.h>
#include <qstring.h>

#include "challenge_graph_view.moc"

#include "challenge_graph.h"
#include "challenge_rectangle.h"

///////////////////////////////////////
//
//	Challenge_Graph_View::Constructor
//
///////////////////////////////////////
Challenge_Graph_View::Challenge_Graph_View(QCanvas& c, QWidget * parent,const char* name, WFlags f, QLabel *qsb)
 : QCanvasView(&c,parent,name,f), canvas(c), statusbar(qsb)
{
	setHScrollBarMode( QScrollView::AlwaysOff );
	setVScrollBarMode( QScrollView::AlwaysOff );

	if ( parent )
		parent->installEventFilter( this );
	QScrollView::viewport()->setMouseTracking(true);
}
///////////////////////////////////////
//
//	Challenge_Graph_View::Destructor
//
///////////////////////////////////////
Challenge_Graph_View::~Challenge_Graph_View()
{
}
///////////////////////////////////////
//
//	Challenge_Graph_View::contentsMousePressEvent
//
///////////////////////////////////////
void Challenge_Graph_View::contentsMousePressEvent(QMouseEvent* e)
{
	QCanvasItemList l = canvas.collisions(e->pos());
	QCanvasItemList::Iterator it = l.begin();
	for(; it != l.end(); ++it )
	{
		Challenge_Rectangle *cr = dynamic_cast<Challenge_Rectangle *>(*it);
		Challenge_Game *g = cr->getGame();
		if( e->button() == Qt::LeftButton )
			emit leftClick( g->id() );
		if( e->button() == Qt::RightButton )
			emit rightClick( g, e->globalPos() );
		return;
	}
	if( e->button() == Qt::RightButton )
		emit rightClick( NULL, e->globalPos() ); // We need to catch all right clicks
}
///////////////////////////////////////
//
//	Challenge_Graph_View::reset
//
///////////////////////////////////////
void Challenge_Graph_View::reset()
{
	QCanvasItemList list = canvas.allItems();
	QCanvasItemList::Iterator it = list.begin();
	for(; it != list.end(); ++it )
	{
		Challenge_Rectangle *cr = dynamic_cast<Challenge_Rectangle *>(*it);
		Challenge_Game *g = cr->getGame();
		delete g;
		if ( *it )
			delete *it;
	}
}
///////////////////////////////////////
//
//	Challenge_Graph_View::contentsMouseMoveEvent
//
///////////////////////////////////////
void Challenge_Graph_View::contentsMouseMoveEvent(QMouseEvent* e)
{
	QString match;
	QCanvasItemList l = canvas.collisions(e->pos());
	QCanvasItemList::Iterator it = l.begin();
	for(; it!=l.end(); ++it)
	{
		Challenge_Rectangle *cr = dynamic_cast<Challenge_Rectangle *>(*it);
		Challenge_Game *g = cr->getGame();

		match = i18n( " Name: %1 Rating: %2 Match Type: %3 %4 Base Time: %5 Increment: %6" )
								.arg( g->_player ).arg( g->rating() ).arg( g->_match_type ).arg( g->_is_rated )
								.arg( g->clock() ).arg( g->increment() );
		break;
	}
	statusbar->setText( match );
}

