/***************************************************************************
                          dlg_settings.h  -  description
                             -------------------
    begin                : Mon Jul 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLG_SETTINGS_H
#define DLG_SETTINGS_H

#include <klocale.h>
#include <kdialogbase.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qvbox.h>
#include "definitions.h"
#include "resource.h"

class setPageDisplay;
class setPageAudio;
class setPageEngines;
class setPageServers;
class setPageGeneral;

/**
  *@author Troy Corbin Jr.
  */

class dlg_settings : public KDialogBase
{
   Q_OBJECT
	public:
													dlg_settings(QWidget *parent=0, const char *name=0, resource *Rsrc=0);
													~dlg_settings();

	public slots:
		void									slotOk( void );
		void									slotApply( void );
		void									slotCancel( void );
		void									slotEnableApply( void );
		void									slotThemesAdded( void );
		void									slotPageChanging( QWidget* );

	signals:
		void									themeChanged( int, int );
		void									redrawBoard( void );
		void									rebuildConsole( void );
		void									resetServer( void );

	private:
		resource							*Resource;

		QFrame								*FRAME_General;
		setPageGeneral				*PAGE_General;

		QFrame								*FRAME_Display;
		setPageDisplay				*PAGE_Display;

		QFrame								*FRAME_Audio;
		setPageAudio					*PAGE_Audio;
		
		QFrame								*FRAME_Engines;
		setPageEngines				*PAGE_Engines;
		
		QFrame								*FRAME_Servers;
		setPageServers				*PAGE_Servers;
};

#endif
