/***************************************************************************
                          match.h  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MATCH_H
#define MATCH_H

#include <qwidget.h>
#include "resource.h"
#include "match_param.h"
#include "command.h"
#include "chessclock.h"
#include "logic.h"
#include "pgn.h"

class board_base;

class match : public QWidget
{
   Q_OBJECT

	private:
		resource			*Resource;
		board_base		*Board;
		pgn						*Record;
		logic					*Logic;
		chessclock		*Clock;
		ChessMove			chessMove;
		ChessMove			preMove;
		bool					preMoved;
		bool					Modified;
		bool					Paused;
		bool					Loading;
		bool					JustMoved;
		bool					Current;
		int						myID;
		int						StatusCode;
		int						loadTimer;
		QString				StatusMessage;
		char					ICSGameMode;
		char					Draw_Offered[2];

	public:
									match(QWidget *parent, match_param *param, resource *Rsrc);
									~match();
		char					inputOnMove( bool reverse=FALSE );
		char					input( char army );
		QString				url( void );
		void					flip( void );
		void					retract( void );
		void					requestHint( void );
		void					recvCMD( const Command &cmd );
		void					setVisibility( const bool vis );
		void					setPaused( const bool State );
									/* Inline Function */
		int						getID( void )
												{ return myID; }
		void					setID( const int &ID )
												{ myID = ID; }
		QString				caption( void )
												{ return Record->caption(); }
		char					onMove( void )
												{ return Logic->OnMove; }
		bool					modified( void )
												{ return Modified; }
		bool					paused( void )
												{ return Paused; }
		bool					flag( const bool &Army )
												{ return Clock->Flag[Army]; }
		void					setCurrent( const bool &State )
												{ Current = State; }
		void					print( void )
												{ Record->print(); }
		bool					loading( void )
												{ return Loading; }
		int						centiseconds( const bool &Army )
												{ return Clock->getCentiseconds( Army ); }
		QStringList*	notation( void )
												{ return Record->notation(); }
		void					setModified( const bool &state )
												{ Modified = state; }
		void					resendStatusBar( void )
												{ emit setStatusBar( StatusCode, StatusMessage ); }
		match_param*	getParam( void )
												{ return Record->Param; }

	public slots:
		void					tick( void );
		void					resize( void );
		void					redraw( void );
		QString				clock( bool );
		bool					save( QString );
		bool					load( const QString URL, const int pos=0 );
		void					loadSpecial( void );
		void					slot_Select( int );
		void					slot_Preview( int );
		void					slot_flagFell( const bool );
		void					review( const int );
		void					parseMatchParam( void );
		void					saveStatusBar( const int &ID, const QString &MSG )
												{ StatusCode = ID; StatusMessage = MSG; }

	protected slots:
		bool					move( ChessMove );

	signals:
		void					setNotation( void );
		void					setClocks( void );
		void					setStatusBar( const int &ID, const QString &MSG=QString::null );
		void					sendCMD( const Command& );

	protected:
		bool					move( void );
		void					clearSelections( void );
		void					drawPosition( const int );
		void					playSound( const int );
		void					_retract( void );
};

#endif
