h25401
s 00001/00001/00160
d D 1.13 00/11/04 22:11:16 nitehawk 14 13
c Fix bug in allocdescriptor with extra closing bracket
cC
cHwinghove.1ststep.net
cK24691
cZ-08:00
e
s 00002/00002/00159
d D 1.12 00/08/26 19:52:48 nitehawk 13 12
c convert all logging calls into logmsg
cC
cK24659
e
s 00003/00003/00158
d D 1.11 00/07/23 09:51:51 nitehawk 12 11
c Change inline functions to use KPRODINLINE
cC
cHlocalhost.1ststep.net
cK23447
cZ-07:00
e
s 00000/00000/00161
d D 1.10 00/03/07 11:48:12 nitehawk 11 10
c Turn on SCCS flag
cC
cK18321
cX0xa1
e
s 00022/00000/00139
d D 1.9 00/02/23 23:24:04 nitehawk 10 9
c Add wrapper function for realloc
cC
cK22871
e
s 00041/00001/00098
d D 1.8 00/02/23 23:02:58 nitehawk 9 8
c Added wrappers for malloc and free to do basic memory stats tracking
cK47785
e
s 00000/00000/00099
d D 1.7 00/02/12 10:05:29 nitehawk 8 7
c Rename: lib/memory.c -> lib/koala/memory.c
cC
cK63755
cPlib/koala/memory.c
e
s 00000/00000/00099
d D 1.6 00/02/07 23:55:22 nitehawk 7 6
c Rename: src/memory.c -> lib/memory.c
cC
cK32184
cPlib/memory.c
e
s 00001/00001/00098
d D 1.5 00/01/30 13:36:30 nitehawk 6 5
c Updated to use new list data pointer union
cC
cK43115
e
s 00001/00001/00098
d D 1.4 00/01/29 13:13:48 nitehawk 5 4
c Use allocdescriptor to allocate memory for dummy descriptor
cC
cK43934
e
s 00051/00000/00048
d D 1.3 00/01/23 20:33:31 nitehawk 4 3
c Added functions for descriptor memory managment
cC
cK44780
e
s 00029/00001/00019
d D 1.2 00/01/11 22:07:24 nitehawk 3 2
c Added getdescriptorlist to retrieve descriptor linked list
cC
cK16662
e
s 00020/00000/00000
d D 1.1 00/01/11 21:10:11 nitehawk 2 1
cF1
cK32234
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/01/11 21:10:11 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/memory.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK34449
cPsrc/memory.c
cR20faa67bef0d0318
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

#define _KOALAMUD_MEMORY_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
D 3
#include "network.h"
E 3
#include "log.h"
#include "conf.h"
I 3
#include "memory.h"
E 3
#include "llist.h"
I 3
#include "network.h"

listnodeptr masterdescriptorlist = NULL;
I 4
listnodeptr freedescriptorlist = NULL;
I 9
memstate_t memstate[ALLOC_LISTEND];
E 9
E 4

listnodeptr getdescriptorlist(void)
{
	pdescriptor dummydesc = NULL;

	if (masterdescriptorlist)
		return masterdescriptorlist;

	/* Create descriptor for use as list head of new list */
D 5
	if ((dummydesc = malloc(sizeof(descriptor))) == NULL)
E 5
I 5
	if ((dummydesc = allocdescriptor()) == NULL)
E 5
	{
D 13
		logerr("Unable to allocate memory for master descriptor list");
E 13
I 13
		logmsg(LOGCRIT, "Unable to allocate memory for master descriptor list");
E 13
		return NULL;
	}

	dummydesc->type = DESCRIPTOR_DUMMY;

	masterdescriptorlist = listcreate(dummydesc);

	if (masterdescriptorlist == NULL)
	{
		free(dummydesc);
	}
E 3

I 3
	return masterdescriptorlist;
I 4
}

/* (re)Allocate and null out new descriptor */
pdescriptor allocdescriptor(void)
{
	pdescriptor desc = NULL;

	/* Check to see if the free list is allocated */
	if (freedescriptorlist != NULL)
	{
		/* Since we have a list of free descriptors, we will try to allocate
		 * the descriptor from the free list
		 */
D 6
		desc = (pdescriptor)freedescriptorlist->data;
E 6
I 6
		desc = freedescriptorlist->data.desc;
E 6
		if (desc != NULL)
		{
			listremovenode(freedescriptorlist, desc);
		}
D 14
	}
E 14
I 14
	} 
E 14

	if (desc == NULL)
	{
		/* Guess there were no free nodes */
D 9
		desc = (pdescriptor)malloc(sizeof(descriptor));
E 9
I 9
		desc = (pdescriptor)kmalloc(sizeof(descriptor), ALLOC_DESCRIPTOR);
E 9
		if (desc == NULL)
		{
D 13
			logerr("Error allocating memory for new descriptor");
E 13
I 13
			logmsg(LOGCRIT, "Error allocating memory for new descriptor");
E 13
			return NULL;
		}
	}

	/* Zero out allocated memory */
	bzero(desc, sizeof(descriptor));

	return desc;
}

/* Free an allocated descriptor (add the descriptor to the free list) */
void freedescriptor(pdescriptor desc)
{
	/* Allocate the list if it hasn't been allocated */
	if (freedescriptorlist == NULL)
	{
		freedescriptorlist = listcreate(desc);
	}
	/* Add the node to the list otherwise */
	else
	{
		listaddnode(freedescriptorlist, desc);
I 9
	}
}

/* kmalloc - Wrapper around malloc to do size tracking */
D 12
inline void *kmalloc(size_t len, kmalloctype type)
E 12
I 12
KPRODINLINE void *kmalloc(size_t len, kmalloctype type)
E 12
{
	void *mem;
	if ((mem = malloc(len)) == NULL)
	{
		return NULL;
	}

	memstate[type].allocsize += len;
	memstate[type].numobjects++;
	return mem;
}

/* kmfree - Wrapper around free to do size tracking */
D 12
inline void kmfree(void *ptr, kmalloctype type)
E 12
I 12
KPRODINLINE void kmfree(void *ptr, kmalloctype type)
E 12
{
	size_t freed;
	freed = memstate[type].allocsize / memstate[type].numobjects--;
	memstate[type].allocsize -= freed;
	if (memstate[type].numobjects == 0)
	{
		memstate[type].allocsize = 0;
	}
	free(ptr);
}

I 10
/* krealloc - Wrapper around realloc to do memory tracking */
D 12
inline void *krealloc(void *ptr, size_t len, kmalloctype type)
E 12
I 12
KPRODINLINE void *krealloc(void *ptr, size_t len, kmalloctype type)
E 12
{
	void *mem;
	size_t freed;
	freed = memstate[type].allocsize / memstate[type].numobjects--;
	memstate[type].allocsize -= freed;
	if (memstate[type].numobjects == 0)
	{
		memstate[type].allocsize = 0;
	}

	if ((mem = realloc(ptr, len)) == NULL)
	{
		return NULL;
	}

	memstate[type].allocsize += len;
	memstate[type].numobjects++;
	return mem;
}

E 10
/* Init memory state tracking - Automatically called before main */
void initmemstate(void)
{
	int i = 0;

	for (;i< ALLOC_LISTEND; i++)
	{
		memstate[i].allocsize = 0;
		memstate[i].numobjects = 0;
E 9
	}
E 4
}
E 3
E 2
I 1
E 1
