/***************************************************************************
                          dcddlg.cpp  -  description
                             -------------------
    begin                : Sat Aug 12 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcddlg.h"

#include <klocale.h>

#include "globals.h"
#include "server/server.h"

dcdDlg::dcdDlg(QWidget *parent, int ch, int level) : QDialog(parent)
{
  channel=ch;
  if (channel==COMM_RXCH)
		setCaption (i18n("DCD - Main Channel"));
  if (channel==COMM_RXCH+1)
		setCaption (i18n("DCD - Channel 1"));
  if (channel==COMM_RXCH+2)
		setCaption (i18n("DCD - Channel 2"));
  if (channel==COMM_RXCH+3)
		setCaption (i18n("DCD - Channel 3"));

	slider = new QSlider (-1, 100, 1, level, Qt::Horizontal, this);
  slider->setTickmarks (QSlider::Below);
  slider->setTickInterval (10);
  slider->setFixedWidth (250);
	setFixedWidth (slider->width() + 10);
	setFixedHeight (slider->height() +10);
	slider->move (5,5);
	QObject::connect (slider, SIGNAL (valueChanged (int)), this, SLOT (slotDCDChanged (int)));
}

dcdDlg::~dcdDlg()
{
}

void dcdDlg::slotDCDChanged (int value)
{
	if (channel==COMM_RXCH)
		config.psk31.dcdLevel = value;
  commControl (channel, COMM_DCDLEVEL, value);
}
