/***************************************************************************
                          globals.h  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>

#include "logbook.h"
#include "logcore.h"
#include "kpsk.h"
#include "waterfall.h"

extern Kpsk *kpsk;         /* our KTMainWindow */
extern logBook* logbook;   /* The Logbook display */
extern int OPTnew;				 /* use new receiver */
extern waterfall* water;	 /* Waterfall */
extern logCore* logdb;     /* Logbook database */

typedef struct {
	QString audioDevice;
	QString pttDevice;
	int centerFreq;
  int freq1;
	int dcdLevel;
  bool net;
	bool afc;
  bool cwid;
} s_psk31;

typedef struct {
	int band;
	bool qsoinfo;
  bool callchex;
} s_logbook;

typedef struct {
  QString band[12];
	double offset[12];
	bool lsb[12];
} s_band;

typedef struct {
	QSize size;
	QValueList<int> splitter;
	QFont txwinfont;
	QFont rxwinfont;
} s_screen;

typedef struct {
  QColor rx;
  QColor tx;
} s_rxwincolor;


typedef struct {
  bool color_water;  // color waterfall?
  QColor zero;
  QColor vlow;
  QColor low;
  QColor mid;
  QColor hmid;
  QColor high;
  QColor vhigh;
} s_h2oColor;

typedef struct {
  QColor rxb;
  QColor txb;
} s_bkground;

typedef struct {
	QString label[12];
	QString text[12];
} s_fixtext;

typedef struct {
	QString call;
	QString name;
	QString qth;
	QString loc;
} s_personals;

typedef struct {
	s_personals personals;
	s_psk31 psk31;
	s_screen screen;
	s_fixtext fixtext;
	s_rxwincolor rxwincolor;
	s_band band;
	s_logbook logbook;
  s_h2oColor h2oColor;
  s_bkground bkground;
} s_config;

extern s_config config;
