/***************************************************************************
                       cdf.h  -  CDF data source
                             -------------------
    begin                : 17/06/2004
    copyright            : (C) 2004 Nicolas Brisset <nicodev@users.sourceforge.net>
    email                : kst@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDF_H
#define CDF_H

#include <kstdatasource.h>
#include <cdf.h>


class CdfSource : public KstDataSource {
  public:
    CdfSource(KConfig *cfg, const QString& filename, const QString& type);

    virtual ~CdfSource();

    virtual bool initFile();

    virtual KstObject::UpdateType update(int = -1);

    virtual int readField(double *v, const QString& field, int s, int n);

    virtual bool isValidField(const QString& field) const;

    virtual int samplesPerFrame(const QString& field);

    virtual int frameCount(const QString& field = QString::null) const;

    virtual QString fileType() const;

    virtual void save(QTextStream &ts, const QString& indent = QString::null);

    virtual bool isEmpty() const;

  private:
    QMap<QString,int> _frameCounts;
    int _maxFrameCount;
};


#endif
// vim: ts=2 sw=2 et
