/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xgdocker.h"
#include "xeobject.h"
#include "xematrix.h"

#include <qevent.h>
#include <qdragobject.h> 
#include <qsizepolicy.h>
#include <qtimer.h>
#include <qpainter.h> 
#include <qimage.h>
#include <qdatetime.h> 
#include <qwidget.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qfont.h>
#include <qcolor.h>
#include <krootpixmap.h>

#include <xeplugin_gepillow.h>

#include <klocale.h>
#include <kstandarddirs.h>
#include <kmainwindow.h>
#include <kicontheme.h>
#include <kwin.h>
#include <kmainwindow.h>
#include <kpopupmenu.h>
#include <kapplication.h>

#include <netwm.h>

#include <time.h>
#include <unistd.h>
#include <stdlib.h>

#include "xgdocker.moc"

XGDocker::XGDocker(QWidget *parent, const char *name)
 : QWidget(0, name
 //)
 ,WStyle_StaysOnTop 
 //|   WStyle_Customize 
 |  WRepaintNoErase
 | WStyle_NoBorder 
 //| WDestructiveClose 
 ////  |Qt::WState_OwnSizePolicy 
  )
{
	Matrix=NULL;
	Configurator=NULL;
	tMouseMoved=NULL;
	tAutoHideTimer=NULL;
	tAutoSendBGTimer=NULL;
//	tAutoSendFGTimer=NULL;
	tDrawPillow=NULL;
	KDesktopBackground=NULL;
	for(int i=0; i< MAX_ICONS;i++)activeIcons[i]=NULL;
	activeIconsCounter=0;
	
	// Draw issue
	if(parent)
	{
		// Warning this widget cannot be parented
	}
	
	// XD System Wide installation
	XEObject::xSetEngineDocker(this);
	// Setup the Style for this widget:
	setBackgroundMode(Qt::NoBackground,Qt::NoBackground);
	KWin::setType(winId(), NET::Dock);
	//KWin::setType(winId(), NET::Override);
	
	KWin::setState( winId(), NET::StaysOnTop );
	NETWinInfo* info;
	info = new NETWinInfo( qt_xdisplay(), winId(), qt_xrootwin(), NET::WMState );
	info->setDesktop( NETWinInfo::OnAllDesktops);
	// Enable the mouseMoveEvent( QMouseEvent *e )
	setMouseTracking (true);
	setFocusPolicy(QWidget::StrongFocus);
	setSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
	//setFixedSize(0,0);
	xReset();
	AxisAreInverted=0;
	setAcceptDrops(TRUE);
	
}


XGDocker::~XGDocker()
{
}




/*!
    \fn XGDocker::xCfgChanged(QObject *XECfgObject)
 */
void XGDocker::xCfgChanged(QObject *XECfgObject)
{
	// We are going to get the new conf from configurator
	XEConfiguration *NewConfigurator=(XEConfiguration *)XECfgObject;
	if(NewConfigurator==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"falling back to ActiveConfiguration");
#endif
		// return;
	}
	else
	{
		ActiveConfiguration=NewConfigurator->xGetConfiguration();
	}
	if(ActiveConfiguration==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"error while searching for configuration data");
#endif
		return;
	}
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"appling new configuration");
#endif
	
	/// @todo Dont do Resize
	applyCfg();
}


/*!
    \fn XGDocker::xReset()
 */
void XGDocker::xReset()
{
	// Reset all data
	LayoutPosition=LONBOTTOM;
	ActiveConfiguration=NULL;
	lastButtonStatus=Qt::NoButton;
	lastIconDrag=NULL;
	req.tv_nsec=0;
	req.tv_sec=0;
	//lastRaise=2;
	isRaised=0;
	isAnimating=0;
	lastRaise=0;
	xLastX=0;
	xLastY=0;
	xLastX_real=xLastX;
	xLastY_real=xLastY;	
#ifdef ENABLE_SPECIALENGINE2
	xLastX_notmanaged=xLastX;
	xLastY_notmanaged=xLastY;
#endif
	isAnimating=0;
	xDesignVirtualYMatrix=0;
	lastRaise=0;
	lastIcon=0;
	lastIconActivated=0;
	RefreshMask=0;

	
	if(KDesktopBackground==NULL)
	{
		KDesktopBackground=new KRootPixmap((QWidget*)this);
		connect(KDesktopBackground, 
		SIGNAL(backgroundUpdated(const QPixmap &)), 
		this, SLOT(backgroundUpdated(const QPixmap &)));
		KDesktopBackground->setCustomPainting(true);
	}
	if(tMouseMoved==NULL)
	{
		tMouseMoved=new QTimer(this);
		connect(tMouseMoved,SIGNAL(timeout()),this,SLOT(xIRQ_MouseTimeout()));
	}

	if(tAutoHideTimer==NULL)
	{
		tAutoHideTimer=new QTimer(this);
		connect(tAutoHideTimer,SIGNAL(timeout()),
			this,SLOT(xHide()));
	}
	if(tAutoSendBGTimer==NULL)
	{
		tAutoSendBGTimer=new QTimer(this);
		connect(tAutoSendBGTimer,SIGNAL(timeout()),
			this,SLOT(xSendToBackground()));
	}
/*	if(tAutoSendFGTimer==NULL)
	{
		tAutoSendFGTimer=new QTime(this);
	}
	*/
	if(tDrawPillow==NULL)
	{
		tDrawPillow=new QTimer(this);
		connect(tDrawPillow,SIGNAL(timeout()),
			this,SLOT(xDrawPillow()));
	}
	
	
}


/*!
    \fn XGDocker::xSetup()
 */
void XGDocker::xSetup()
{
	// Query for last configuration
	Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	
	Matrix=(XEMatrix *)XEObject::xGetMatrix();
	
	applyCfg();
	
	// 0.26 Apply xSetup on all modules Icons
	for(long int iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
		activeIcons[iconIndex]->xSetupClass();
	}

	
}


/*!
    \fn XGDocker::xStart()
 */
void XGDocker::xStart()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"xStart()");
#endif
	Busy.unlock();
	xUpdate();
	showRaised();
	KDesktopBackground->start();
	//grabMouse();
	
	// 0.26 Apply xStart on all modules Icons
	for(long int iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
		activeIcons[iconIndex]->xStartClass();
	}
	
}


/*!
    \fn XGDocker::xStop()
 */
void XGDocker::xStop()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"xStop()");
#endif
	hide();
	KDesktopBackground->stop();
	//releaseMouse();

}

/*!
    \fn XGDocker::mouseMoveEvent( QMouseEvent *e )
 */
void XGDocker::mouseMoveEvent( QMouseEvent *e )
{
#ifdef ENABLE_SPECIALENGINE2
#ifndef ENABLE_FINAL
	qWarning("Engine2: 276");
#endif
	if(cacheBusy.tryLock()==false)return;
	{	
	/*
	xLastX_notmanaged=x;
	xLastY_notmanaged=y;
	*/
#ifndef ENABLE_FINAL
		qWarning("QTimer::singleShot(1,this,SLOT(purgeCacheMovements()));");
#endif
//		QTimer::singleShot(1,this,SLOT(purgeCacheMovements()));
		if(ActiveConfiguration->Window.SendToBackground)
		{
			//if(tAutoSendFGTimer->restart()>
			// we have to raise it!!!
			show();
		}
		isAnimating=1;
		purgeCacheMovements();
	}
	return;
#endif
	int x=e->pos().x();
	int y=e->pos().y();
	
	// Do you like to interrupt animations ?
	// if(isAnimating)return;
	
	funz1=&XGDocker::mouseMoveEventSW;
	
	//mouseMoveEventSW(x,y,0,lastButtonStatus);
	(this->*funz1)(x,y,0,lastButtonStatus);
	xUpdate();
	
#ifdef ENABLE_REPAINT
	repaint(false);
#else
	repaint(false);
	// Ok than anyone like repaint...
	// update();
#endif

	
}


/*!
    \fn XGDocker::xUpdate(int EnableTransparency=0)
 */
void XGDocker::xUpdate(int EnableTransparency, int pass)
{
	// CleanUP code PASS 1 (20040404)
	
	// Ok is software call ?
	// like the Smoothing past engine?
	if(pass==0)
	{
		// if it's raised we have to do some work
		if(isRaised>0)
		{
			// Emit Mouse Moved Signal to track mouse!
			int fakeWY=0;
			tMouseMoved->start(ActiveConfiguration->Engine.SmoothTimeout);
			// Are we changing the state of the widget?
			if(lastRaise!=isRaised)
			{
				// Grab the new FAKE background, because we are raising over the windows
				int fakeH=height()-ActiveConfiguration->Window.HeightDesktop;
				fakeWY=y();
				if(LayoutPosition==LONTOP)
				{
					fakeWY=fakeWY+ActiveConfiguration->Window.HeightDesktop;
				}
				imgWindow=PixmapConverter.convertToImage(
					QPixmap::grabWindow(
					QApplication::desktop()->winId(), 
					x(), fakeWY,
					width(),fakeH
					)
					)
					;
					
				// After grabbed the window
				// we raise the dock with new mask
				setMask(maskFull);
				//qWarning("xgdocker.cpp:385");
				// Lock the mouse to have a good smooth
				grabMouse();
				// Software update with manual background refresh
				if(lastRaise>=0)
				{
#ifndef ENABLE_FINAL
					qWarning("xgdocker.cpp:389 You are showing the window");
#endif
					/*
					bitBlt(&paintBuffer,
						0,
						0,
						&imgWindow,0,Qt::CopyROP);
					*/
					imgFakeBackground=imgWindow;
				}
				else
				{
					// it's a desktop
					/*
					bitBlt(&paintBuffer,
						0,
						0,
						&imgBackground,0,Qt::CopyROP);
					*/
#ifndef ENABLE_FINAL
					qWarning("xgdocker.cpp:403 You are showing the desktop");
#endif					
					/*
					paintBuffer.fill(0);
					repaint(false);
					sleep(1);
					*/
					imgFakeBackground=imgBackground;
				}
				// save the state
				lastRaise=isRaised;
			}
			// starting paint background
			// new patch 20040602
			// to avoid transparency error
			
			/*
			bitBlt(&paintBuffer,
					0,
					0,
					&imgFakeBackground,0,Qt::CopyROP);
			*/
			int fakeY=0;
			int fakeBY=ActiveConfiguration->Window.HeightDesktop;
			if(LayoutPosition==LONBOTTOM)
			{
				fakeY=height()-ActiveConfiguration->Window.HeightDesktop;
				fakeBY=0;
			}
			bitBlt(&imgFakeBackgroundGlobal,
					0,
					fakeBY,
					&imgFakeBackground,0,Qt::CopyROP);
			bitBlt(&imgFakeBackgroundGlobal,
				0,
				fakeY,
				&imgBackground,0,fakeY,
				ActiveConfiguration->Window.Width,
				ActiveConfiguration->Window.HeightDesktop
				,Qt::CopyROP);
		}
		else
		{
			// we are closed simpli release resources
			if(lastRaise!=isRaised)
			{
				lastRaise=isRaised;
				//xEventReset(xLastX,xLastY);
				releaseMouse();
				setMask(maskBackground);
			}
		}
	}
	/*
	else
	{
	}
	*/
	nanosleep(&req,&rem);
	xUpdateDrawBackground();
	// Painting the FAKE WINDOW!!!!
	/*
	bitBlt(&paintBuffer,
			0,
			0,
			&imgFakeBackgroundGlobal,Qt::CopyROP);
	// sleeping to avoid 100% CPU
	// draw background bar
	int xBar=activeIcons[0]->xPosition.x();
	int yBar=activeIcons[0]->xPosDefault.y()-8;
	int dxBar=activeIcons[activeIconsCounter-1]->xPosition.x()-
			activeIcons[0]->xPosition.x()+
			activeIcons[activeIconsCounter-1]->xZoom;
	int dyBar=ActiveConfiguration->Icons.Size+16;
	bitBlt(&paintBuffer,
			xBar,
			yBar,
			&backgroundBar.xImgSource,
			xBar,
			0,
			dxBar,
			dyBar,Qt::CopyROP);
	bitBlt(&paintBuffer,
			xBar-ActiveConfiguration->Icons.Size-16,
			yBar,
			&backgroundBarLeft.xImgSource,
			0,Qt::CopyROP);
	
	bitBlt(&paintBuffer,
			xBar+dxBar,
			yBar,
			&backgroundBarRight.xImgSource,
			0,Qt::CopyROP);
	*/
	for(long int iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
	/*
		if(activeIcons[iconIndex].xSetUpdate>0)
		{
			//activeIcons[iconIndex].imgShowed=activeIcons[iconIndex].imgSource;
			activeIcons[iconIndex].xTransparency=
				activeIcons[iconIndex].xImgShowed.createAlphaMask();;

			//RefreshMask=1;
		}
	*/
		bitBlt(&paintBuffer,
			activeIcons[iconIndex]->xPosition.x(),
			activeIcons[iconIndex]->xPosition.y(),
			&activeIcons[iconIndex]->xImgShowed,0,Qt::CopyROP);
		// Drawing arrow
		// TODO: we are polling status of icon from configuration data it may be null
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.TaskInfo!=NULL)
		{
			
			bitBlt(&paintBuffer,
				activeIcons[iconIndex]->xPosition.x()
				+activeIcons[iconIndex]->xZoom/2
				-ActiveConfiguration->Icons.Size/2,
				activeIcons[iconIndex]->xPosDefault.y(),
				&activeIcons[iconIndex]->xImgArrow,0,Qt::CopyROP);
			}
		}
	/*
	if(RefreshMask>0)
	{
		maskBuffer.fill(Qt::color0);
		
		
		for(long int iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
		{

		bitBlt(&maskBuffer,
			activeIcons[iconIndex]->xPosition.x(),
			activeIcons[iconIndex]->xPosition.y(),
			//&activeIcons[iconIndex].xTransparency,0,Qt::CopyROP);
			&activeIcons[iconIndex]->xTransparency,0,Qt::AndROP);

		}
		// Fake Desktop Patch 02162004 _rev 2
		bitBlt(&maskBuffer,
			0,
			ActiveConfiguration->Window.Height-ActiveConfiguration->Window.HeightDesktop,
			&this->fakeDesktop,0,Qt::CopyROP);
		//setMask(maskBuffer);
		//setMask(newFakeDesktop);
		//qApp->syncX();
		RefreshMask=0;
	}
	*/
	xUpdateDrawBackgroundPass2();
	
}


/*!
    \fn XGDocker::paintEvent( QPaintEvent *e)
 */
void XGDocker::paintEvent( QPaintEvent *e)
{
	QRect rect = e->rect();
	int l=rect.left();
	int t=rect.top();
	int w=rect.width();
	int h=rect.height();
	bitBlt(this,
		l,
		t,
		&paintBuffer,
		l,t,w,h,
		Qt::CopyROP);
	//bitBlt(this,0,0,&paintBuffer,0,Qt::CopyROP);
}


/*!
    \fn XGDocker::applyCfg()
 */
void XGDocker::applyCfg()
{
	req.tv_nsec=ActiveConfiguration->Engine.SleepFPS*1000;
	req.tv_sec=0;

#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"configuration ready");
	char pippo[50];
	sprintf(pippo,"w:%d h:%d top:%d left:%d actual w:%d, h:%d",
			ActiveConfiguration->Window.Width,
			ActiveConfiguration->Window.Height,
			ActiveConfiguration->Window.Top,
			ActiveConfiguration->Window.Left,
			width(),
			height()
		);
	xWarningMsg(this,pippo);
	
#endif
	
	// patch 18042004 check out the align
	if(strcmp(ActiveConfiguration->Window.Align,"none")==0)
	{
		LayoutPosition=LONBOTTOM;
	}
	if(strcmp(ActiveConfiguration->Window.Align,"bottom")==0)
	{
		LayoutPosition=LONBOTTOM;
		// bug fix for size >48px
		ActiveConfiguration->Window.Width=
			(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation)
			*(ActiveConfiguration->ObjectsIcons.count()+4+ActiveConfiguration->Matrix.DesignDMoltiplier)
			+
			ActiveConfiguration->Matrix.KMatrix[(ActiveConfiguration->Matrix.sizeMatrix*2-1)]
			*2*ActiveConfiguration->Matrix.DesignXMoltiplier
			+ActiveConfiguration->Window.borderLeft*2;
		//ActiveConfiguration->Window.Width=QApplication::desktop()->width()+256;
		//if(ActiveConfiguration->Window.HeightDesktop!=0)
		//{
			// align the desktop size
			ActiveConfiguration->Window.HeightDesktop=ActiveConfiguration->Icons.Size+16;
		//}
	}
	if(strcmp(ActiveConfiguration->Window.Align,"top")==0)
	{
		LayoutPosition=LONTOP;
		ActiveConfiguration->Window.Width=
			(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation)
			*(ActiveConfiguration->ObjectsIcons.count()+4+ActiveConfiguration->Matrix.DesignDMoltiplier)
			+
			ActiveConfiguration->Matrix.KMatrix[(ActiveConfiguration->Matrix.sizeMatrix*2-1)]*2*ActiveConfiguration->Matrix.DesignXMoltiplier
			+ActiveConfiguration->Window.borderLeft*2;
		//if(ActiveConfiguration->Window.HeightDesktop!=0)
		//{
			// align the desktop size
			ActiveConfiguration->Window.HeightDesktop=ActiveConfiguration->Icons.Size+16;
		//}
	}
	
	XGIcon::ActiveConfiguration=ActiveConfiguration;
	// application height
	ActiveConfiguration->Window.Height=
		ActiveConfiguration->Icons.Size+
		16+
		(ActiveConfiguration->Icons.SizeBig
		-
		ActiveConfiguration->Icons.Size
		)/2+
		abs(ActiveConfiguration->Icons.Raise)
		;
		// 0.21 pillow is going to be removed
		//+XGIcon::xGetFontHeight();
		//+32;
	
	if(LayoutPosition==LONTOP)
	{
		ActiveConfiguration->Window.borderTop=8;
	}
	if(LayoutPosition==LONBOTTOM)
	{
		ActiveConfiguration->Window.borderTop=
			//ActiveConfiguration->Icons.Size+
			8+
			(ActiveConfiguration->Icons.SizeBig
			-
			ActiveConfiguration->Icons.Size
			)/2+
			abs(ActiveConfiguration->Icons.Raise)
			;
	}
	ActiveConfiguration->Window.borderLeft=
		ActiveConfiguration->Matrix.KMatrix
			//[ActiveConfiguration->Matrix.sizeMatrix*2-1];
			[0]
			+ActiveConfiguration->Icons.Size+16;
	
	imgBackground.create(ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,32);
	imgFakeBackgroundGlobal.create(ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,32);
	paintBuffer.create(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height,32);
	maskBackground.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskBuffer.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskBackground.fill(Qt::color0);
	maskFull.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskFull.fill(Qt::color1);
	
	fakeDesktop.resize(ActiveConfiguration->Window.Width,ActiveConfiguration->Window.HeightDesktop);
	
	fakeDesktop.fill(Qt::color1);
	
	maskBuffer.fill(Qt::color0);


	// Load - Reload Icons
	if(activeIconsCounter>0)// && activeIcons!=NULL)
	{
		#ifndef ENABLE_FINAL
			xWarningMsg(this,"destroy old icons");	
		#endif
		// Destroy old icons
		for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
		{
			if(activeIcons[iconIndex]==NULL)continue;
			delete activeIcons[iconIndex];
		}	
		activeIconsCounter=0;
	}
	
		// Loading defaults icons
		//XGIcon::ActiveConfiguration=ActiveConfiguration;
		for(uint iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
		{
			if(iconIndex>MAX_ICONS)break;
			iconAdd(ActiveConfiguration->ObjectsIcons.at(iconIndex));
//			ActiveConfiguration->Engine.StaticIconsShowed++;
			if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className!="GIcon")
			{
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="GSeparator")
				{
					// it's a separator:
					// disable the Y and other factors
					activeIcons[activeIconsCounter-1]->xExclude=1;
					// Than we check for a right png configuration
					// is done on 
					// changeBackground(ActiveConfiguration->Theme.BackgroundPath);
				}
#ifndef ENABLE_FINAL
	qWarning("XEObject::xFindObject(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className);");
	qWarning(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className);
#endif
	QObject *GClass=XEObject::xFindObject(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className);
				if(GClass==NULL)continue;
#ifndef ENABLE_FINAL
			qWarning("xgdocker.cpp:637");
			qWarning("activeIcons[activeIconsCounter-1]->xSetClass(GClass);");
#endif
				
				activeIcons[activeIconsCounter-1]->xSetClass(GClass);
			}
#ifndef ENABLE_FINAL
			qWarning("xgdocker.cpp:591");
#endif
		}
		
	// New Engine with separators 11 May 2004
	// Creating the Background must be done at end
	changeBackground(ActiveConfiguration->Theme.BackgroundPath);
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:598");
#endif
	xDesignVirtualYMatrix=activeIcons[0]->xHotspot.y();
	
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:601");
#endif
	QString PoofName=ActiveConfiguration->Theme.PoofPath;
	PoofName=PoofName+"/poof.png";

	QFile a(::locate("data",PoofName));
	if(!a.exists() || PoofName==QString::null)
	{
		PoofName="kxdocker/themes/poof/poof.png";
	}
	ActiveConfiguration->Theme.Poof.load(::locate("data",PoofName));
	
	// patch for external pillow
	xPillow=(QWidget *)XEObject::xFindObject("xPillow");
	
	polish();
}


/*!
    \fn XGDocker::backgroundUpdated (const QPixmap &pm)
 */
void XGDocker::backgroundUpdated (const QPixmap &pm)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"desktop update");	
#endif
	// setMask(this->maskFull);
	// move(0,0);
	//return;
	//imgBackground=pm.convertToImage();
	imgBackground=PixmapConverter.convertToImage(pm);
	int fakeY=0;
	if(LayoutPosition==LONBOTTOM)
	{
		fakeY=height()-ActiveConfiguration->Window.HeightDesktop;
	}
	bitBlt(&imgFakeBackgroundGlobal,
				0,
				fakeY,
				&imgBackground,0,height()-ActiveConfiguration->Window.HeightDesktop,
				ActiveConfiguration->Window.Width,
				ActiveConfiguration->Window.HeightDesktop
				,Qt::CopyROP);
	
	//xUpdate();
	polish();
	
	repaint(false);
}


/*!
    \fn XGDocker::xIRQ_MouseTimeout()
 */
void XGDocker::xIRQ_MouseTimeout()
{
	//lower();
	tMouseMoved->stop();
	tAutoHideTimer->stop();
	//tDrawPillow->stop();
	//isRaised=0;
	//setMask(maskBuffer);
	//releaseMouse();
	
	xUpdateSmooth();
	
	if(lastIcon>=0 && lastIcon<activeIconsCounter)
	{
		activeIcons[lastIcon]->xSetIntensity(0.1);
		activeIcons[lastIcon]->xStartAnimating();
		if(lastIconActivated!=lastIcon)
		{
			activeIcons[lastIcon]->xStopAnimating();
			lastIconActivated=lastIcon;
		}
	}
	
	xUpdate(0,1);
	/*	
	if(lastIcon>=0 && lastIcon<activeIconsCounter && isRaised)
	{
		bitBlt(&paintBuffer,activeIcons[lastIcon]->xPosition.x()+
			activeIcons[lastIcon]->xTextDecentre,0,&activeIcons[lastIcon]->xImgText,
			0,
			Qt::CopyROP);
	}
	*/
	// fix for transparency
	repaint(false);
	//repaint(true);
	
	for(int i=0;i<activeIconsCounter ;i++)
	{
		if(activeIcons[i]->xPillow)activeIcons[i]->xPillow->hide();
	}
	
	if(!isAnimating)xDrawPillow();
	if(isRaised)
	{
#ifdef ENABLE_SPECIALENGINE3
#else	
		QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations*10
			,this,SLOT(xIRQ_Reset()));
#endif	
		// TODO: pillow must be an external widget
		// like plugins!!!
		/*
		if(!isAnimating && mouseMoveTimeElapsed.elapsed()>1000)QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations*10
			,this,SLOT(xDrawPillow()));
		*/
		//if(!isAnimating)tDrawPillow->start(1000);
		
	}
	else
	{
		// AutoHideTimer
#ifndef ENABLE_FINAL
		qWarning("xgdocker.cpp:627");
#endif
		if(ActiveConfiguration->Window.HideTimeout>0)
		{
#ifndef ENABLE_FINAL
			qWarning("xgdocker.cpp:630");
#endif
			tAutoHideTimer->start(
				ActiveConfiguration->Window.HideTimeout * 1000
			);
		}
	}
}


/*!
    \fn XGDocker::mousePressEvent( QMouseEvent *e )
 */
void XGDocker::mousePressEvent( QMouseEvent *e )
{
	lastButtonStatus=e->button();
	releaseMouse();
	Busy.lock();
	int x=e->pos().x();
	int y=e->pos().y();
	int b=e->button();
	int iconNum=(x-ActiveConfiguration->Window.borderLeft)
		/
		(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	xEventMouseClick(iconNum,x,y,b);
	//if(isRaised)QTimer::singleShot(500,this,SLOT(xIRQ_Reset()));
	//xBliz();
	//grabMouse();
	Busy.unlock();
	return;
}


/*!
    \fn XGDocker::maskGenerareBigFake()
 */
void XGDocker::maskGenerareBigFake()
{
	// 28/02/2004 smooth mask
	maskBackground.fill(Qt::color0);
	int fakeY=0;
	int fakeH=ActiveConfiguration->Window.HeightDesktop;

	if(LayoutPosition==LONBOTTOM)
	{
		fakeY=ActiveConfiguration->Window.Height-ActiveConfiguration->Window.HeightDesktop;
		fakeH=ActiveConfiguration->Window.HeightDesktop;
	}
	bitBlt(&maskBackground,
			activeIcons[0]->xPosition.x(),
			fakeY,
			&fakeDesktop,0,0,
			activeIcons[activeIconsCounter-1]->xPosition.x()-
			activeIcons[0]->xPosition.x()+
			ActiveConfiguration->Icons.Size,
			fakeH
			,Qt::CopyROP);
	bitBlt(&maskBackground,
			activeIcons[0]->xPosition.x()-ActiveConfiguration->Icons.Size-16,
			fakeY,
			&backgroundBarLeft.xTransparency,
			0,Qt::CopyROP);
	
	bitBlt(&maskBackground,
			activeIcons[activeIconsCounter-1]->xPosition.x()
				+ActiveConfiguration->Icons.Size,
			fakeY,
			&backgroundBarRight.xTransparency,
			0,Qt::CopyROP);
			
	if(!isRaised)setMask(maskBackground);
}


/*!
    \fn XGDocker::getObjectIcon(int i)
 */
XGIcon * XGDocker::getObjectIcon(int i)
{
#ifndef ENABLE_FINAL
	char pippo[50];
	sprintf(pippo,"XGDocker::getObjectIcon(int %d)",i);
	qWarning(pippo);
#endif
	if(i<0||i>=activeIconsCounter)return NULL;
#ifndef ENABLE_FINAL
	sprintf(pippo,"XGDocker::getObjectIcon(int %d) -> %d",i,activeIcons[i]->xZoom);
	qWarning(pippo);
#endif
	return activeIcons[i];
}


/*!
    \fn XGDocker::iconAdd(const XSGObjectIcon &, int index=-1)
 */
void XGDocker::iconAdd(const XSGObjectIcon *cfgIcon, int index)
{
	int iconIndex=activeIconsCounter;
	XGIcon *addedIcon=new XGIcon;
	
	if(index>=0 && activeIconsCounter!=index)
	{
		iconIndex=index;
		// if we have to intert a center icon we have to translate the others
#ifndef ENABLE_FINAL
		qWarning("xgdocker.cpp:733");
#endif
		for(int i=index;i<activeIconsCounter-1;i++)
		{
#ifndef ENABLE_FINAL
			qWarning("xgdocker.cpp:736");
#endif
			activeIcons[i]->xPosition=activeIcons[i+1]->xPosition;
			activeIcons[i]->xPosDefault=activeIcons[i+1]->xPosDefault;
			activeIcons[i]->xHotspot=activeIcons[i+1]->xHotspot;
			activeIcons[i]->xZoom=activeIcons[i+1]->xZoom;
			activeIcons[i]->xSetSmoothZoom(activeIcons[i]->xZoom);
		}
		Matrix->xMakeSpace(activeIconsCounter,&activeIcons[activeIconsCounter-1]->xPosition);
		Matrix->xMakeSpace(activeIconsCounter,&activeIcons[activeIconsCounter-1]->xPosDefault);
		Matrix->xMakeCenter(activeIconsCounter,&activeIcons[activeIconsCounter-1]->xHotspot);
		
		
		for(int i=activeIconsCounter;i>=index;i--)
		{
			activeIcons[i+1]=activeIcons[i];
		}
	}
	
	QPixmap Pixmap;
	QString imgFileNameReal=xFindIconFile(cfgIcon->Images.imgFileName);
	QFile ifr(imgFileNameReal);
	if(ifr.exists() && imgFileNameReal!=QString::null)
	{
		Pixmap.load(imgFileNameReal);
#ifndef ENABLE_FINAL
		qWarning(imgFileNameReal);
#endif
	}
	else
	{
		Pixmap=KDEIconLoader.loadIcon(
				cfgIcon->Images.imgFileName,
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizeBig,
				KIcon::DefaultState,
				NULL,
				true
				);
		// patch 31052004
		// to load the default icon
		if(Pixmap.isNull())
		{
			if(ActiveConfiguration->Theme.DefaultIcon.isNull())
			{
			imgFileNameReal=xFindIconFile("default");
			ifr.setName(imgFileNameReal);
			if(ifr.exists() && imgFileNameReal!=QString::null)
			{
				ActiveConfiguration->Theme.DefaultIcon.load(imgFileNameReal);
			}
			else
			{
				ActiveConfiguration->Theme.DefaultIcon=KDEIconLoader.loadIcon(
					cfgIcon->Images.imgFileName,
					KIcon::NoGroup,
					ActiveConfiguration->Icons.SizeBig
					);
			}
			}
			else
			{
			
			}
			Pixmap=ActiveConfiguration->Theme.DefaultIcon;
		}
	}


			if(Pixmap.isNull())
			{
				#ifndef ENABLE_FINAL
					xWarningMsg(this,"error loading image");
				#endif
			}
			// resetting mask, cached data
			addedIcon->xReset();
			// loading the image
			//addedIcon->xImgOriginal=PixmapConverter.convertToImage(Pixmap);
			addedIcon->xImgOriginal=Pixmap.convertToImage();
			if(cfgIcon->Tasks.ShowThumbnail>0)
			{
				addedIcon->xImgSource=cfgIcon->Tasks.Thumbnail;
			}
			else
			{
		
				//addedIcon->xImgSource=PixmapConverter.convertToImage(Pixmap);
				addedIcon->xImgSource=Pixmap.convertToImage();
			}
	
			// Setup cacheing policy
			addedIcon->xAndZoomCache=ActiveConfiguration->Engine.AndZoomCache;
			Matrix->xMakeSpace(iconIndex,&addedIcon->xPosition);
			Matrix->xMakeSpace(iconIndex,&addedIcon->xPosDefault);
			Matrix->xMakeCenter(iconIndex,&addedIcon->xHotspot);
			//
			addedIcon->xSetSmoothZoom(ActiveConfiguration->Icons.Size);
			//activeIcons[iconIndex]->xSetZoom(ActiveConfiguration->Icons.Size);
			// setup it ready for update
			// activeIcons[iconIndex]->xSetUpdate=1;
	// Loading arrow
	QString ArrowFileName="arrow.png";
	if(cfgIcon->Images.imgFileArrow!=QString::null)ArrowFileName=cfgIcon->Images.imgFileArrow;
	if (ActiveConfiguration->Theme.ArrowsPath[ActiveConfiguration->Theme.ArrowsPath.length()-1]!='/')ActiveConfiguration->Theme.ArrowsPath=ActiveConfiguration->Theme.ArrowsPath+"/";
	
	
	ArrowFileName=::locate("data",ActiveConfiguration->Theme.ArrowsPath)+ArrowFileName;
#ifndef ENABLE_FINAL
	qWarning(ArrowFileName);
#endif
	ArrowFileName=::locate("data",ArrowFileName);
#ifndef ENABLE_FINAL
	qWarning(ArrowFileName);
#endif

	// bug fix 31052004
	QFile ar(::locate("data",ArrowFileName));
	if(!ar.exists() || ArrowFileName==QString::null)
	{
		ArrowFileName="arrow.png";
if(cfgIcon->Images.imgFileArrow!=QString::null)ArrowFileName=cfgIcon->Images.imgFileArrow;
		ArrowFileName="kxdocker/themes/arrows/"+ArrowFileName;
		
		ArrowFileName=::locate("data",ArrowFileName);
		ar.setName(ArrowFileName);
		if(!ar.exists() || ArrowFileName==QString::null)
		{
			ArrowFileName="kxdocker/themes/arrows/arrow.png";
			ArrowFileName=::locate("data",ArrowFileName);
		}		
	}
	
	QPixmap PixmapArrow(ArrowFileName);
	
	if(PixmapArrow.isNull())
	{
		//PixmapArrow.create(1,1,32);
	}

	addedIcon->xImgArrow=PixmapConverter.convertToImage(PixmapArrow);
	// patch 18042004 -> enable other icons sizes
	addedIcon->xImgArrow=addedIcon->xImgArrow.smoothScale(
		ActiveConfiguration->Icons.Size,
		ActiveConfiguration->Icons.Size,
		QImage::ScaleMax);
	
	addedIcon->xSetText(cfgIcon->OverText);
	
	QString PoofName=ActiveConfiguration->Theme.PoofPath;
	PoofName=PoofName+"/"+cfgIcon->PoofName;
#ifndef ENABLE_FINAL
	qWarning(PoofName);
#endif

	QFile b(::locate("data",PoofName));
	if(!b.exists() || PoofName==QString::null)
	{
		PoofName="kxdocker/themes/poof/";
		PoofName=PoofName+cfgIcon->PoofName;
	}
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:866");
	qWarning(PoofName);
	qWarning(::locate("data",PoofName));
#endif
	addedIcon->Poof.load(::locate("data",PoofName));
	

	addedIcon->iconConfiguration=cfgIcon;
	
	activeIcons[iconIndex]=addedIcon;
	activeIconsCounter++;
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:876");
#endif
}


/*!
    \fn XGDocker::iconRemove(int index)
 */
void XGDocker::iconRemove(int index,int noanimation)
{
	if(index<0 || index>=activeIconsCounter)return;
	
	// poof animations
	if(!noanimation)xEventRemoveIcon(index);
	
	
	Configurator->iconRemove(index);
	
	XGIcon *removedIcon=activeIcons[index];

	for(int i=activeIconsCounter-1;i>index;i--)
	{
		if(activeIcons[i-1]->xExclude)
		{
			if(!AxisAreInverted)
			{
			activeIcons[i]->xPosition.setX(activeIcons[i-1]->xPosition.x());
			activeIcons[i]->xPosDefault.setX(activeIcons[i-1]->xPosDefault.x());
			}
			else
			{
			activeIcons[i]->xPosition.setY(activeIcons[i-1]->xPosition.y());
			activeIcons[i]->xPosDefault.setY(activeIcons[i-1]->xPosDefault.y());
			}
			activeIcons[i]->xHotspot=activeIcons[i-1]->xHotspot;
			//activeIcons[i]->xZoom=activeIcons[i-1]->xZoom;
		}
		else
		{
			activeIcons[i]->xPosition=activeIcons[i-1]->xPosition;
			activeIcons[i]->xPosDefault=activeIcons[i-1]->xPosDefault;
			activeIcons[i]->xHotspot=activeIcons[i-1]->xHotspot;
			activeIcons[i]->xZoom=activeIcons[i-1]->xZoom;
		}
	}
	for(int i=index;i<activeIconsCounter-1;i++)
	{
		activeIcons[i]=activeIcons[i+1];
		activeIcons[i]->cachePurge();
		activeIcons[i]->xSetSmoothZoom(activeIcons[i]->xZoom);
	}
	//ActiveConfiguration->Engine.IconsShowed--;
	activeIconsCounter--;
	activeIcons[activeIconsCounter]=NULL;
	delete removedIcon;
	xMoveWidgetCenter();
	maskGenerareBigFake();
	checkBackgroundSeparators();
}


/*!
    \fn XGDocker::changeBackground(const QString basePath)
 */
void XGDocker::changeBackground(const QString basePath)
{
	QString barPath=basePath;
	if (barPath[barPath.length()-1]!='/')barPath=barPath+"/";
	barPath=::locate("data",barPath);
	
	QFile a(barPath);
	
	if(basePath.length()>0 && a.exists())
	{
		
		
#ifndef ENABLE_FINAL
		qWarning(barPath);
#endif
		// Setup background theme
		QString filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundCenter;
		
		QPixmap PixmapB(filename);
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			backgroundBar.xImgSource.reset();
		}
		else
		{
			//backgroundBar.xImgSource=PixmapConverter.convertToImage(PixmapB);
			backgroundBar.xImgSource=PixmapB.convertToImage();
			if(ActiveConfiguration->Theme.Background.Tiled)
			{
				backgroundBar.xImgSource=
					backgroundBar.xImgSource.smoothScale(
					backgroundBar.xImgSource.width(),
					ActiveConfiguration->Icons.Size+16);
				backgroundBar.xRepeat(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
			else
			{
				backgroundBar.xImgSource=
					backgroundBar.xImgSource.smoothScale(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			
			}
		}
		PixmapB.resize(0,0);
		
		filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundOver;
		
		PixmapB.load(filename);
		
		if(PixmapB.isNull())
		{
			backgroundBarOver.xImgSource.reset();
#ifndef ENABLE_FINAL
			qWarning("errore OVER");
#endif
		}
		else
		{
			//backgroundBarOver.xImgSource=PixmapConverter.convertToImage(PixmapB);
			backgroundBarOver.xImgSource=PixmapB.convertToImage();
			
			if(ActiveConfiguration->Theme.Background.Tiled)
			{
				backgroundBarOver.xImgSource=
					backgroundBarOver.xImgSource.smoothScale(
					backgroundBarOver.xImgSource.width(),
					ActiveConfiguration->Icons.Size+16);
				backgroundBarOver.xRepeat(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
			else
			{
				backgroundBarOver.xImgSource=
					backgroundBarOver.xImgSource.smoothScale(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
		}
		PixmapB.resize(0,0);
		
		filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundLeft;
		
		PixmapB.load(filename);
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			backgroundBarLeft.xImgSource.reset();
			backgroundBarLeft.xTransparency.resize(0,0);
#ifndef ENABLE_FINAL
			qWarning("errore left");
#endif
		}
		else
		{
			backgroundBarLeft.xImgSource=PixmapB.convertToImage();
			backgroundBarLeft.xImgSource=
				backgroundBarLeft.xImgSource.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
			backgroundBarLeft.xTransparency=
				backgroundBarLeft.xImgSource.createHeuristicMask();
				//backgroundBarLeft.xImgSource.createAlphaMask();
		}
		PixmapB.resize(0,0);
		
		filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundRight;
		
		PixmapB.load(filename);
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			backgroundBarRight.xImgSource.reset();
			backgroundBarRight.xTransparency.resize(0,0);
#ifndef ENABLE_FINAL
			qWarning("errore right");
#endif
		}
		else
		{
			
			backgroundBarRight.xImgSource=PixmapB.convertToImage();
			backgroundBarRight.xImgSource=
				backgroundBarRight.xImgSource.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
			backgroundBarRight.xTransparency=
				//backgroundBarRight.xImgSource.createAlphaMask();
				backgroundBarRight.xImgSource.createHeuristicMask();
		}
		PixmapB.resize(0,0);
	}
	else
	{
		// no background
		backgroundBar.xImgSource.reset();
	}
	// auto adding separator
	// 20050601
	// code moved to a func
	checkBackgroundSeparators();
	//maskGenerareBigFake();
}


/*!
    \fn XGDocker::xEventTaskAppend(int)
 */
void XGDocker::xEventTaskAppend(int iconIndex)
{
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xEventTaskAppend(int iconIndex)");
#endif
	iconAdd(ActiveConfiguration->ObjectsIcons.at(iconIndex),iconIndex);
	xMoveWidgetCenter();
	maskGenerareBigFake();
	if(isRaised)
	{
		//QMouseEvent e(QEvent::MouseMove,QPoint(xLastX,xLastY),0,0);
		//mouseMoveEvent(&e);
		mouseMoveEventSW(xLastX,xLastY,1);
		xUpdate(0,1);
		repaint(false);
	}
}


/*!
    \fn XGDocker::xIRQ_Reset()
 */
void XGDocker::xIRQ_Reset()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"xEventReset()");	
#endif	

	xEventMouseMoved(xLastX,xLastY);
	//grabMouse();
	//xEventReset(xLastX,xLastY);
}


/*!
    \fn XGDocker::xMoveWidgetCenter()
 */
void XGDocker::xMoveWidgetCenter()
{
	setFixedSize(ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height);
	// Move Window to layer
	/*
	if(strcmp(ActiveConfiguration->Window.Align,"none")==0)
	{
	}
	*/
	if(LayoutPosition==LONTOP)
	{
		qWarning("xMoveWidgetCenter() top align");
#ifndef ENABLE_FINAL
		qWarning("xMoveWidgetCenter() top align");
#endif
		int  rwidth=
			activeIcons[activeIconsCounter-1]->xPosDefault.x()
			-activeIcons[0]->xPosDefault.x()+
			(ActiveConfiguration->Icons.Size+16)*2
			+(ActiveConfiguration->Icons.Size);
		ActiveConfiguration->Window.Left=
			(QApplication::desktop()->width()-rwidth)/2
			-(activeIcons[0]->xPosDefault.x()-ActiveConfiguration->Icons.Size-16);
		
		ActiveConfiguration->Window.Top=0;
		if(ActiveConfiguration->Window.RaiseOnEvents)
                KWin::setStrut( winId(), 0, 0, ActiveConfiguration->Window.HeightDesktop,0);
	}
	
	if(LayoutPosition==LONBOTTOM)
	{
#ifndef ENABLE_FINAL
		qWarning("xMoveWidgetCenter() bottom align");
#endif
		int  rwidth=
			activeIcons[activeIconsCounter-1]->xPosDefault.x()
			-activeIcons[0]->xPosDefault.x()+
			(ActiveConfiguration->Icons.Size+16)*2
			+(ActiveConfiguration->Icons.Size);
		ActiveConfiguration->Window.Left=
			(QApplication::desktop()->width()-rwidth)/2
			-(activeIcons[0]->xPosDefault.x()-ActiveConfiguration->Icons.Size-16);
		
		ActiveConfiguration->Window.Top=
			QApplication::desktop()->height()-ActiveConfiguration->Window.Height;
		if(ActiveConfiguration->Window.RaiseOnEvents)
                KWin::setStrut( winId(), 0, 0, 0, ActiveConfiguration->Window.HeightDesktop );
	}
	ActiveConfiguration->Window.Left=ActiveConfiguration->Window.LeftForce+ActiveConfiguration->Window.Left;
	ActiveConfiguration->Window.Top=ActiveConfiguration->Window.TopForce+ActiveConfiguration->Window.Top;
#ifndef ENABLE_FINAL

		char pippo[50];
		sprintf(pippo,"XGDocker::xMoveWidgetCenter() %d %d",ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top);
		qWarning(pippo);
#endif
	move(ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top);
	xEventWidgetMoved(
	ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top,
	activeIcons[0]->xPosDefault.x(),
	activeIcons[0]->xPosDefault.y(),
	activeIcons[activeIconsCounter-1]->xPosDefault.x(),
	activeIcons[activeIconsCounter-1]->xPosDefault.y()
		);
}


/*!
    \fn XGDocker::xBliz()
 */
void XGDocker::xBliz(int isDesktop)
{
	if(isDesktop)
	{
#ifndef ENABLE_FINAL
		qWarning("XGDocker::xBliz(1)");
#endif
		lastRaise=-2;
	}
	else
	{
#ifndef ENABLE_FINAL
		qWarning("XGDocker::xBliz(0)");
#endif
		
		setMask(maskBackground);
		//lower();
		//qApp->flushX();
		qApp->syncX();
		//sleep(2);
		usleep(100000);
		lastRaise=0;
		isRaised=1;
		
		//this->mouseMoveEvent();
	}
	xUpdate();
	repaint(false);
	
}


/*!
    \fn XGDocker::getRaised()
 */
int XGDocker::getRaised()
{
    return isRaised;
}


/*!
    \fn XGDocker::mouseMoveSoftware(int,int)
 */
void XGDocker::mouseMoveSoftware(int x,int y)
{
	// called by the software to track the mouse position
	
	if(y<0)xRestore();
}


/*!
    \fn XGDocker::wheelEvent(QWheelEvent * e )
 */
void XGDocker::wheelEvent(QWheelEvent * e )
{
	releaseMouse();
	int x=e->pos().x();
	int y=e->pos().y();
	int b=0;
	if(e->delta()>0)b=1;
	else b=2;
	int iconNum=(x-ActiveConfiguration->Window.borderLeft)
		/
		(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	xEventMouseWheel(iconNum,x,y,b);
}


/*!
    \fn XGDocker::reloadIcon(int icon)
 */
void XGDocker::reloadIcon(int icon)
{
	QPixmap Pixmap;
	if(ActiveConfiguration->ObjectsIcons.at(icon)->Images.imgFileName!=""){
	QString imgFileNameReal=xFindIconFile(ActiveConfiguration->ObjectsIcons.at(icon)->Images.imgFileName);
	QFile ifr(imgFileNameReal);
	if(ifr.exists() && imgFileNameReal!=QString::null)
	{
		Pixmap.load(imgFileNameReal);
	}
	else
	{
		Pixmap=KDEIconLoader.loadIcon(
			ActiveConfiguration->ObjectsIcons.at(icon)->Images.imgFileName,
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizeBig
				);
	}


	activeIcons[icon]->xImgSource=Pixmap.convertToImage();
	activeIcons[icon]->xImgOriginal=activeIcons[icon]->xImgSource.copy();
	int z=activeIcons[icon]->xZoom;
	activeIcons[icon]->xZoom=0;
	activeIcons[icon]->cachePurge();
	activeIcons[icon]->xSetSmoothZoom(z);
	activeIcons[icon]->xSetText(ActiveConfiguration->ObjectsIcons.at(icon)->OverText);
	// 0.0.19 20050524
	// Used to tell to the plugin to force redraw
	}
	activeIcons[icon]->xRedraw();
	
	xUpdate(0,1);
	repaint(false);
}


/*!
    \fn XGDocker::xFindIconFile(const QString &logicName)
 */
QString XGDocker::xFindIconFile(const QString &logicName)
{
	// new Engine 12 Mar 2004
	// multi path for icons before lets kde chose
	QString imgFileNameLogic=logicName;
	// We like the png before svg?
	QString imgFileNameReal;
	QFile ifr(logicName);
	if(ifr.exists())return logicName;
	
	
	for(uint ifl=0;ifl<ActiveConfiguration->Theme.IconsPaths.count();ifl++)
	{
		// PNG
		imgFileNameReal=ActiveConfiguration->Theme.IconsPaths[ifl];
		imgFileNameReal=imgFileNameReal;
		imgFileNameReal=imgFileNameReal+"/";
		imgFileNameReal=imgFileNameReal+imgFileNameLogic;
		imgFileNameReal=imgFileNameReal+".png";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
		
		// SVG
		if(ifr.exists() && imgFileNameReal!=QString::null)break;
		imgFileNameReal=ActiveConfiguration->Theme.IconsPaths[ifl];
		imgFileNameReal=imgFileNameReal;
		imgFileNameReal=imgFileNameReal+"/";
		imgFileNameReal=imgFileNameReal+imgFileNameLogic;
		imgFileNameReal=imgFileNameReal+".svg";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
		if(ifr.exists() && imgFileNameReal!=QString::null)break;
	}
	return imgFileNameReal;
}


//inline void XGDocker::mouseMoveEventSW(int x,int y,int force)
void XGDocker::mouseMoveEventSW(int x,int y,int force,Qt::ButtonState button)
{
	// Mouse move event, software - user
	// Check if you are going near the end of screen Y - horizontal bar
	// TODO: Vertical bar
	xLastX=x;
	xLastY=y;
	#ifdef ENABLE_SPECIALENGINE2
	#else
	if(y>xDesignVirtualYMatrix)y=xDesignVirtualYMatrix;
	else
	{
		// Ok we are away
		if(!isAnimating)
		{
			if(y<=0)
			{
				releaseMouse();
				if(isRaised)QTimer::singleShot(
					ActiveConfiguration->Engine.SleepAnimations
					,this,SLOT(xIRQ_Reset()));
				return;
			}
			y=xDesignVirtualYMatrix;
		}
		
	}
	#endif
	
	if(xLastX_real==x && xLastY_real==y && !force)
	{
		return;
	}
	
	#ifdef ENABLE_SPECIALENGINE2
	#else
	if(isRaised==0)
	{
		// we are off than we are going to on...
		if(y>1 && !isAnimating)
		{
			xLastX=x;
			xLastY=0;
			xEventAnimateTo(x,y,x,0);
			return;
		}
	}
	#endif
	// new engine 2
	xLastX_real=x;
	xLastY_real=y;
	
	int dx,dy,DiffIconX,DiffIconY,DiffIcon,AreMovingToLeft;
	int iconNum=
		(x-ActiveConfiguration->Window.borderLeft)/
		(ActiveConfiguration->Icons.Size
		+ActiveConfiguration->Icons.Separation);

	// TODO: it may crash ?????????????????
	/*
	if(iconNum<=-5 || iconNum>=activeIconsCounter+5)
	{
		//if(isRaised)xEventReset(x,y);
		//if(isRaised)QTimer::singleShot(500,this,SLOT(xIRQ_Reset()));
		return;
	}
	*/
	// adaptive mouse horizontal
	if(iconNum<=0)
	{
		dx=activeIcons[0]->xHotspot.x()-x;
		if(dx>0)
		{
			dy=activeIcons[0]->xHotspot.x()-y;
			if(dy>0)y=y-abs(activeIcons[0]->xHotspot.x()-x);
			else y=abs(activeIcons[0]->xHotspot.x()-x)+y;
			x=activeIcons[0]->xHotspot.x();
		}
	}
	if(iconNum>=activeIconsCounter-1)
	{
		dx=activeIcons[activeIconsCounter-1]->xHotspot.x()-x;
		if(dx<0)
		{
			dy=activeIcons[activeIconsCounter-1]->xHotspot.x()-y;
			if(dy>0)y=y-abs(activeIcons[activeIconsCounter-1]->xHotspot.x()-x);
			else y=abs(activeIcons[activeIconsCounter-1]->xHotspot.x()-x)+y;
			x=activeIcons[activeIconsCounter-1]->xHotspot.x();
		}
	}
	
	// if applied an effect now we can remove it
	//if(lastIcon!=iconNum && iconNum>=0 
	// &&iconNum<activeIconsCounter)activeIcons[lastIcon].xResetIntensity();
	
	// save last icon index
	lastIcon=iconNum;
#ifdef HAS_DRAGMODE  
	//if(iconIndex==iconNum && button!=Qt::NoButton && lastIconDrag==NULL)
	if(button!=Qt::NoButton)
	{
		if(lastIconDrag!=NULL)return;
	}
#endif

// Optimizing code
	isRaised=0;
	
	for(long int iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
			dx=activeIcons[iconIndex]->xHotspot.x()-x;
			DiffIconX=abs(dx*ActiveConfiguration->Matrix.DesignXMoltiplier);
			dy=activeIcons[iconIndex]->xHotspot.y()-y;
			DiffIconY=abs(dy*ActiveConfiguration->Matrix.DesignYMoltiplier);
			DiffIcon=DiffIconY+DiffIconX;
			//sprintf(errore,"MouseMoved Diff:%d Icon:%d",DiffIcon,iconIndex);
			//qWarning(errore);
			if(DiffIcon<ActiveConfiguration->Matrix.sizeMatrix*2)
			{
				if(dx>0)
				{
					AreMovingToLeft=ActiveConfiguration->Matrix.DMatrix[DiffIconX][DiffIconY];
				}
				else
				{
					AreMovingToLeft=-ActiveConfiguration->Matrix.DMatrix[DiffIconX][DiffIconY];
				}
				if(!activeIcons[iconIndex]->xExclude)
				{
					activeIcons[iconIndex]->xPosition.setX(
						activeIcons[iconIndex]->xPosDefault.x()
						- ActiveConfiguration->Matrix.XMatrix[DiffIcon]+AreMovingToLeft);
					// new Engine with Separators 11 May 2004
					activeIcons[iconIndex]->xPosition.setY(
						activeIcons[iconIndex]->xPosDefault.y()
						-ActiveConfiguration->Matrix.YMatrix[DiffIcon]);
	
					activeIcons[iconIndex]->xSetZoom(
						ActiveConfiguration->Matrix.ZMatrix[DiffIcon]);
				}
				else
				{
					activeIcons[iconIndex]->xPosition.setX(
						activeIcons[iconIndex]->xPosDefault.x()
						+AreMovingToLeft);
				}
				isRaised=1;
#ifdef HAS_DRAGMODE  
	if(iconIndex==iconNum && button!=Qt::NoButton)
	{
		if(lastIconDrag==NULL)lastIconDrag=activeIcons[iconIndex];
		// star dragging, by removing this icon
		activeIcons[iconIndex]->xPosition.setY(-5000);
	}
	else
	{
	}
#endif
			}
			else
			{
				if(DiffIconY>=ActiveConfiguration->Matrix.sizeMatrix*2)
				{
					DiffIconY=ActiveConfiguration->Matrix.sizeMatrix*2-1;
					// all hotspot are =y
					// than if you are too away from 1 icon all icons are restored
// Optimizing code
//					isRaised=0;
				}
				if(dx>0)
				{
					AreMovingToLeft=ActiveConfiguration->Matrix.KMatrix[DiffIconY];
				}
				else
				{
					AreMovingToLeft=-ActiveConfiguration->Matrix.KMatrix[DiffIconY];
				}
				activeIcons[iconIndex]->xPosition.setX(
					activeIcons[iconIndex]->xPosDefault.x()
					+AreMovingToLeft);
				activeIcons[iconIndex]->xPosition.setY(
					activeIcons[iconIndex]->xPosDefault.y()
					);
				activeIcons[iconIndex]->xSetZoom(ActiveConfiguration->Icons.Size);
			}
		}
}


/*!
    \fn XGDocker::xRestore()
 */
void XGDocker::xRestore()
{
	xEventReset(xLastX,xLastY);
}


/*!
    \fn XGDocker::polish()
 */
void XGDocker::polish()
{

#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:1328");
#endif
	xUpdate();
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:1330");
#endif
	xMoveWidgetCenter();
		
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:1333");
#endif
	maskGenerareBigFake();
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:1335");
#endif
}


/*!
    \fn XGDocker::xHide()
 */
void XGDocker::xHide()
{
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:1370");
#endif
	tAutoHideTimer->stop();
	hide();
	//xEventDockerHidden();
}


/*!
    \fn XGDocker::dragEnterEvent(QDragEnterEvent* event)
 */
void XGDocker::dragEnterEvent(QDragEnterEvent* event)
{
/*
    event->accept(
        QTextDrag::canDecode(event)
	// ||
        //QImageDrag::canDecode(event)
    );
    QString basket;
    if(QTextDrag::decode ( event, basket)==true)qWarning(basket);
*/
}


/*!
    \fn XGDocker::dropEvent(QDropEvent* event)
 */
void XGDocker::dropEvent(QDropEvent* event)
{
    /// @todo implement me
	QString basket;
	if(QTextDrag::decode ( event, basket)==true)qWarning(basket);
}


/*!
    \fn XGDocker::dragMoveEvent( QDragMoveEvent * )
 */
void XGDocker::dragMoveEvent( QDragMoveEvent * event)
{
	Busy.lock();
#ifndef ENABLE_FINAL	
	qWarning("void XGDocker::dragMoveEvent( QDragMoveEvent * event)");
#endif
	//this->mouseMoveEventSW(event->pos().x(),event->pos().y());
	//repaint(false);
	Busy.unlock();
}


/*!
    \fn XGDocker::xDrawPillow()
 */
inline void XGDocker::xDrawPillow()
{
	if(isRaised)
	{
	/*
		if(lastIcon>=0 && lastIcon<activeIconsCounter)
		{
			bitBlt(&paintBuffer,bsx,0,
				&activeIcons[lastIcon]->xImgText,
				0,
//				bsw,
//				bsh,
				Qt::CopyROP);
		}
		repaint(QRect(bsx,0,bsw,bsh));
		//repaint(false);
	*/
	// external pillow 08Jun2004
		qWarning(QString("xDrawPillow %1").arg(lastIcon));
		if(lastIcon>=0 && lastIcon<activeIconsCounter)
		{
			int bsx=activeIcons[lastIcon]->xPosition.x()+activeIcons[lastIcon]->xTextDecentre;
			
			// Version 0.25
			// unused var
			//int bsw=activeIcons[lastIcon]->xImgText.size().width();
			//int bsh=activeIcons[lastIcon]->xImgText.size().height();
			
			if(activeIcons[lastIcon]->xPillow==NULL)
			{
				qWarning("Creating new pillow...");
				activeIcons[lastIcon]->xPillow=new XEPlugin_GEPillow(0,0);
				activeIcons[lastIcon]->xPillow->xSetup();
				activeIcons[lastIcon]->xPillow->xStart();
				//activeIcons[lastIcon]->xPillow->resize(300,30);
				//activeIcons[lastIcon]->xPillow->move(0,0);
			}
			activeIcons[lastIcon]->xPillow->externalDrawPillow(
			//((XEPlugin_GEPillow *)xPillow)->externalDrawPillow(
				activeIcons[lastIcon],
				bsx+ActiveConfiguration->Window.Left,
				ActiveConfiguration->Window.Top-5
				-
				XGIcon::xGetFontHeight());
			//xPillow->show();
			activeIcons[lastIcon]->xPillow->show();
			
		}
		else
		{
		//xPillow->hide();
		}
	}
	//tDrawPillow->stop();
}


/*!
    \fn XGDocker::mouseReleaseEvent ( QMouseEvent * e )
 */
void XGDocker::mouseReleaseEvent (QMouseEvent *)
{
	//lastButtonStatus=e->button();
	lastButtonStatus=Qt::NoButton;
	lastIconDrag=NULL;
}


/*!
    \fn XGDocker::hide()
 */
void XGDocker::hide()
{
	xEventDockerHidden();
	QWidget::hide();
	KWin::setStrut( winId(), 0, 0, 0,0);
}


/*!
    \fn XGDocker::show()
 */
void XGDocker::show()
{

	if(ActiveConfiguration->Window.RaiseOnEvents)
	{
		showRaised();
	}
	else
	{
	xEventDockerShowed();
	QWidget::show();
	KWin::setOnAllDesktops(winId(),true);

	}
	tAutoSendBGTimer->stop();
}

/*!
    \fn XGDocker::purgeCacheMovements()
 */
void XGDocker::purgeCacheMovements()
{


#ifdef ENABLE_SPECIALENGINE2
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::purgeCacheMovements() Engine 2");
#endif
//	static int lastCalledX=0;
//	static int lastCalledY=0;
//	if(xLastX_notmanaged!=lastCalledX || xLastY_notmanaged!=lastCalledY )
		for(int recallme=1;recallme!=0;)
{

	// workaround!!!!!!!
	QPoint pos, mouse, vect;
	int WinX, WinY;
	int XCoord,YCoord;
	Display *display;
	Window root, RootIDRet, ChildIDRet;
	unsigned int StateMask;
	display = kapp->getDisplay();
	root = RootWindow(display,DefaultScreen(display));
	XQueryPointer(display, root, &RootIDRet, &ChildIDRet, &XCoord,&YCoord, &WinX, &WinY, &StateMask);
	//mouse = xGDocker->mapFromGlobal(QPoint(XCoord,YCoord));
	mouse = this->mapFromGlobal(QPoint(XCoord,YCoord));
	xLastX_notmanaged=mouse.x();
	xLastY_notmanaged=mouse.y();

	static int ymoltiply=1;





	recallme=0;
	//if(1)
	if(mouseMoveTimeElapsed.elapsed()>30)
	{
	//recallme=0;
#ifdef ENABLE_FINAL
#else
			qWarning(
			QString("void XGDocker::purgeCacheMovements() Engine 2 count [%1,%1][%1,%1]")
			.arg(xLastX_notmanaged)
			.arg(xLastY_notmanaged)
			.arg(xLastX)
			.arg(xLastY)
			);
#endif

			// new Engine 0.20
			// 20040525
#ifdef ENABLE_SPECIALENGINE3
			int iconNum=(xLastX_notmanaged-ActiveConfiguration->Window.borderLeft)
				/
				(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
			
			if(iconNum<activeIconsCounter && iconNum>=0)
				xLastX_notmanaged=activeIcons[iconNum]->xPosDefault.x()+ActiveConfiguration->Icons.Size/2;
#else
#endif			
			
			int ax=xLastX_notmanaged;
			//int ay=xLastY_notmanaged;
			int ay=xLastY;
			int xInterpolationValue=ActiveConfiguration->Engine.InterpolationValue;
			
			// 0.25
			// unused var
			//int xInterpolationStep=50;
			if(xLastX-xLastX_notmanaged>1)
			{

				ax=xLastX-1-(xLastX-xLastX_notmanaged)/xInterpolationValue;
				//ax=xLastX-1;
				recallme=1;
			}
			else
			{
				if(xLastX-xLastX_notmanaged<-1)
				{
					ax=xLastX+1-(xLastX-xLastX_notmanaged)/xInterpolationValue;
					//ax=xLastX+1;
					recallme=1;
				}
			}
 			if(xLastY_notmanaged<0|| xLastY_notmanaged>ActiveConfiguration->Window.Height)
			{
				if(!isRaised)
				{
					releaseMouse();
					recallme=0;
					ay=xLastY-5-ymoltiply;
					ymoltiply=1;
					//break;
					tAutoSendBGTimer->start(200);
				}
				else
				{
					// we have to animate
					//ay=xLastY-1-(xLastY-xLastY_notmanaged)/xInterpolationValue;
					releaseMouse();
					ay=xLastY-5-ymoltiply;
					ymoltiply=ymoltiply+5;
					recallme=1;
				}

			}
			else
			{
			
				if(xLastY-xDesignVirtualYMatrix>1)
				{
					ay=xLastY-1-abs(xLastY-xDesignVirtualYMatrix)/xInterpolationValue;
					recallme=1;
				}
				else
				{
					if(xLastY-xDesignVirtualYMatrix<-1)
					{
						ay=xLastY+1+abs(xLastY-xDesignVirtualYMatrix)/xInterpolationValue;
						recallme=1;
					}
				}
			}
				mouseMoveTimeElapsed.start();
				mouseMoveEventSW(ax,ay,0,lastButtonStatus);
				//xUpdate(0,isRaised);
				xUpdate();
				repaint(false);
	}
	else
	{
		usleep(10000);
		recallme=1;
	}
}
	/*
	if(recallme)
	{
#ifdef ENABLE_FINAL
#else
			qWarning("void XGDocker::purgeCacheMovements() Engine 2 repoll");
#endif
			//QTimer::singleShot(0,this,SLOT(purgeCacheMovements()));
			//purgeCacheMovements();
	}
	else
	{
	
			//mouseMoveEventSW(xLastX_notmanaged,xLastY_notmanaged,0,lastButtonStatus);
	}
	*/
			//xUpdate();
			//repaint(false);
			
	cacheBusy.unlock();
	isAnimating=0;

#endif
}


/*!
    \fn XGDocker::xGetWidget(QWidget *&)
 */
void XGDocker::xGetWidget(QWidget *&pObjectWnd)
{
	pObjectWnd=this;
}


/*!
    \fn XGDocker::xMouseMoveSoftware(int,int,Qt::ButtonState)
 */
void XGDocker::xMouseMoveSoftware(int x,int y)
{
	mouseMoveSoftware(x,y);
}


/*!
    \fn XGDocker::xDockerRedraw
 */
void XGDocker::xDockerRedraw()
{
	//qWarning("xDockerRedraw()");
	// 31052004
	// may be wrong but this will help to alleviate the flickering
	// PS:
	// this will not work properly until we rewrite pillow code
	//xUpdate(0,1);
	//xUpdate();
	//xIRQ_MouseTimeout();
	//xUpdateSmooth();
	xUpdate(0,1);
	repaint(false);
}


/*!
    \fn XGDocker::iconAddSeparator()
 */
void XGDocker::iconAddSeparator()
{
	XSGObjectIcon *addedCfg=new XSGObjectIcon;
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;
	addedCfg->Tasks.Proces.clear();
	addedCfg->Info.fileName="";
	addedCfg->Info.Name=QString("AutoAddedSeparator%1").arg((int)addedCfg);
	addedCfg->Info.Group=QString("AutoAddedSeparatorGroup%1").arg((int)addedCfg);
	addedCfg->Actions.onClickExec="";
	addedCfg->OverText="";
	addedCfg->Images.imgFileName="";
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Tasks.ClassName.clear();
	addedCfg->Tasks.WindowTitle.clear();
	addedCfg->Tasks.TaskName.clear();
	addedCfg->Tasks.Proces.clear();
	addedCfg->Tasks.TaskInfo=NULL;
	
	addedCfg->Info.className="GSeparator";
	// we will not the icon to Rolling Icons because i don't like to save the added Separator
	ActiveConfiguration->ObjectsIcons.append(addedCfg);

	xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
	//if(cfgIcon->Info.className=="GSeparator")
	checkBackgroundSeparators();
	
}


/*!
    \fn XGDocker::checkBackgroundSeparators()
 */
void XGDocker::checkBackgroundSeparators()
{
	QString barPath=ActiveConfiguration->Theme.BackgroundPath;
	if (barPath[barPath.length()-1]!='/')barPath=barPath+"/";
	barPath=::locate("data",barPath);
	// New engine 11 May 2004
	// we have to search for all separators icons
	// GSeparator
	for(uint iconIndex=0;
		iconIndex<ActiveConfiguration->ObjectsIcons.count();
		iconIndex++)
		{
if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="GSeparator")
	{
	activeIcons[iconIndex]->xExclude=1;
	
			if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Images.imgFileName=="")
			{
				// if you don't specify an image we load the
				// background-separator.png
				
		QPixmap PixmapB;
		PixmapB.resize(0,0);
		
		QString filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundSeparator;
			
#ifndef ENABLE_FINAL
			qWarning(filename);
#endif
		
		PixmapB.load(filename);
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			// We do nothing!!!
			// TODO: new right engine to load backgrounds
			
			// 0.22 patch 15062004
			// if ou don't have separators we create a transparent image
			activeIcons[iconIndex]->xImgSource.create(1,1,32);
			activeIcons[iconIndex]->xImgSource.setAlphaBuffer(false);
			activeIcons[iconIndex]->xImgSource.fill(0);
			activeIcons[iconIndex]->xImgSource.setAlphaBuffer(true);
			
			
#ifndef ENABLE_FINAL
			qWarning("errore imgBackgroundSeparator");
#endif
		}
		else
		{
			activeIcons[iconIndex]->xImgSource=PixmapB.convertToImage();
			activeIcons[iconIndex]->xImgSource=
				activeIcons[iconIndex]->xImgSource.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
		}
		activeIcons[iconIndex]->xTransparency=
			activeIcons[iconIndex]->xImgSource.createHeuristicMask();
		activeIcons[iconIndex]->xImgShowed=activeIcons[iconIndex]->xImgSource;
		Matrix->xMakeSpace(iconIndex,&activeIcons[iconIndex]->xPosDefault);
		activeIcons[iconIndex]->xPosDefault.setY(activeIcons[iconIndex]->xPosDefault.y()-8);
		activeIcons[iconIndex]->xPosDefault.setX(activeIcons[iconIndex]->xPosDefault.x()-8);
		activeIcons[iconIndex]->xPosition=activeIcons[iconIndex]->xPosDefault;

		PixmapB.resize(0,0);
		}
	}
	}
}


/*!
    \fn XGDocker::xUpdateSmooth()
 */
inline void XGDocker::xUpdateSmooth()
{
	for(long int iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
		if(activeIcons[iconIndex]->xSetUpdate==1)
		{
			activeIcons[iconIndex]->xSetSmoothZoom(activeIcons[iconIndex]->xZoom);
			activeIcons[iconIndex]->xSetUpdate=0;
		}
	}
	
}

inline void XGDocker::xUpdateDrawBackground()
{

	// we calc only 1 time the coords
	// TODO: here we can put an if is changed
	xBar=activeIcons[0]->xPosition.x();
	yBar=activeIcons[0]->xPosDefault.y()-8;
	dxBar=activeIcons[activeIconsCounter-1]->xPosition.x()-
			activeIcons[0]->xPosition.x()+
			activeIcons[activeIconsCounter-1]->xZoom;
	dyBar=ActiveConfiguration->Icons.Size+16;



	// fake background
	// unified to avoid the transparency error
	bitBlt(&paintBuffer,
			0,
			0,
			&imgFakeBackgroundGlobal,Qt::CopyROP);

	// draw background bar
	bitBlt(&paintBuffer,
			xBar,
			yBar,
			&backgroundBar.xImgSource,
			xBar,
			0,
			dxBar,
			dyBar,Qt::CopyROP);
	bitBlt(&paintBuffer,
			xBar-ActiveConfiguration->Icons.Size-16,
			yBar,
			&backgroundBarLeft.xImgSource,
			0,Qt::CopyROP);
	
	bitBlt(&paintBuffer,
			xBar+dxBar,
			yBar,
			&backgroundBarRight.xImgSource,
			0,Qt::CopyROP);
}


inline void XGDocker::xUpdateDrawBackgroundPass2()
{
	bitBlt(&paintBuffer,
			xBar,
			yBar,
			&backgroundBarOver.xImgSource,
			xBar,
			0,
			dxBar,
			dyBar,Qt::CopyROP);
}

/*!
    \fn XGDocker::xDockerRedraw(XGIcon *)
 */
void XGDocker::xDockerRedraw(QObject *findMe)
{
	for(int i=0;i<activeIconsCounter;i++)
	{
		if(findMe==activeIcons[i])
		{
			// Ok we repaint only this icon
			xUpdateRepaint(i);
			return;
		}
	}
}


inline void XGDocker::xUpdateRepaint(int iconIndex)
{
	//qWarning("Updating single icon");
	int bsx=activeIcons[iconIndex]->xPosition.x();
	int bsz=activeIcons[iconIndex]->xZoom;
	bitBlt(&paintBuffer,
			bsx,
			// TODO: Pillow must be external!
			// this will help to avoi the pillow transparency
			0,
			
			&imgFakeBackgroundGlobal,
			
			bsx,
			// TODO: Pillow must be external!
			// this will help to avoi the pillow transparency
			0,
			bsz,
			// TODO: Pillow must be external!
			// this will help to avoi the pillow transparency
			//activeIcons[iconIndex]->xZoom,
			ActiveConfiguration->Window.Height,
			Qt::CopyROP);
	bitBlt(&paintBuffer,
			bsx,
			yBar,
			&backgroundBar.xImgSource,
			bsx,
			0,
			bsz,
			ActiveConfiguration->Window.Height,Qt::CopyROP);
			
		bitBlt(&paintBuffer,
			activeIcons[iconIndex]->xPosition.x(),
			activeIcons[iconIndex]->xPosition.y(),
			&activeIcons[iconIndex]->xImgShowed,0,Qt::CopyROP);
		// Drawing arrow
		// TODO: we are polling status of icon from configuration data it may be null
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.TaskInfo!=NULL)
		{
			
			bitBlt(&paintBuffer,
				activeIcons[iconIndex]->xPosition.x()
				+activeIcons[iconIndex]->xZoom/2
				-ActiveConfiguration->Icons.Size/2,
				activeIcons[iconIndex]->xPosDefault.y(),
				&activeIcons[iconIndex]->xImgArrow,0,Qt::CopyROP);
		}
	bitBlt(&paintBuffer,
			bsx,
			0,
			&backgroundBarOver.xImgSource,
			bsx,
			0,
			bsz,
			ActiveConfiguration->Window.Height,
			Qt::CopyROP);
			
	repaint(QRect(bsx,0,bsz,ActiveConfiguration->Window.Height));
	if(iconIndex==lastIcon)xDrawPillow();
	//tDrawPillow->start(100);
}




/*!
    \fn XGDocker::xGetLayout()
 */
int XGDocker::xGetLayout()
{
	return LayoutPosition;
}


/*!
    \fn XGDocker::xSendToBackground()
 */
void XGDocker::xSendToBackground()
{
	if(ActiveConfiguration->Window.SendToBackground)
	{
		// we have to send it to background
		KWin::setType(winId(), NET::Dock);
		KWin::setStrut( winId(), 0, 0, 0, 0 );
		KWin::setState( winId(), NET::KeepBelow);
		lower();
		xEventDockerHidden();
		
	}
	tAutoSendBGTimer->stop();
}


/*!
    \fn XGDocker::createPopup(KPopup *&,const QObject *)
 */
void XGDocker::createPopup(KPopupMenu *&cpgIcon,const QObject *iiIcon)
{
	cpgIcon=NULL;
	if(!iiIcon)return;
	XGIcon *pgIcon=(XGIcon *)iiIcon;
	for(int i=0;i<activeIconsCounter;i++)
	{
		if(activeIcons[i]==pgIcon)
		{
			int idx=ActiveConfiguration->ObjectsIcons.find(pgIcon->iconConfiguration);
			if(idx>0)
			{
				ActiveConfiguration->ObjectsIcons.at(idx)->PluginPopupMenu=new KPopupMenu();
				cpgIcon=ActiveConfiguration->ObjectsIcons.at(idx)->PluginPopupMenu;
			}
		}
	}
}


/*!
    \fn XGDocker::getPopupMenu(KPopupMenu *&, const QObject *)
 */
void XGDocker::getPopupMenu(KPopupMenu *&cpgIcon, const QObject *iiIcon)
{
	cpgIcon=NULL;
	if(!iiIcon)return;
	XGIcon *pgIcon=(XGIcon *)iiIcon;
	for(int i=0;i<activeIconsCounter;i++)
	{
		if(activeIcons[i]==pgIcon)
		{
			int idx=ActiveConfiguration->ObjectsIcons.find(pgIcon->iconConfiguration);
			if(idx>0)
			{
				cpgIcon=ActiveConfiguration->ObjectsIcons.at(idx)->PluginPopupMenu;
			}
		}
	}
}


/*!
    \fn XGDocker::showRaised()
 */
void XGDocker::showRaised()
{
	xEventDockerShowed();
	QWidget::show();
	KWin::setOnAllDesktops(winId(),true);

		KWin::setState( winId(), NET::StaysOnTop );
		if(LayoutPosition==LONTOP)
		{
			KWin::setStrut( winId(), 0, 0, ActiveConfiguration->Window.HeightDesktop,0);
		}
		else
		if(LayoutPosition==LONBOTTOM)
		{
			KWin::setStrut( winId(), 0, 0, 0,ActiveConfiguration->Window.HeightDesktop);
		}
	tAutoSendBGTimer->stop();

}


/*!
    \fn XGDocker::xFindResource(const QString, QString &)
 */
void XGDocker::xFindResource(const QString rscType, QString &Original)
{
	if(rscType=="icon")
	{
		Original=this->xFindIconFile(Original);
	}
}
