//LabPlot : Plot.h

#ifndef PLOT_H
#define PLOT_H

#include <math.h>
#include "Worksheet.h"
#include "Legend.h"
#include "Label.h"
#include "Axis.h"

class Plot {
public:
	Plot(class Worksheet *p);
	virtual ~Plot() {}
	GraphList *getGraphList() { return graphlist; }
	void clear() {graphlist->clear();}
	void save(QTextStream *t);
	virtual void saveAxes(QTextStream *t) = 0;
	void saveAxis(QTextStream *t,Axis *axis,int gridenabled, int borderenabled, int minorgridenabled);
	void open(QTextStream *t, int version);
	void openAxis(QTextStream *t,int version, Axis *axis,bool *gridenabled,bool *borderenabled, bool *minorgridenabled);
	virtual void openAxes(QTextStream *t, int version) = 0;

	QString TicLabel(int axisnr, int atlf, int prec, QString dtf, double value);
	
	virtual Axis *getAxis(int i) = 0;
	class Legend* getLegend() { return &legend; }
	void setType(PType i) { type = i; }
	PType Type() { return type; }
	Label* Title() { return title; }
	virtual void setRanges(LRange *) = 0;
	LRange* Ranges() { return range;}
	virtual void setActRanges(LRange *) = 0;
	LRange* ActRanges() { return actrange;}
	void setRegionMin(double min) {region.setMin(min);}
	void setRegionMax(double max) {region.setMax(max);}
	double RegionMin() {return region.rMin();}
	double RegionMax() {return region.rMax();}
	bool regionEnabled() { return region_enabled; }
	void setRegionEnabled(bool e) { region_enabled = e; }
	void setTransparent(bool t) { transparent = t; }
	bool Transparent() { return transparent; }
	void setClipOffset(int c) { clipoffset=c;}
	int ClipOffset() { return clipoffset;}

	virtual void enableGrid(int index,bool b) = 0;
	virtual bool gridEnabled(int index) = 0;
	virtual void enableBorder(int index,bool b) = 0;
	virtual bool borderEnabled(int index) = 0;
	bool baselineEnabled() { return baseline_enabled; }
	double Baseline() { return baseline; }
	void setBaselineEnabled(bool e) { baseline_enabled = e; }
	void setBaseline(double b) { baseline = b; }

	virtual void draw(QPainter *p, int w, int h) = 0;
	void drawStyle(QPainter *p, Style s, int oldx, int oldy,int x,int y, int xmin, int xmax, int ymin, int ymax);
	void drawErrorBar(QPainter *p, int x, int y, int xleft, int xright, int ytop, int ybottom);
	virtual void setBorder(int,bool) = 0;
	bool inside(double x, double y) {
		if(x>position.X() && x<position.X()+size.X() && y>position.Y() && y<position.Y()+size.Y())
			return true;
		else
			return false;
	}
	bool insideLegend(int x,int y) { if (legend.inside(x,y)) return true; return false;}
	bool insidePlottingArea(double x,double y) {
		if (x>p1.X() && x<p2.X() && y>p1.Y() && y<p2.Y()) return true; return false;
	}
	bool insideF1Corner(double x, double y) {
		if(fabs(x-position.X()) < 0.01 && fabs(y-position.Y())<0.01)
			return true;
		return false;
	}
	bool insideF2Corner(double x, double y) {
		if(fabs(x-position.X()-size.X()) < 0.01 && fabs(y-position.Y()-size.Y())<0.01)
			return true;
		return false;
	}
	bool insideB1Corner(double x, double y) {
		if(fabs(x-position.X()) < 0.01 && fabs(y-position.Y()-size.Y())<0.01)
			return true;
		return false;
	}
	bool insideB2Corner(double x, double y) {
		if(fabs(x-position.X()-size.X()) < 0.01 && fabs(y-position.Y())<0.01)
			return true;
		return false;
	}
	bool insideX1Border(double x, double y) {
		if(x >position.X() && x<position.X()+size.X() && fabs(y-position.Y()-size.Y())<0.01)
			return true;
		return false;
	}
	bool insideX2Border(double x, double y) {
		if(x >position.X() && x<position.X()+size.X() && fabs(y-position.Y())<0.01)
			return true;
		return false;
	}
	bool insideY1Border(double x, double y) {
		if(y >position.Y() && y<position.Y()+size.Y() && fabs(x-position.X())<0.01)
			return true;
		return false;
	}
	bool insideY2Border(double x, double y) {
		if(y >position.Y() && y<position.Y()+size.Y() && fabs(x-position.X()-size.X())<0.01)
			return true;
		return false;
	}
	bool insideCenter(double x, double y) {
		if(fabs(x-position.X()-size.X()/2.0)<0.01 && fabs(y-position.Y()-size.Y()/2.0)<0.01)
			return true;
		return false;
	}
	void setPosition(Point p) { position = p; }
	void setPosition(double x, double y) { position = Point(x,y); }
	Point Position() { return position; }
	void setSize(Point s) { size = s; }
	void setSize(double x, double y) { size = Point(x,y); }
	Point Size() { return size; }
	void setBackground(QColor c) { bgcolor = c; }
	QColor Background() { return bgcolor; }
	void setGraphBackground(QColor c) { gbgcolor = c;}
	QColor graphBackground() { return gbgcolor; }
	void autoScaleX() {actrange[0].setMin(range[0].rMin());actrange[0].setMax(range[0].rMax());}
	void autoScaleY() {actrange[1].setMin(range[1].rMin());actrange[1].setMax(range[1].rMax());}
	void autoScaleZ() {actrange[2].setMin(range[2].rMin());actrange[2].setMax(range[2].rMax());}
	void setXRange(double x1, double x2) {actrange[0].setMin(x1); actrange[0].setMax(x2); }
	void setYRange(double y1, double y2) {actrange[1].setMin(y1); actrange[1].setMax(y2); }
	void setZRange(double z1, double z2) {actrange[2].setMin(z1); actrange[2].setMax(z2); }

	Point P1() { return p1;}
	Point P2() { return p2;}
	void setP1(Point p) { p1=p;}
	void setP2(Point p) { p2=p;}

	void setXMin(int xmin,int X) { p1.setPoint((xmin/(double)X-position.X())/size.X(),p1.Y()); }
	void setXMax(int xmax,int X) { p2.setPoint((xmax/(double)X-position.X())/size.X(),p2.Y()); }
	void setYMin(int ymin,int Y) { p1.setPoint(p1.X(),(ymin/(double)Y-position.Y())/size.Y()); }
	void setYMax(int ymax,int Y) { p2.setPoint(p2.X(),(ymax/(double)Y-position.Y())/size.Y()); }

	void shiftRight() {double x1=actrange[0].rMin(), x2=actrange[0].rMax();
		actrange[0].setMin(x1-fabs(x2-x1)/3.0);actrange[0].setMax(x2-fabs(x2-x1)/3.0);}
	void shiftLeft() {double x1=actrange[0].rMin(), x2=actrange[0].rMax();
		actrange[0].setMin(x1+fabs(x2-x1)/3.0);actrange[0].setMax(x2+fabs(x2-x1)/3.0);}
	void shiftUp() {double y1=actrange[1].rMin(), y2=actrange[1].rMax();
		actrange[1].setMin(y1-fabs(y2-y1)/3.0);actrange[1].setMax(y2-fabs(y2-y1)/3.0);}
	void shiftDown() {double y1=actrange[1].rMin(), y2=actrange[1].rMax();
		actrange[1].setMin(y1+fabs(y2-y1)/3.0);actrange[1].setMax(y2+fabs(y2-y1)/3.0);}
	void scaleXUp() {double x1=actrange[0].rMin(), x2=actrange[0].rMax();
		actrange[0].setMin(x1+fabs(x2-x1)/4.0);actrange[0].setMax(x2-fabs(x2-x1)/4.0);}
	void scaleXDown() {double x1=actrange[0].rMin(), x2=actrange[0].rMax();
		actrange[0].setMin(x1-fabs(x2-x1)/4.0);actrange[0].setMax(x2+fabs(x2-x1)/4.0);}
	void scaleYUp() {double y1=actrange[1].rMin(), y2=actrange[1].rMax();
		actrange[1].setMin(y1+fabs(y2-y1)/4.0);actrange[1].setMax(y2-fabs(y2-y1)/4.0);}
	void scaleYDown() {double y1=actrange[1].rMin(), y2=actrange[1].rMax();
		actrange[1].setMin(y1-fabs(y2-y1)/4.0);actrange[1].setMax(y2+fabs(y2-y1)/4.0);}
	void scaleZUp() {double z1=actrange[2].rMin(), z2=actrange[2].rMax();
		actrange[2].setMin(z1+fabs(z2-z1)/4.0);actrange[2].setMax(z2-fabs(z2-z1)/4.0);}
	void scaleZDown() {double z1=actrange[2].rMin(), z2=actrange[2].rMax();
		actrange[2].setMin(z1-fabs(z2-z1)/4.0);actrange[2].setMax(z2+fabs(z2-z1)/4.0);}
protected:
	Worksheet *worksheet;			// parent worksheet
	PType type;				// type of the plot
	GraphList *graphlist;			// list of graphs
	Point position, size;				// position and size (0..1)
	Label *title;					// Title
	Legend legend;				// Legend
	QColor bgcolor, gbgcolor;		// background & graph background color
	Point p1, p2;					// plotting area	(0..1)
	LRange range[3];				// graph ranges	(x,y,z)
	LRange actrange[3];			// actual plotting range (x,y,z)
	double baseline;				// baseline
	bool baseline_enabled;			// draw it ?
	LRange region;				// region
	bool region_enabled;			// draw it ?
	bool transparent;				// draw bgcolor & gbgcolor ?
	int clipoffset;					// offset for clipping area drawing (Symbols->full drawn, line section->limited)
};

#ifndef HAVE_LOG2
inline double log2(double x) {return log(x)/log(2.0);}
#endif

#endif // PLOT_H
