#ifndef __dns_h
#define __dns_h

/* for DNS_O_QUERY, DNS_O_IQUERY */
#define RESPONSE_ANSWER		6
#define RESPONSE_AUTHORITY	8
#define RESPONSE_ADDITIONAL	10

/* for DNS_O_UPDATE */
#define REQUEST_PRE		6
#define REQUEST_UPDATE		8

/* opcodes */
#define DNS_O_QUERY	0x0
#define DNS_O_IQUERY	0x1
#define DNS_O_STATUS	0x2
#define DNS_O_NOTIFY	0x4
#define DNS_O_UPDATE	0x5
#define DNS_O_RELEASE	0x6
#define DNS_O_NBREFRESH	0x9

/* classes */
#define DNS_C_IN	"\000\001"
#define DNS_C_ANY	"\000\377"
#define DNS_C_NONE	"\000\376"

/* rr-types */
#define DNS_T_A		"\000\001"
#define DNS_T_NS	"\000\002"
#define DNS_T_CNAME	"\000\005"
#define DNS_T_SOA	"\000\006"
#define DNS_T_PTR	"\000\014"
#define DNS_T_HINFO	"\000\015"
#define DNS_T_MX	"\000\017"
#define DNS_T_TXT	"\000\020"
#define DNS_T_RP	"\000\021"
#define DNS_T_SIG	"\000\030"
#define DNS_T_KEY	"\000\031"
#define DNS_T_AAAA	"\000\034"
#define DNS_T_NB	"\000\040"
#define DNS_T_SRV	"\000\041"
#define DNS_T_IXFR	"\000\373"
#define DNS_T_AXFR	"\000\374"
#define DNS_T_ANY	"\000\377"

/* rr codes */
#define DNS_R_NOERROR	0
#define DNS_R_FORMERR	1
#define DNS_R_SERVFAIL	2
#define DNS_R_NXDOMAIN	3
#define DNS_R_NOTIMP	4
#define DNS_R_REFUSED	5
#define DNS_R_YXDOMAIN	6
#define DNS_R_YXRRSET	7
#define DNS_R_NXRRSET	8
#define DNS_R_NOTAUTH	9
#define DNS_R_NOTZONE	10

#endif
