//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//


#ifndef _socket_exception_classes_
#define _socket_exception_classes_


#include <string>


namespace sockets
{
  //
  // base exception class
  //
  class exception
  {
  public:
    exception ( const std::string s ) : m_s ( s ) {}
    ~exception () {}

    std::string description() const { return m_s; }

  private:
    std::string m_s;
  };


  //
  // socket exception
  //
  class socket_exception : public exception
  {
  public:
    socket_exception ( const std::string s ) : exception ( s ) {}
    ~socket_exception () {}
  };


}

#endif
