package Lire::Config::ScalarSpec;

use strict;

=pod

=head1 Lire::Config::ScalarSpec

Describes an abstract type for scalar configuration variables.

=cut

use base qw/Lire::Config::TypeSpec/;

use Lire::Config::Scalar;

use Carp;

sub instance_class {
    return "Lire::Config::Scalar";
}

=pod

=head2 is_valid( $value )

Returns true if $value is appropriate for that parameter type. $value
is the value has entered by the user for example.

=cut

sub is_valid {
    croak("is_valid() method not implemented in ", ref $_[0] );
}

=pod

=head2 normalize( $value )

This method returns the $value normalized for this type.

=cut

sub normalize {
    croak("normalize() method not implemented in ", ref $_[0] );
}

1;
__END__

=pod

=head1 VERSION

$Id: ScalarSpec.pm,v 1.3 2004/05/27 14:58:29 flacoste Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wessel Dankers <wsl@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
