package tests::ConfigReportSectionSpecTest;

use strict;

use tests::ConfigSpecTest;

use base qw/tests::ConfigTypeSpecBase/;

use Lire::Config::ReportSectionSpec;

sub new {
    my $self = shift->SUPER::new( @_ );

    return $self;
}

sub set_up {
    my $self = $_[0];

    $self->SUPER::set_up();
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub type {
    return 'Lire::Config::ReportSectionSpec';
}

sub test_new {
    my $self = $_[0];

    $self->SUPER::test_new();

    my $spec = new Lire::Config::ReportSectionSpec( 'name' => 'section' );
    $self->assert_str_equals( 'Lire::ReportSection', $spec->class() );
    $self->assert_str_equals( 'title', $spec->label_component() );

    my $components = [ $spec->components() ];
    $self->assert_num_equals( 4, scalar @$components );
    $self->assert_isa( 'Lire::Config::StringSpec', $components->[0] );
    $self->assert_str_equals( 'title', $components->[0]->name() );
    $self->assert_not_null( $components->[0]->summary() );
    $self->assert_not_null( $components->[0]->text_description() );

    $self->assert_isa( 'Lire::Config::DlfSchemaSpec', $components->[1] );
    $self->assert_str_equals( 'superservice', $components->[1]->name() );
    $self->assert_num_equals( 1, $components->[1]->superservices() );
    $self->assert_not_null( $components->[1]->summary() );
    $self->assert_not_null( $components->[1]->text_description() );

    $self->assert_isa( 'Lire::Config::XMLSpecListSpec', $components->[2] );
    $self->assert_str_equals( 'filters', $components->[2]->name() );
    $self->assert_str_equals( 'filters', $components->[2]->type() );
    $self->assert_not_null( $components->[2]->summary() );
    $self->assert_not_null( $components->[2]->text_description() );

    $self->assert_isa( 'Lire::Config::XMLSpecListSpec', $components->[3] );
    $self->assert_str_equals( 'specs', $components->[3]->name() );
    $self->assert_str_equals( 'reports', $components->[3]->type() );
    $self->assert_not_null( $components->[3]->summary() );
    $self->assert_not_null( $components->[3]->text_description() );
}

1;

