package tests::UserAgentCategoriserTest;

use strict;

use base qw/Lire::Test::DlfAnalyserTestCase/;

use Lire::DlfAnalysers::UserAgentCategoriser;
use File::Basename;

sub schemasdir {
    return dirname( __FILE__ ) . "/../..";
}

sub create_analyser {
    return new Lire::DlfAnalysers::UserAgentCategoriser();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../../www-user_agent_init";
}

sub test_categorise {
    my $self = $_[0];

    my $analyser = $self->create_analyser();
    $analyser->initialise();
    $self->assert_isa( 'Lire::WWW::UserAgent', $analyser->{'analyser'},  );

    my $dlf = { 'useragent' => undef };
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'os'} );
    $self->assert_null( $dlf->{'lang'} );
    $self->assert_null( $dlf->{'browser'} );

    $dlf->{'useragent'} = 'My Custom Browser';
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'os'} );
    $self->assert_null( $dlf->{'lang'} );
    $self->assert_null( $dlf->{'browser'} );

    $dlf->{'useragent'} = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; fr)';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'MS Internet Exporer', $dlf->{'browser'} );
    $self->assert_str_equals( 'Windows', $dlf->{'os'} );
    $self->assert_str_equals( 'French', $dlf->{'lang'} );

    return;
}


1;
