import pygtk
pygtk.require("2.0")

import unittest
import os
import shutil

import MetaData
import ThumbnailArea


class FakeView:

    def set_status_text(self, text):
    	pass
	
    def set_progress(self, fraction):
    	pass

class ImportTests(unittest.TestCase):

    dirname = u"unittest-import.lodju"

    def remove_dir(self):
    	if os.path.exists(self.dirname):
	    shutil.rmtree(self.dirname)

    def setUp(self):
    	self.remove_dir()
	
    def tearDown(self):
    	self.remove_dir()

    def testImportTask(self):
	doc = MetaData.Document()
	doc.storage.rename(self.dirname)
    	task = ThumbnailArea.ImportTask(FakeView())

    	thumbs = []
	try:
	    files = os.listdir(u"test-photos")[:1]
	except OSError:
	    return
    	for name in files:
	    photo = MetaData.Photo()
	    photo[u"imported-from"] = os.path.join(u"test-photos", name)
	    thumbs.append(ThumbnailArea.Thumbnail(doc, photo, None))

    	self.failUnlessEqual(task.unimported, [])
	for thumb in thumbs:
	    task.add(doc, thumb)
    	self.failUnlessEqual(len(task.unimported), len(thumbs))
	while task.work():
	    pass

    	self.failUnless(os.path.isdir(self.dirname))

    	orignew = os.path.join(self.dirname, u"orig.new")
	origfile = os.path.join(orignew, photo[u"id"])
    	self.failUnless(os.path.isdir(orignew))
    	self.failUnless(os.path.isfile(origfile))

    	thumbnew = os.path.join(self.dirname, u"thumb.new")
	thumbfile = os.path.join(orignew, photo[u"id"])
    	self.failUnless(os.path.isdir(thumbnew))
    	self.failUnless(os.path.isfile(thumbfile))

    	self.failIfEqual(thumb.pixbuf_thumb_orig, None)


class DnDTests(unittest.TestCase):

    def nop(self, *args):
    	pass

    def testDragDataGet(self):
    	if os.path.exists("/usr/bin/rxp"):
	    doc = MetaData.Document()
	    task = ThumbnailArea.ImportTask(FakeView())
	    model = ThumbnailArea.Model(doc, self.nop, task)
    
    	    photo = MetaData.Photo()
	    folder = MetaData.Folder()
	    folder.photos.add(photo)
	    model.set_folders([folder])
	    model.select_all()
	    
	    f = os.popen("rxp -Vs", "w")
	    f.write(model.get_drag_data())
	    exit = f.close()
	    self.failUnlessEqual(exit, None)

    	    doc.storage.discard()
