/*
 * ftpsys_netware.cpp
 * Copyright (C) 2002 Jaroslav Rohel <rohel@kn.vutbr.cz>
 *               inspired by ftpsys_unix writen by Florian Malita <mali@go.ro>
 *
 * This file is part of LUFS, a free userspace filesystem implementation.
 * See http://lufs.sourceforge.net/ for updates.
 *
 * LUFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LUFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>

#ifndef __USE_XOPEN
#define __USE_XOPEN
#endif
#include <time.h>

#include <lufs/proto.h>
#include <lufs/fs.h>

#include "ftpsys.h"
#include "ftpsys_netware.h"

static char*
next_word(char *c){
    while( (*c != ' ') && (*c != 0))
	c++;
    if(! *c)
	return c;

    while(*c == ' ')
	c++;    
    return c;
}

static char*
nth_word(char *line, int n){
  int i;
  char *c;

  for(c = line, i = 0; (c != NULL) && (i < n); i++)
    c = next_word(c);

  return c;
}

ftpsys_netware::ftpsys_netware(){
    CMD_LIST = "LIST -al";
}

ftpsys_netware::~ftpsys_netware(){

}

int
ftpsys_netware::parse_line(char *buf, char *file, struct lufs_fattr *fattr, char *link, struct credentials *cred){
    unsigned long nlink, size;
    int res, own = 0;
    struct tm tm;
    time_t tt;
    char user[32], month[5], day[5], year[6], date[20];
    char *c, *cc;

    *file = *link = user[0] = month[0] = day[0] = year[0] = 0;

    nlink = 1;
    if((res = sscanf(buf, "%*2s %*12s %32s %lu %3s %2s %5s %1024s", user, &size, month, day, year, file)) < 6){
	WARN("could only match "<<res<<" attributes!");

	return -1;
    }

    sprintf(date,"%s,%s,%s", year, month, day);
    tt = time(NULL);
    memcpy(&tm, gmtime(&tt), sizeof(struct tm));
    tm.tm_sec = tm.tm_min = tm.tm_hour = 0;
    if(strchr(year, ':'))
	strptime(date, "%H:%M,%b,%d", &tm);
    else
	strptime(date, "%Y,%b,%d", &tm);

    if(!strcmp(cred->user, user))
	own = 1;
    
    memset(fattr, 0, sizeof(struct lufs_fattr));
    fattr->f_nlink = nlink;
    fattr->f_size = size;
    fattr->f_ctime = fattr->f_mtime = fattr->f_atime = mktime(&tm);

    if(tolower(buf[0]) == 'd') fattr->f_mode = S_IFDIR;
    else fattr->f_mode = S_IFREG;
    
    fattr->f_mode |= S_IRUSR | S_IRGRP | S_IROTH | S_IWUSR | S_IWGRP | S_IWOTH;
    if (fattr->f_mode & S_IFDIR) fattr->f_mode |= S_IXUSR | S_IXGRP | S_IXOTH;

    for(c = buf; *c; c++){
	if((*c == 0x0a) || (*c == 0x0d)){
	    *c = 0;
	    break;
	}
    }

    if((c = nth_word(buf, 8))){

      TRACE("left: " << c);
      cc=strstr(c, "->");
      if(cc != NULL){
	*(cc-1) = 0;
	strcpy(file, c);
	strcpy(link, (cc + 3));
      }else{
	strcpy(file, c);
      }

      TRACE("file: " << file<<", link: " << link);
      return 0;
    }else
      return -1;
}
