/*
 * sftplib.h
 * Copyright (C) 2002 Florin Malita <mali@go.ro>
 *
 * This file is part of LUFS, a free userspace filesystem implementation.
 * See http://lufs.sourceforge.net/ for updates.
 *
 * LUFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LUFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _SFTPLIB_H_
#define _SFTPLIB_H_

#include <inttypes.h>
#include <sys/uio.h>

#include <string>

using namespace std;

#define MAXDATA		32768

#define SSH2_FILEXFER_VERSION		3

/* client to server */
#define SSH2_FXP_INIT			1
#define SSH2_FXP_OPEN			3
#define SSH2_FXP_CLOSE			4
#define SSH2_FXP_READ			5
#define SSH2_FXP_WRITE			6
#define SSH2_FXP_LSTAT			7
#define SSH2_FXP_STAT_VERSION_0		7
#define SSH2_FXP_FSTAT			8
#define SSH2_FXP_SETSTAT		9
#define SSH2_FXP_FSETSTAT		10
#define SSH2_FXP_OPENDIR		11
#define SSH2_FXP_READDIR		12
#define SSH2_FXP_REMOVE			13
#define SSH2_FXP_MKDIR			14
#define SSH2_FXP_RMDIR			15
#define SSH2_FXP_REALPATH		16
#define SSH2_FXP_STAT			17
#define SSH2_FXP_RENAME			18
#define SSH2_FXP_READLINK		19
#define SSH2_FXP_SYMLINK		20

/* server to client */
#define SSH2_FXP_VERSION		2
#define SSH2_FXP_STATUS			101
#define SSH2_FXP_HANDLE			102
#define SSH2_FXP_DATA			103
#define SSH2_FXP_NAME			104
#define SSH2_FXP_ATTRS			105

#define SSH2_FXP_EXTENDED		200
#define SSH2_FXP_EXTENDED_REPLY		201

/* attributes */
#define SSH2_FILEXFER_ATTR_SIZE		0x00000001
#define SSH2_FILEXFER_ATTR_UIDGID	0x00000002
#define SSH2_FILEXFER_ATTR_PERMISSIONS	0x00000004
#define SSH2_FILEXFER_ATTR_ACMODTIME	0x00000008
#define SSH2_FILEXFER_ATTR_EXTENDED	0x80000000

/* portable open modes */
#define SSH2_FXF_READ			0x00000001
#define SSH2_FXF_WRITE			0x00000002
#define SSH2_FXF_APPEND			0x00000004
#define SSH2_FXF_CREAT			0x00000008
#define SSH2_FXF_TRUNC			0x00000010
#define SSH2_FXF_EXCL			0x00000020

/* status messages */
#define SSH2_FX_OK			0
#define SSH2_FX_EOF			1
#define SSH2_FX_NO_SUCH_FILE		2
#define SSH2_FX_PERMISSION_DENIED	3
#define SSH2_FX_FAILURE			4
#define SSH2_FX_BAD_MESSAGE		5
#define SSH2_FX_NO_CONNECTION		6
#define SSH2_FX_CONNECTION_LOST		7
#define SSH2_FX_OP_UNSUPPORTED		8
#define SSH2_FX_MAX			8

#define ATTRSIZE	24 
struct s_attr{
    uint32_t	flags;
    uint64_t	size;
    uint32_t	permissions;
    uint32_t	atime;
    uint32_t	mtime;
};

#define HDRSIZE      	5
struct s_hdr{
    uint32_t	len;
    uint8_t	type;
};

class SConnection {
  private:
    int connected;
    int f_in, f_out;
    int sshpid;
    unsigned seq;
    string username;
    string host;
    int port;
    int last_cmd;
    
    struct {
	string handle;
	long long offset;
	unsigned long count;
    } readcache;

  public:
    char buf[MAXDATA];
//    int ksock;

    SConnection();
    ~SConnection();
    
    int connect(char*, char*, int);
    void disconnect();
    int reconnect();
    void show_error(int);
    int check_reply(int, int);
    int check_status(int, int);
    int atomic_read(char*, int);
    int atomic_write(char*, int);
    int send_packet(unsigned, void*, unsigned);
    int send_packet(unsigned, struct iovec*, int);
    int recv_packet(struct s_hdr*, void*, unsigned);
    int execute(unsigned, void*, unsigned, struct s_hdr*);
    int execute(unsigned, struct iovec*, int, struct s_hdr*);


    string opendir(char*);
    string open(char*, unsigned);
    int create(char*, unsigned);
    int read(string&, long long, unsigned long, char*);
    int write(string&, long long, unsigned long, char*);
    int close(string&);
    int readdir(string&);
    char* attr2fattr(char*, struct lufs_fattr*);
    int lname2fattr(string&, struct lufs_fattr*);
    int readlink(char*);
    int mkdir(char*, int mode);
    int rmdir(char*);
    int remove(char*);
    int rename(char*, char*);
    int setattr(char*, struct lufs_fattr*);
    int symlink(char*, char*);
    int stat(char*, struct lufs_fattr*);
};

void hton(void*, ...);
void ntoh(void*, ...);


#endif
