/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  value_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_VALUE_IFACE_H
#define INTI_ATK_VALUE_IFACE_H

namespace Inti {

namespace Atk {

class ValueIface
{
public:
	static void init(AtkValueIface *g_iface);

	static void get_current_value_proxy(AtkValue *obj, GValue *value);

	static void get_maximum_value_proxy(AtkValue *obj, GValue *value);

	static void get_minimum_value_proxy(AtkValue *obj, GValue *value);

	static gboolean set_current_value_proxy(AtkValue *obj, const GValue *value);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_VALUE_IFACE_H
