/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  registry.cc - AtkRegistry C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "registry.h"
#include "private/registry_p.h"
#include "objectfactory.h"

using namespace Inti;

/*  Atk::Registry
 */

Atk::Registry::Registry(AtkRegistry *registry, bool reference)
: G::Object((GObject*)registry, reference)
{
}
	
Atk::Registry::~Registry()
{
}
	
AtkRegistryClass* 
Atk::Registry::atk_registry_class() const 
{ 
	return get_class<AtkRegistryClass>(); 
}
	
Atk::Registry::operator AtkRegistry* () const 
{
	return this ? atk_registry() : 0; 
}
	
Atk::Registry* 
Atk::Registry::get_default()
{
	return G::Object::wrap<Registry>(atk_get_default_registry());
}

GType
Atk::Registry::get_factory_type(GType type) const
{
	return atk_registry_get_factory_type(atk_registry(), type);
}

Atk::ObjectFactory*
Atk::Registry::get_factory(GType type) const
{
	return G::Object::wrap<ObjectFactory>(atk_registry_get_factory(atk_registry(), type));
}

void 
Atk::Registry::set_factory_type(GType type, GType factory_type)
{
 	atk_registry_set_factory_type(atk_registry(), type, factory_type);
}

/*  Atk::RegistryClass
 */

void
Atk::RegistryClass::init(AtkRegistryClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
}

GType
Atk::RegistryClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(ATK_TYPE_REGISTRY, (GClassInitFunc)init);
	}
	return type;
}

void*
Atk::RegistryClass::create()
{
	return g_object_new(get_type(), 0);
}

