/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/core.h
//! @brief The core GUI header file.
//!
//! This header file is for convenience. It includes the header files needed
//! by all applications. Note,<inti/gtk/dialog.h> includes all the header files
//! in it's inheritance path. These are: <inti/gtk/window.h>, <inti/gtk/bin.h>, 
//! <inti/gtk/container.h>, <inti/gtk/widget.h>, <inti/gtk/object.h> and
//! <inti/glib/object.h>.

#ifndef INTI_CORE_H
#define INTI_CORE_H

#ifndef INTI_GTK_DIALOG
#include <inti/gtk/dialog.h>
#endif

#ifndef INTI_GTK_BOX
#include <inti/gtk/box.h>
#endif

#endif // INTI_CORE_H
