/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  drawable_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GDK_DRAWABLE_CLASS_H
#define INTI_GDK_DRAWABLE_CLASS_H

#include <inti/glib/private/object_p.h>

namespace Inti {

namespace Gdk {

class DrawableClass
{
public:
	static void init(GdkDrawableClass *g_class);

	static GType get_type();

	static void* create();

	static GdkGC* create_gc_proxy(GdkDrawable *drawable, GdkGCValues *values, GdkGCValuesMask mask);

	static void draw_rectangle_proxy(GdkDrawable *drawable, GdkGC *gc, gint filled, gint x, gint y, gint width, gint height);

	static void draw_arc_proxy(GdkDrawable *drawable, GdkGC *gc, gint filled, gint x, gint y, gint width, gint height, gint angle1, gint angle2);

	static void draw_polygon_proxy(GdkDrawable *drawable, GdkGC *gc, gint filled, GdkPoint *points, gint npoints);

	static void draw_drawable_proxy(GdkDrawable *drawable, GdkGC *gc, GdkDrawable *src, gint xsrc, gint ysrc, gint xdest, gint ydest, gint width, gint height);

	static void draw_points_proxy(GdkDrawable *drawable, GdkGC *gc, GdkPoint *points, gint npoints);

	static void draw_segments_proxy(GdkDrawable *drawable, GdkGC *gc, GdkSegment *segs, gint nsegs);

	static void draw_lines_proxy(GdkDrawable *drawable, GdkGC *gc, GdkPoint *points, gint npoints);

	static void draw_glyphs_proxy(GdkDrawable *drawable, GdkGC *gc, PangoFont *font, gint  x, gint y, PangoGlyphString *glyphs);

	static void draw_image_proxy(GdkDrawable *drawable, GdkGC *gc, GdkImage *image, gint xsrc, gint ysrc, gint xdest, gint ydest, gint width, gint height);

	static gint get_depth_proxy(GdkDrawable *drawable);

	static void get_size_proxy(GdkDrawable *drawable, gint *width, gint *height);

	static void set_colormap_proxy(GdkDrawable *drawable, GdkColormap *cmap);

	static GdkColormap* get_colormap_proxy(GdkDrawable *drawable);

	static GdkVisual* get_visual_proxy(GdkDrawable *drawable);

	static GdkImage* get_image_proxy(GdkDrawable *drawable, gint x, gint  y, gint width, gint height);

	static GdkRegion* get_clip_region_proxy(GdkDrawable *drawable);

	static GdkRegion* get_visible_region_proxy(GdkDrawable *drawable);
};

} // namespace Gdk

} // namespace Inti

#endif // INTI_GDK_DRAWABLE_CLASS_H
