/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  object_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_G_OBJECT_CLASS_H
#define INTI_G_OBJECT_CLASS_H

namespace Inti {

namespace G {

class ObjectClass
{
public:
	static void init(GObjectClass *g_class);

	static GType get_type();

	static void* create();

// Methods
	static void set_property_proxy(GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);

	static void get_property_proxy(GObject *object, guint property_id, GValue *value, GParamSpec *pspec);

	static void dispose_proxy(GObject *object);

	static void finalize_proxy(GObject *object);

// Signals
	static void notify_proxy(GObject *object, GParamSpec *pspec);
};

} // namespace G

} // namespace Inti

#endif // INTI_G_OBJECT_CLASS_H

